uniform sampler2D texture1;
uniform sampler2D texture2;
uniform float time = 1.0;

float tau = 6.283;

vec2 c2p(vec2 xy){
    return vec2(length(xy), atan(xy.y, xy.x)/tau+0.5);
}

void main( out vec4 O, vec2 U )
{
	vec2 crd = gl_TexCoord[0].xy;
    vec2 mul = vec2(1.15, 5.0); 
    vec2 add = vec2(-time, .1*time); 
	vec2 cpos = crd-.5;
    vec2 ppos = c2p(cpos);
    vec2 fpos = (vec2(-sqrt(.60/ppos.x),ppos.y) + add) * mul;

	vec4 color = texture2D(texture1, fpos);
	
	//	"r":"{return Math.sin(getSceneTimeFromStart()*5+ 7) * 127 + 127;}",
	//	"g":"{return Math.sin(getSceneTimeFromStart()*5+ 5) * 127 + 127;}",
	//	"b":"{return Math.sin(getSceneTimeFromStart()*5+ 3) * 127 + 127;}"
	color.r*=sin(time*5+7)*.5+.55;
	color.g*=sin(time*5+5)*.5+.55;
	color.b*=sin(time*5+3)*.5+.55;


	gl_FragColor = color;

	
}