// include "gl.js"
// include "raymarch.js"
// include "constants.js"
// include "animations.css"
// include "kkontent.js"

function initializeDocument()
{
    // Function initializes the document body for our needs

    document.body.style = 'width:100%;height:100%;margin:0;padding:0;'
                          +'overflow:hidden;text-align:center;';
}

function initializeWebGL()
{
    // Function initializes webgl-canvas in background and begins the raymarch

    var canvas = document.createElement('canvas');
    canvas.width = RESOLUTION[0];
    canvas.height = RESOLUTION[1];
    canvas.style.position = 'absolute';
    canvas.style.width = '100%';
    canvas.style.height = '100%';
    canvas.style.top = 0; canvas.style.left = 0;
    canvas.style.zindex = -1;
    document.body.appendChild(canvas);
    var gl = canvas.getContext('webgl',{preserveDrawingBuffer: true});
    if (!gl) {
        alert('Webgl ei toimi, homo.');
    }

    gl.viewport(0, 0, gl.canvas.width, gl.canvas.height);
    gl.enable(gl.BLEND);
    gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);

    // Start the raymarch
    return gl

}

function initializeMarch(gl, vertexSrc, fragmentSrc)
{
    // Initialize 1st raymarch scene and return loctations for it's uniforms
    // return: positionLoc, resolutionLoc, timeLoc, camLoc

    // Create shaders
    var VSrc = document.getElementById(vertexSrc).text;
    var FSrc = document.getElementById(fragmentSrc).text;
    var vertexShader = createShader(gl, gl.VERTEX_SHADER, VSrc);
    var fragmentShader = createShader(gl, gl.FRAGMENT_SHADER, FSrc);

    var program = createProgram(gl, vertexShader, fragmentShader);

    // Get locations --------------------------------------------------------
    var positionLoc = gl.getAttribLocation(program, 'position');
    var resolutionLoc = gl.getUniformLocation(program, 'iResolution');
    var timeLoc = gl.getUniformLocation(program, 'iTime');
    var camLoc = gl.getUniformLocation(program, 'iCamera');
    var beatLoc = gl.getUniformLocation(program, 'iBeat');
    // end of getting locations ---------------------------------------------

    // Create one square to the buffer to use as a canvas for raymarching
    var positionBuffer = gl.createBuffer();
    gl.bindBuffer(gl.ARRAY_BUFFER, positionBuffer);
    setGeometry(gl, [-1,-1,0,1,-1,0,1,1,0,1,1,0,-1,1,0,-1,-1,0]);

    return [positionLoc, resolutionLoc, timeLoc, camLoc, positionBuffer, 
            program, beatLoc];
}

function initializeDftTexture(gl) 
{
    gl.activeTexture(gl.TEXTURE0);                                              
    audioTexture = gl.createTexture();                                          
    gl.bindTexture(gl.TEXTURE_2D, audioTexture);                                
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.MIRRORED_REPEAT);     
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.REPEAT);              
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);         
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);         
    return audioTexture;
}

function initializeMusicFromFile(fname)
{
    var audio = new analyzeAudioSource(AUDIODIR+fname);
    return audio;
}

