#version 430 core

layout (location=0) out vec4 color;

layout (location=1) uniform int t;
in vec2 coord;

uniform sampler2D inColor;
uniform sampler2D inBright;

float gamma(in float time)
{
	return 1.0;
	//return 2.2;
}

float exposure(in float time)
{
	return 1.0f;
}

float worth(in int i, in int j)
{
	float weight[5] = float[](0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);
	return weight[abs(i)] * weight[abs(j)];
}

vec3 bloom(in vec2 texcoord)
{
	vec3 result = vec3(0);
	vec2 textStep = 1.0 / textureSize(inBright, 0);
	for(int i = -4; i <= 4; ++i)
	{
		for(int j = -4; j <= 4; ++j)
		{
			result += texture(inBright, texcoord + vec2(i * textStep.x, j * textStep.y)).rgb * worth(i, j);
		}
	}
	return result;
}

float fade(in float time)
{
	float times[8] = float[](0.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0);
	float dist = 1000.0;
	for(int i = 0; i < 8; ++i)
	{
		dist = min(dist, abs(time - times[i]));
	}
	return clamp(dist * 2.0, 0.0, 1.0);
}

void main()
{
	float time = t * 0.001;
	vec2 texcoord = (coord + vec2(1.0)) * 0.5;

	vec3 hdrColor = texture(inColor, texcoord).rgb;
	vec3 bloomColor = bloom(texcoord);

	// Tone map and gamma correct
	vec3 expColor = vec3(1.0) - exp(-(hdrColor+bloomColor) * exposure(time));
	//vec3 expColor = hdrColor + bloomColor;
	vec3 result = pow(expColor, vec3(1.0 / gamma(time)));
	result *= fade(time);
	//vec3 result = hdrColor;
	color = vec4(result, 1.0);
}
