#!/bin/bash

# clean the shader file
echo "" > int/shaders.h

# Add shaders to the .h files
echo "const char* vshader = " >> int/shaders.h
while read -r line
do
	echo "\"$line\\n\"" >> int/shaders.h
done < res/demo.vert
echo ";" >> int/shaders.h

echo "" >> int/shaders.h
echo "const char* fshader = " >> int/shaders.h
while read -r line
do
	echo "\"$line\\n\"" >> int/shaders.h
done < res/demo.frag
echo ";" >> int/shaders.h

echo "" >> int/shaders.h
echo "const char* fpost = " >> int/shaders.h
while read -r line
do
	echo "\"$line\\n\"" >> int/shaders.h
done < res/post.frag
echo ";" >> int/shaders.h

# Copy main to int
cp src/main.c int/
# Copy syna to int
cp src/syna.h int/

# build the demo
gcc -std=c99 -O2 -D_REENTRANT -I/usr/include/libdrm -o bin/intro int/main.c -L/usr/lib/x86_64-linux-gnu -lSDL2 -lGL -lm
if [ $? -ne 0 ]; then
	exit $retval
fi
gcc -std=c99 -Os -D_REENTRANT -I/usr/include/libdrm -o bin/small int/main.c -L/usr/lib/x86_64-linux-gnu -lSDL2 -lGL -lm
if [ $? -ne 0 ]; then
	exit $retval
fi

# Strip the smaller file
strip -R .comment bin/small
strip -R .note.gnu.build-id bin/small
echo '#!/bin/sh' > bin/smaller
echo 'tail -n+3 $0|unxz>i;chmod +x i;./i;rm -f i;exit' >> bin/smaller
xz -c6 --format=lzma bin/small >> bin/smaller
chmod +x bin/smaller

# Run
./bin/intro
