var gloepstat = document.getElementById("gloepnum");
var cdcstat = document.getElementById("cdcnum");
var cdcspentstat = document.getElementById("cdcspentnum");
var prodstat = document.getElementById("prodnum");

var prodtitle = document.getElementById('prod-title');
var screenshot = document.getElementById('screenshot').firstChild;
var platformOs = document.getElementById("platform_os");
var platformName = document.getElementById("platform_name");
var entrytype = document.getElementById("entrytype");
var entrytypeName = document.getElementById("entrytypeName");
var releasedate = document.getElementById("releasedate");
var party = document.getElementById("party");
var partyYear = document.getElementById("party.year");
var compo = document.getElementById("compo");
var rank = document.getElementById("rank");
var nRulez = document.getElementById("nRulez");
var nOk = document.getElementById("nOk");
var nSuxx = document.getElementById("nSuxx");
var nAvg = document.getElementById("nAvg");
var nAvgImg = document.getElementById("nAvgImg");
var popularityText = document.getElementById("popularityText");
var popularityBar = document.getElementById("popularityBar");
var download = document.getElementById("mainDownloadLink");
var demozoo = document.getElementById("demozoo");
var prodCdc = document.getElementById("cdc");
var nCdc = document.getElementById("nCdc");

var gloeprul = document.getElementById("gloeprul");
var gloeppig = document.getElementById("gloeppig");
var gloepsux = document.getElementById("gloepsux");

var commentDiv = document.getElementById("comment");
var commentRating = document.getElementById("commentRating");
var commentDate = document.getElementById("commentDate");
var commentUser = document.getElementById("commentUser");
var commentAvatar = document.getElementById("commentAvatar");

var topglop = document.getElementById('topglop');
var myglop = document.getElementById('myglop');
var mygloptext = myglop.getElementsByClassName('group')[0];

var firstFeature = document.getElementById("pouetbox_cdc");
var featureBar = document.getElementById("leftbar");
var timers = [];

var logo = document.getElementById('logoImg');

var music = audio["The Jumping Mouse"];
music.loop = true;
var powerup = audio["powerup"];

var gloeps = 0;
var cdc = 0;
var cdcSpent = 0;
var cdcSpentCurrent = 0;
var gloepsNextCdc = 2;
var prodnum = 23;
var gloepperprod = 1;

var gloepfadefn = function(gloepimg) {
	gloepimg.fadeval *= 1.2;
	gloepimg.style.transform = 'scale(' + gloepimg.fadeval + ') rotate(' + (gloepimg.fadeval*-0.02+0.3) + 'rad)';
	var opacity = 1. / gloepimg.fadeval;
	if (opacity < 0.1) {
		opacity = 0;
		clearInterval(gloepimg.fadetimer);
		gloepimg.fadetimer = null;
	}
	gloepimg.style.opacity = opacity;
};

var gloep = function(e, rating)
{
	var clickId = Math.min(parseInt(Math.sqrt(gloepperprod)), 10);
	var click = audio[clickId];
	if (click.currentTime > 0.5)
	{
		click.currentTime = 0;
	}
	click.play();

	addgloep(gloepperprod);
	switchprod(rating);
	
	e.stopPropagation();
	//e.preventDefault();
	
	var gloepimg = gloeppig;
	if (rating === 'rulez') gloepimg = gloeprul;
	else if (rating === 'sucks') gloepimg = gloepsux;

	if (gloepimg.fadetimer) {
		if (gloepimg.fadeval < 4) {
			return;
		}
		clearInterval(gloepimg.fadetimer);
	}
	gloepimg.fadeval = 0.7;
	gloepimg.fadetimer = setInterval(gloepfadefn, 50, gloepimg);
}

var addgloep = function(num) {
	gloeps += num;
	gloepstat.textContent = gloeps.toFixed(0);
	cdcspentstat.textContent = cdcSpent;

	var lastCdc = cdc;
	var repeat = 23;
	while (gloeps >= gloepsNextCdc)
	{
		cdc++;
		gloepsNextCdc *= 2;
		cdcstat.textContent = cdc.toFixed(0);
		if (!(--repeat)) break;
	}
	if (firstFeature)
	{
		firstFeature.parentNode.removeChild(firstFeature);
		firstFeature = null;
		
		music.play();
	}
}

var updateprodcnt = function()
{
	prodstat.textContent = prodnum.toFixed(0);		
}

var months = ['january', 'FEBruary', 'mars', 'april', 'may', 'june', 'youly', 'ouwwgust', 'september', 'oct(ober)', 'november', 'dec(ember)'];
var timeFormat = new Intl.DateTimeFormat('en-US', {
  year: 'numeric', month: 'numeric', day: 'numeric',
  hour: 'numeric', minute: 'numeric', second: 'numeric',
  hour12: false
});
var commentIdx = 0;

var switchprod = function(rating)
{
	prodnum++;
	updateprodcnt();
	
	var prod = prodlist.prods[parseInt(prodnum) % prodlist.prods.length];
	prodtitle.textContent = prod.name;
	
	var group = prod.groups[0] || {};
	prodgroup.textContent = group.name;
	prodgroup.href = "https://www.pouet.net/groups.php?which=" + group.id;
	
	screenshot.src = prod.screenshot;
	
	var platform = {};
	for(var platformId in prod.platforms) {
		if (prod.platforms.hasOwnProperty(platformId))
		{
			platform = prod.platforms[platformId];
			break;			
		}
	}
	platformOs.className = 'platform ' + platform.slug;
	platformOs.textContent = platform.name;
	platformName.textContent = platform.name;
	
	entrytypeName.textContent = prod.type;
	entrytype.textContent = prod.type;
	entrytype.className = "type type_" + prod.type;

	var dateStr = prod.releaseDate;
	var date = new Date(dateStr);
	releasedate.textContent = months[date.getMonth()] + ' ' + date.getFullYear();

	var placing = prod.placings[0] || {};
	partyYear.textContent = placing.year || prod.party_year || '';
	var party = placing.party || {};
	party.textContent = party.name || '';
	party.href = party.web || '';
	
	compo.textContent = placing.compo_name;

	rank.textContent = placing.ranking || prod.party_place || '';

	nRulez.textContent = prod.voteup;
	nOk.textContent = prod.votepig;
	nSuxx.textContent = prod.votedown;
	nAvg.textContent = prod.voteavg;
	var avg = parseFloat(prod.voteavg);
	nAvgImg.src = (avg > 0.3) ? 'data/gfx/rulez.gif' : ((avg < -0.3) ? 'data/gfx/sucks.gif' : 'data/gfx/isok.gif');

	var popularity = Math.min(100, 100 / Math.sqrt(prod.rank)).toFixed(0) + '%';
	popularityText.textContent = popularity;
	popularityBar.style.width = popularity;

	download.src = prod.download;
	demozoo.src = "http://demozoo.org/productions/" + prod.demozoo + "/";

	if (prod.cdc)
	{
		prodCdc.style.visibility = 'visible';
		nCdc.textContent = prod.cdc;
	} else {
		prodCdc.style.visibility = 'hidden';
	}

	var comment = comments[(++commentIdx) % comments.length];
	var user = comment[0];
	var avatar = comment[1];
	
	if(rating)
	{
		commentRating.className = 'vote ' + rating;
	} else {
		commentRating.className = '';
	}
	commentDiv.textContent = comment[3];
	commentDate.textContent = timeFormat.format(new Date());
	commentUser.textContent = user;
	commentAvatar.src = 'data/gfx/avatars/' + avatar;

	updatelogo();
}

var logoIdx = 0;
var logoNum = 30;
var updatelogo = function()
{
	var idx = (logoIdx++) % logoNum;
	logo.src = 'data/gfx/logos/' + idx + '.png';		
}

var canbuy = function(feature)
{
	if(gloeps < feature.mingloeps)
	{
		return false;
	}
	var cdcLeft = cdc - cdcSpentCurrent;
    return cdcLeft >= feature.mincdc;
}

var featureupdater = setInterval(function() {
	var cdcLeft = cdc - cdcSpentCurrent;
	for (var i = 0; i < features.length; i++)
	{
		var feature = features[i];
		if ((!feature.shown) && (gloeps >= 0.5 * feature.mingloeps))
		{
			var newItem = document.createElement('div');
			newItem.className = "pouettbl";
			newItem.featureItemRef = feature;
			newItem.innerHTML = 
 '<h2>' + feature.title + '</h2>' + 
 '<div class="content"><div class ="feature">' + feature.text + '</div>' +
 '<div class="desc">' + feature.desc + '</div></div>' +	
 '</div>';
			newItem.addEventListener("click", function() {
				if (this.bought || !canbuy(this.featureItemRef))
				{
					return;					
				}
				cdcSpent += this.featureItemRef.mincdc;
				cdcSpentCurrent += this.featureItemRef.mincdc;
				this.featureItemRef.callback();
				this.bought = true;

				var zoomval = 1;
				var zoomtimer = setInterval(function() {
					zoomval *= 1.1;
					if (zoomval > 3) {
						this.parentNode.removeChild(this);
						clearInterval(zoomtimer);
					} else {
						this.style.transform = 'scale(' + zoomval + ')';
						this.style.opacity = 1 / (zoomval**2);
						this.style.zIndex = 99;
					}
				}.bind(this), 30);

				powerup.play();
			}.bind(newItem));
			for(var i = 0; i < feature.mincdc; i++)
			{
				var newImg = document.createElement('img');
				newImg.src = 'data/gfx/coupdecoeur.gif';
				newItem.firstChild.appendChild(newImg);
			}
			var newDiv = document.createElement('div');
			newDiv.innerText = 'min ' + feature.mingloeps + ' glöps';
			newDiv.className = 'mingloep';
			newItem.firstChild.appendChild(newDiv);
			featureBar.appendChild(newItem);
			
			feature.shown = newItem;
		}
		if (feature.shown)
		{
			if (canbuy(feature))
			{
				feature.shown.style.opacity = 1;
			}
			else
			{
				feature.shown.style.opacity = 0.3;							
			}
		}
	}
	
	mygloptext.innerText = ':: ' + Math.floor(gloeps) + ' glöps';
	
	var nextglop = myglop.previousSibling;
	if (nextglop)
	{
		var nextgloptext = nextglop.getElementsByClassName && nextglop.getElementsByClassName('group')[0];
		var numText = (nextgloptext && nextgloptext.innerText || '').substr(3);
		var nextnum = parseInt(numText);
		if (nextnum < gloeps)
		{
			nextglop.parentNode.insertBefore(myglop, nextglop);
			
			var fadeval = 1;
			var flashtimer = setInterval(function() {
				fadeval *= 0.9;
				if (fadeval < 0.4) {
					myglop.style.backgroundColor = '';
					clearInterval(flashtimer);
				} else {
					w = fadeval * 255;
					myglop.style.backgroundColor = 'rgb(' + w +','+ w +','+ w + ')';
				}
			}, 100);
		}
	}
}, 500);