#version 450
layout(set = 0, binding = 0) uniform _Time { float Time; };
layout(set = 0, binding = 1) uniform _Offset { vec2 Offset; };
layout(set = 0, binding = 2) uniform _Zoom { float Zoom; };
layout(location = 0) in vec2 fsin_Position;
layout(location = 0) out vec4 fsout_Color;
float beat = 0.9375;
float beats = (Time / beat);
vec2 pR(vec2 p, float a)
{
p = ((p * cos(a)) + (vec2(p.y, (-p.x)) * sin(a)));
return p;

}

float rand1d(float n)
{
return fract((sin(n) * 43758.55));

}

float noise(vec2 uv, float intensity)
{
return min(1.0, ((1.0 / (rand1d(((uv.x * 20.0) + 1.0)) + rand1d((uv.y * 40.0)))) * intensity));

}

float spikeFunc(float x)
{
return max(min(min(fract(x / -2.) * 2. -1., sin((x + 1.) / 0.31831 ) + 1.), sin((x - 1.278) / 0.31831) + 0.645), 0.);

}

float superclamp(float val, float start, float end)
{
float dur = (end - start);
float halfdur = (dur / 2.0);
float prog = (clamp(val, start, end) - start);
return ((halfdur - abs((prog - halfdur))) / halfdur);

}

vec3 ror2;
float sphere(vec3 p, float radius)
{
return length(p) - radius;

}


vec3 gp;

void pRx(inout vec2 p, float a)
{
	p = cos(a)*p + sin(a)*vec2(p.y, -p.x);
}

float elipse(vec3 p, vec3 r )
{
    float k0 = length(p/r);
    float k1 = length(p/(r*r));
    return k0*(k0-1.0)/k1;
}

float box(vec3 p, vec3 b)
{
	return length(max(abs(p) - b, 0.0));
}

float vmax(vec3 v) {
	return max(max(v.x, v.y), v.z);
}

float box2(vec3 p, vec3 b) {
	return vmax(abs(p) - b);
}

float box3( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return length(max(d,0.0));
         + min(max(d.x,max(d.y,d.z)),0.0); // remove this line for an only partially signed sdf 
}

float gSPACE(vec3 p)
{
    gp.x -= 0.10;
    
    return 1.0 / 0.0;
}

float gA(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.06;
    d = max( d, -box2( p, vec3( 0.02, 0.06, 0.1 )) );

    p.y += 0.18;
    d = max( d, -box2( p, vec3( 0.02, 0.08, 0.1 )) );

    p.y -= 0.30;
    p.x -= 0.12;
    vec3 t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    p.x += 0.24;
    t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    return d;
}

float gB(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.06;
    d = max( d, -box2( p, vec3( 0.02, 0.06, 0.1 )) );

    p.y += 0.15;
    d = max( d, -box2( p, vec3( 0.02, 0.05, 0.1 )) );

    p.y -= 0.30;
    p.x -= 0.12;
    vec3 t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    p.y += 0.42;
    t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    p.y -= 0.19;
    p.x -= 0.04;
    t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    return d;
}

float gC(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.00;
    p.x -= 0.06;
    d = max( d, -box2( p, vec3( 0.08, 0.14, 0.1 )) );

    p.y += 0.22;
    //d = max( d, -box2( p, vec3( 0.02, 0.08, 0.1 )) );

    return d;
}

float gD(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    d = max( d, -box2( p, vec3( 0.02, 0.14, 0.1 )) );

    p.y -= 0.20;
    p.x -= 0.12;
    vec3 t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    p.y += 0.40;
    t = p;
    pRx( t.xy, 3.14592/4.0 );
    d = max( d, -box2(t,vec3( 0.05, 0.05, 0.1)) );

    return d;
}

float gH(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.10;
    d = max( d, -box2( p, vec3( 0.02, 0.10, 0.1 )) );

    p.y += 0.22;
    d = max( d, -box2( p, vec3( 0.02, 0.08, 0.1 )) );

    return d;
}

float gL(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.10;
    p.x -= 0.06;
    d = max( d, -box2( p, vec3( 0.08, 0.24, 0.1 )) );

    p.y += 0.22;
    //d = max( d, -box2( p, vec3( 0.02, 0.08, 0.1 )) );

    return d;
}

float gU(vec3 p)
{
    gp.x -= 0.30;
    float d = 1.0 / 0.0;
    d = min( d, box( p, vec3( 0.12, 0.18, 0.07 )) );

    p.y -= 0.10;
    d = max( d, -box2( p, vec3( 0.02, 0.24, 0.1 )) );

    return d;
}

float smin( float a, float b, float k )
{
    float res = exp2( -k*a ) + exp2( -k*b );
    return -log2( res )/k;
}

vec3 crap
;
vec4 scene(vec3 p)
{
float d = 10.0;
float sphere = sphere(p, 1.0);
vec3 r = (vec3(sin(pR(vec2(sin((-pR((p.zy * 1.5), ((round(((round(((length(p) * 10.0) * 7.0)) / 7.0) * 7.0)) / 7.0) - (max(0.0, (0.2 - fract(((beats * 4.0) + 0.12)))) * 0.6))).x)), (p.z / 1.0)), (beats * 0.25)).y)) * vec3(1.0, 0.0, 0.0));
vec3 g = (vec3(pR(vec2((p.x * 1.0), max(pR((p.zy * 1.5), pR((p.xy * 2.0), pR(vec2((p.y * 1.0), (pR((p.xy * 1.5), sin(((beats * 1.57) * 0.25))).y / (1.3 / (p.z / 1.0)))), (p.y / 1.0)).y).x).x, (max(0.0, (0.2 - fract(((beats * 4.0) + 0.12)))) * 0.6))), (max(0.0, (0.2 - fract((((beats * 4.0) + 0.12) - 0.4)))) * 0.6)).x) * vec3(0.0, 1.0, 0.0));
vec3 b = (vec3(length(vec2((-pR(vec2(length(vec2(pR(vec2(3.1416, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).x, sin(((beats * 1.57) * 0.25)))), (p.z / 1.0)), (beats * 0.25)).x), (tan(((beats * 3.14) * 0.5)) / 2.0)))) * vec3(0.0, 0.0, 1.0));
vec3 c = clamp(((r + g) + b), 0.1, 1.0);
float t1 = (pR((p.xy * 2.0), (floor((((-(pR(vec2((p.z * 1.0), (floor(((round(((pR(vec2(pR(vec2((p.y * 1.0), pR(vec2((p.y * 1.0), pR(vec2((p.z * 1.0), pR(vec2((p.z * 1.0), (-pR(vec2((((floor((length(vec2(pR(vec2((p.z * 1.0), pR((p.xy * 2.0), pR((p.zx * 2.0), cos(pR(vec2((floor((cos(length(vec2(pR((p.xy * 1.5), (tan(pR(vec2((p.x * 1.0), cos(pR((p.zx * 2.0), (tan(pR((p.yz * 2.0), pR(vec2((p.z * 1.0), smoothstep(cos(pR(vec2(pR(vec2(pR((p.zy * 1.5), (max(pR(vec2((p.x * 1.0), (pR(vec2((p.y * 1.0), (floor((pR(vec2((p.y * 1.0), (-pR(vec2(((pR((p.yz * 2.0), (pR((p.xy * 2.0), sin((pR(vec2(((pR((p.xy * 2.0), cos(((pR((p.yz * 2.0), pR((p.zx * 2.0), (floor((((tan((sin(((beats * 1.57) * 0.5)) * 4.0)) / 2.0) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))) * 7.0)) / 7.0)).x).y + (p.y / 1.0)) + (p.y / 1.0)))).x / (1.3 / (p.y / 1.0))) - (tan(((beats * 3.14) * 0.5)) / 2.0)), (max(0.0, (0.2 - fract(((beats * 4.0) + 0.12)))) * 0.6)), (beats * 0.25)).y - (sin(((beats * 1.57) * 0.5)) * 4.0)))).x + (sin(((beats * 1.57) * 0.5)) * 4.0))).y / (1.3 / (length(p) * 10.0))) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))), (p.z / 1.0)), (beats * 0.25)).x)), (max(0.0, (0.2 - fract(((beats * 4.0) + 0.12)))) * 0.6)).y * 7.0)) / 7.0)), (p.z / 1.0)).y + sin(((beats * 1.57) * 0.25)))), (length(p) * 10.0)).x, (tan(((beats * 3.14) * 0.5)) / 2.0)) - sin(((beats * 1.57) * 0.25)))).x, 3.1416), (beats * 0.25)).x, 3.1416), (beats * 0.25)).y), 0.0, 0.1)), sin(((beats * 1.57) * 0.25))).y).y) / 2.0)).x)), (p.x / 1.0)).x) / 2.0)).y, (p.y / 1.0)))) * 7.0)) / 7.0), (max(0.0, (0.2 - fract(((beats * 4.0) + 0.12)))) * 0.6)), (beats * 0.25)).y)).x).x), 3.1416).y, sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0) + (p.z / 1.0)) / (1.3 / (p.z / 1.0))), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y)), sin(((beats * 1.57) * 0.25))).y), 3.1416).y), (sin(((beats * 1.57) * 0.5)) * 4.0)).y), (max(0.0, (0.2 - fract(((beats * 4.0) + 0.12)))) * 0.6)).y, (p.y / 1.0)), (beats * 0.25)).y - (length(p) * 10.0)) * 7.0)) / 7.0) * 7.0)) / 7.0)), 3.1416).y + sin(((beats * 1.57) * 0.25)))) + (length(p) * 10.0)) * 7.0)) / 7.0)).x + sphere);
d = min(d, t1);
d = smin(d, t1, beats * 2.);
return vec4(c, min(0.01, d));

}

vec3 march(vec2 uv)
{
float beaty = ((sin(((beats * 3.14) * 0.1)) - 0.5) * 1.0);
vec3 cameraOrigin = (vec3(((0.0 + Offset.x) + beaty), (0.0 + Offset.y), 4.0) * (1.0 + (Zoom * Zoom)));
vec3 cameraTarget = vec3(0.0, 0.0, 0.0);
vec3 upDirection = vec3(0.0, 1.0, 0.0);
vec3 cameraDir = normalize((cameraTarget - cameraOrigin));
vec3 cameraRight = normalize(cross(upDirection, cameraOrigin));
vec3 cameraUp = cross(cameraDir, cameraRight);
vec3 rayDir = normalize((((cameraRight * uv.x) + (cameraUp * uv.y)) + cameraDir));
float MAX_DIST = 1000.0;
float EPSILON = 0.001;
float totalDist = 0.0;
vec3 p = cameraOrigin;
float dist = EPSILON;
vec3 resultColor = vec3(0.0);
for(int index = 0;(index < 1000);index = (index + 1))
{
if (dist < EPSILON || totalDist > MAX_DIST) break;
vec4 result = scene(p);
dist = result.w;
resultColor = result.xyz;
totalDist = (totalDist + dist);
p = (p + (vec3(dist) * rayDir));

}

vec3 c = vec3(0.0);
if(totalDist < MAX_DIST) {;
vec2 eps = vec2(0.0, 0.8);
vec3 normal = normalize(vec3((scene((p + eps.yxx)).w - scene((p - eps.yxx)).w), (scene((p + eps.xyx)).w - scene((p - eps.xyx)).w), (scene((p + eps.xxy)).w - scene((p - eps.xxy)).w)));
float diffuse = max(0.0, dot((-rayDir), normal));
float specular = pow(diffuse, 10.0);
c = (c + (smoothstep(0.0, 1.2, (diffuse + 0.05)) * 0.85));
c = (c + (smoothstep(0.0, 1.0, specular) * 0.1));
c = (sqrt((c - vec3(0.1))) * 1.05);
c = (c * resultColor);
} else {;
};
return c;

}

void main()
{
vec2 uv = fsin_Position;
uv = vec2((uv.x * 1.777778), uv.y);
float audio1 = (max(0.0, (0.2 - fract(((beats * 4.0) + 0.12)))) * 0.6);
uv = vec2((uv.x + (audio1 * (noise(pR(vec2(uv.y), Time), 0.2) - 0.2))), uv.y);
uv = vec2((uv.x + (audio1 * 0.2)), uv.y);
float audio2 = (max(0.0, (0.2 - fract((((beats * 4.0) + 0.12) - 0.4)))) * 0.6);
uv = vec2((uv.x - (audio2 * (noise(pR(vec2(uv.y), Time), 0.2) - 0.2))), uv.y);
uv = vec2((uv.x - (audio2 * 0.2)), uv.y);
float audio3 = (step(6.25, ((fract((beats / 2.0)) * 2.0) * 4.0)) - step(8.0, ((fract((beats / 2.0)) * 2.0) * 4.0)));
uv = vec2((uv.x + (audio3 * (noise(pR(vec2(uv.y), Time), 0.2) - 0.12))), uv.y);
vec3 c = vec3(0.0);
c = march(uv);
fsout_Color = vec4(c, 1.0);

}

