//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID24a0f9c7_a4ae_4dcc_a688_2dc4a4e4a6f0
{
    public class Class_ToneMapper : FXImageFunction
    {
        protected override bool NeedsDepth { get { return false; } }

        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Exposure = 2,
            MaxBrightness = 3
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var Exposure = inputs[(int)InputId.Exposure].Eval(context).Value;
            var MaxBrightness = inputs[(int)InputId.MaxBrightness].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () =>
            {
                ClearRenderTarget(context, new Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Exposure").AsScalar().Set(Exposure);
                    _effect.GetVariableByName("MaxBrightness").AsScalar().Set(MaxBrightness);
                    //<<< _setup

                    var prevBlendState = context.BlendState;
                    context.BlendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;

                    Render(context);

                    context.BlendState = prevBlendState;
                    //>>> _cleanup
                    }
                //<<< _cleanup
            });
        }
    }
}

