cpu 386
org	0100h

HWIDTH equ 80
BOTTOMHEIGHT equ 10

EXTENDIN equ 30
EXTENDOUT equ 150
EXTENDRANGE equ EXTENDOUT - EXTENDIN

DELAYYIME equ 0
DELAYCENTER equ 160 - HWIDTH/2
DELAYEXTEND equ DELAYCENTER + EXTENDRANGE



;Setup video mode.
mov	al, 13h
int	10h

push 0xa000
pop es

mov bp, 320
;Delay si for a bit
mov si, bp

foreverloop:

pixelloop:

mov ax, di
xor dx, dx

div bp

mov cx, si
sar cx, 1

cmp cx, -DELAYCENTER
js drawextending
drawsmall:
add dx, cx
js skipColor
mov cx, EXTENDIN
jmp drawbegin
drawextending:
cmp cx, -DELAYEXTEND
js drawmoveright
;Stuck in the center of the screen extending

add dx, -DELAYCENTER
js skipColor
neg cx
sub cx, DELAYCENTER-EXTENDIN
jmp drawbegin
drawmoveright:
add cx, DELAYEXTEND-DELAYCENTER
add dx, cx
mov cx, EXTENDOUT
js skipColor

drawbegin:
;cx contains the height of the extended area

cmp dx, HWIDTH
jg skipColor
;Try finding the vertical parts
sub al, 200-BOTTOMHEIGHT
jb notbottom
;Bottom part
mov al, 6*16+8
jmp drawPixel

;Scissor part
notbottom:
neg al
cmp al, cl
jb drawscissor

sub al, cl
cmp al, BOTTOMHEIGHT
ja skipColor
;mov al, 6*16+8
xor al, dl
and al, 1
jmp drawPixel


drawscissor:
shr cx, 1
pusha
fninit

fld1

fild word [bx-4]
fidiv word [bx-6]
fprem
fimul word [endscale]
fistp word [bx-4]


fild word [bx-8]
fidiv word [divx]
fprem
fimul word [endscale]
fistp word [bx-8]

popa

mov cx, ax

sub ax, dx
cmp ax, 3
jg notfirst
cmp ax, -3
jng notfirst

mov al, 2*16+7

jmp drawPixel


notfirst:
mov ax, [endscale]
sub ax, cx
sub ax, dx

cmp al, 4
jg skipColor
cmp al, -4
jng skipColor

mov al, 4*16+12

jmp drawPixel

skipColor:
xor ax, ax
drawPixel:


mov [es:di], al

inc di
jnz pixelloop

;Wait for redrace
mov dx, 0x3da
waitretrace:
in al, dx
test al, 8
jz waitretrace

;increase timer
dec si

;Speaker hooked to the pit
mov 	ax, si

cmp		ax, -DELAYCENTER * 2
jg		slowbeep
cmp 	ax, -DELAYEXTEND*2
js		slowbeep

;Fast beep
test al, 15
jne skipbeep
test al, 16
je silence

mov cl, 5
jmp dobeep

slowbeep:
test al, 31
jne skipbeep
test al, 32
je silence

mov cl, 10
jmp dobeep

dobeep:

mov     al, 00000011b  
out     61h, al

mov     al, 0xa6		;timer 2, mode 3, hi byte only
out     43h, al         ; a new countdown value

xchg 	ax, cx
out		42h, al

jmp foreverloop


silence:
mov     al, 0000000b  
out     61h, al

skipbeep:


jmp foreverloop

divx dw HWIDTH/2

endscale dw 50

