#include "data/title_anim_1.h"
#include "data/title_anim_2.h"
#include "data/title_strip.h"

const unsigned char title_palette1[16]={ 0x0f,0x21,0x30,0x0f,0x0f,0x05,0x16,0x27,0x0f,0x0c,0x1b,0x29,0x0f,0x02,0x13,0x24 };
const unsigned char title_palette2[16]={ 0x0f,0x21,0x30,0x0f,0x0f,0x15,0x26,0x37,0x0f,0x1c,0x2b,0x39,0x0f,0x12,0x23,0x34 };

#define TI_HIDE_STRIPS_FRAME		870
#define TI_FRAMES_ALL				950

const unsigned char title_font[8*8]={
	0*8,0*8,1*8,0*8,0*8,0,0,0,	//H
	1*8,2*8,3*8,2*8,1*8,0,0,0,	//E
	1*8,0*8,0*8,0*8,1*8,0,0,0,	//O
	0*8,0*8,1*8,0*8,0*8,0,0,0,	//H
	3*8,0*8,0*8,0*8,3*8,0,0,0,	//D
	1*8,2*8,3*8,2*8,1*8,0,0,0,	//E
	1*8,4*8,0*8,0*8,0*8,0,0,0,	//M
	1*8,0*8,0*8,0*8,1*8,0,0,0,	//O
};

const unsigned char title_colors[8]={0x21,0x23,0x25,0x27,0x28,0x29,0x2b,0x2c};

const unsigned char title_rotate[8]={0,1,0,0,1,1,0,1};

const unsigned int title_scroll_delay[]={
	300,430,370,460,550,360,450,490,520,	//top
	450,330,360,540,370,480,510,390,420,540	//bottom
};

const unsigned int title_scroll_speed[]={
	8, 7,10,12, 5,11, 8, 4, 9,				//top
	9, 6, 4, 8,11, 5,10,12,	7,12			//bottom
};



#pragma bssseg (push,"SHAREDRAM3")
#pragma dataseg(push,"SHAREDRAM3")

unsigned char ti_tx,ti_char,ti_charp,ti_pos,ti_rotate,ti_delay,ti_edge_x,ti_edge_col;
unsigned int  ti_n,ti_adr,ti_off;
  signed int  ti_edge_off,ti_eyy;
unsigned int* ti_scroll;
unsigned int  ti_scroll_x,ti_scroll_xc,ti_frame;

#pragma dataseg(pop);
#pragma bssseg (pop);

		

void e_title(void)
{
	unsigned char chr,flash;
	
	oam_clear_fast();
	oam_size(0);

	chr=CHR_TITLE;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	mmc3_chr_bank(chr+0,2);
	mmc3_chr_bank(chr+1,3);
	mmc3_chr_bank(chr+2,4);
	mmc3_chr_bank(chr+3,5);

	mmc3_set_mirroring(M_VERTICAL);
	
	set_irq_handler(IRQ_ROW_FULLX);
	set_nmi_handler(NMI_TITLE);
	
	memfill(split_list,0,sizeof(split_list));
	
	memfill(update_list,NT_UPD_EOF,sizeof(update_list));
	
	pal_bg (title_palette1);
	pal_spr(title_palette1);
	pal_bright(4);
	
	vram_adr(NAMETABLE_A);
	vram_fill(0,1024);
	vram_adr(NAMETABLE_B);
	vram_unrle(title_strip);
	
	scroll(0,0);
	
	ti_scroll_x=0;
	ti_char=0;
	ti_pos=38;
	ti_rotate=63;
	ti_delay=192;
	
	ti_edge_col=1;
	ti_edge_off=0;
	
	ti_frame=0;
	
	ti_scroll=(unsigned int*)split_list;
	
	flash=0x0f;
	
	oam_off=0;
	
	for(_i=0;_i<8;++_i)	//clip sprites to avoid visible edge
	{
		oam_spr(0,0,0,0,oam_off+0);
		oam_spr(0,231,0,0,oam_off+4);
		oam_off+=2*4;
	}
			
	set_irq_handler(IRQ_ROW_FULLX);
	mmc3_irq_enable(6);
	
	ppu_on_all();
	
	while(ti_frame<TI_FRAMES_ALL)
	{
		pal_bg (ti_frame&1?title_palette1:title_palette2);
	
		pal_col(0x01,title_colors[ti_char]);
		pal_col(0x11,title_colors[ti_edge_col&7]);

		pal_col(0x00,flash);
		
		if(!(ti_frame&1))
		{
			if(flash==0x30) flash=0x10; else if(flash==0x10) flash=0x00; else if(flash==0x00) flash=0x0f;
		}
		
		if(playdump_sync)
		{
			flash=0x30;
			playdump_sync=0;
		}
		
		ti_scroll_xc=ti_scroll_x&511;
		
		_ptr=0;
		_id=0;

		for(;_ptr<9;++_ptr)
		{
			if(title_scroll_delay[_id]<ti_frame)
			{
				ti_n=ti_scroll[_ptr];
				
				ti_n+=title_scroll_speed[_id];
				
				if(ti_n>=512)
				{
					if(ti_frame<TI_HIDE_STRIPS_FRAME) ti_n-=512; else ti_n=511;
				}
				
				ti_scroll[_ptr]=ti_n;
			}
			
			++_id;
		}
		
		for(;_ptr<9+11;++_ptr) ti_scroll[_ptr]=ti_scroll_xc;
		
		for(;_ptr<30;++_ptr)
		{
			if(title_scroll_delay[_id]<ti_frame)
			{
				ti_n=ti_scroll[_ptr];
				
				ti_n+=title_scroll_speed[_id];
				
				if(ti_n>=512)
				{
					if(ti_frame<TI_HIDE_STRIPS_FRAME) ti_n-=512; else ti_n=511;
				}
				
				ti_scroll[_ptr]=ti_n;
			}
			
			++_id;
		}

		oam_off=16*4;
				
		if(ti_edge_off)
		{
			_sx=ti_edge_x;

			if(ti_char&1)
			{
				ti_eyy=80-1+((ti_edge_off/2*ti_edge_off/2)/64);
			}
			else
			{
				ti_eyy=80-1-((ti_edge_off/2*ti_edge_off/2)/64);
			}
						
			for(_i=0;_i<10;++_i)
			{
				if(ti_eyy>=-8&&ti_eyy<240)
				{
					_sy=ti_eyy;
					
					oam_spr(_sx+0,_sy,0xc1,0,oam_off+0);
					oam_spr(_sx+8,_sy,0xc1,0,oam_off+4);
					
					oam_off+=8;
				}
				
				ti_eyy+=8;
			}
		}
		
		oam_hide_rest(oam_off);
	
		upd_off=0;
		
		//imprint current character animation
		
		if(ti_char<8)
		{
			ti_off=ti_rotate*(5*8);
			
			ti_tx=ti_pos;

			for(_i=0;_i<8;++_i)
			{
				if(ti_tx<32)
				{
					ti_adr=NTADR_A(ti_tx,10);
				}
				else
				{
					ti_adr=NTADR_B((ti_tx-32),10);
				}
			
				update_list[upd_off++]=MSB(ti_adr)|NT_UPD_VERT;
				update_list[upd_off++]=LSB(ti_adr);
				update_list[upd_off++]=10;
		
				ti_charp=ti_char*8;
		
				if(title_rotate[ti_char])
				{
					//for(_j=0;_j<5;++_j)
					{
						_tile=title_anim_1_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;

						_tile=title_anim_1_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;
						
						_tile=title_anim_1_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;
						
						_tile=title_anim_1_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;
						
						_tile=title_anim_1_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;
					}
				}
				else
				{
					//for(_j=0;_j<5;++_j)
					{
						_tile=title_anim_2_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;
						
						_tile=title_anim_2_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;
						
						_tile=title_anim_2_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;
						
						_tile=title_anim_2_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;
						
						_tile=title_anim_2_data[title_font[ti_charp++]+ti_off];
						
						update_list[upd_off++]=_tile;
						update_list[upd_off++]=_tile;
					}
				}

				++ti_off;

				ti_tx=(ti_tx+1)&63;
			}
		}

		//clear column
		
		ti_tx=((ti_scroll_x>>3)+34)&63;
		
		if(ti_tx<32)
		{
			ti_adr=NTADR_A(ti_tx,10);
		}
		else
		{
			ti_adr=NTADR_B((ti_tx-32),10);
		}
		
		if(!(ti_scroll_x&7))
		{
			update_list[upd_off++]=MSB(ti_adr)|NT_UPD_VERT;
			update_list[upd_off++]=LSB(ti_adr);
			update_list[upd_off++]=10;
				
			for(_j=0;_j<5*2;++_j) update_list[upd_off++]=0;
		}
		
		update_list[upd_off]=NT_UPD_EOF;
		
		set_vram_update();
		
		oam_update();
		
		ppu_wait_nmi();
		
		if(ti_delay)
		{
			--ti_delay;
		}
		else
		{
			--ti_rotate;
			
			if(ti_rotate>=64)
			{
				ti_rotate=63;
				
				if(ti_char<8) ++ti_char;

				ti_pos+=9;
				
				while(ti_pos>=64) ti_pos-=64;
			}
		}
		
		if(ti_edge_off>0) ti_edge_off-=4;
		if(ti_edge_off<0) ti_edge_off+=4;
		
		_pal=0;
		
		if(ti_scroll_x==256     -64) _pal=3;
		if(ti_scroll_x==256+64*1-64) _pal=3;
		if(ti_scroll_x==256+64*2-64) _pal=3;
		if(ti_scroll_x==256+64*3-64) _pal=3;
		if(ti_scroll_x==256+64*4-64) _pal=3;
		if(ti_scroll_x==256+64*5-64) _pal=3;
		if(ti_scroll_x==256+64*6-64) _pal=3;
		
		if(_pal)
		{
			ti_edge_col=ti_char+1;
			ti_edge_x=144+8*ti_char;
			
			ti_edge_off=65*4-4;
		}

		++ti_scroll_x;
		++ti_frame;
	}
	
	ppu_off();
	
	mmc3_irq_enable(0);
}
