#include "data/pacman.h"
#include "data/pacman_anim.h"

const unsigned char pacman_palette[16]={ 0x0f,0x28,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f };



void e_pacman(void)
{
	unsigned char chr,frame;
	int scroll_x,scroll_y;
	
	oam_clear_fast();
	oam_size(0);

	chr=CHR_PACMAN;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	mmc3_chr_bank(chr+0,2);
	mmc3_chr_bank(chr+1,3);
	mmc3_chr_bank(chr+2,4);
	mmc3_chr_bank(chr+3,5);

	mmc3_set_mirroring(M_VERTICAL);
	
	set_irq_handler(IRQ_PACMAN);
	set_nmi_handler(NMI_NORMAL);
	
	memfill(update_list,NT_UPD_EOF,sizeof(update_list));
	
	pal_bg(pacman_palette);
	pal_bright(4);
	
	vram_adr(NAMETABLE_A);
	vram_unrle(pacman);
	vram_adr(NAMETABLE_B);
	vram_fill(0,1024);

	scroll_x=208;
	scroll_y=-48;
	frame=0;
	
	scroll(scroll_x,scroll_y);
	
	mmc3_irq_enable(224);
	
	ppu_on_bg();
	
	while(1)
	{
		memcpy(split_list,pacman_anim[frame&15],pacman_anim_size[frame&15]);
		
		oam_update();

		scroll(scroll_x,scroll_y);
		
		ppu_wait_nmi();
		
		scroll_x-=4;
		
		if(scroll_x<-256) break;
		
		++frame;
	}
	
	ppu_off();
	
	mmc3_irq_enable(0);
}