#include "data/ok.h"

const unsigned char ok_palette[16]={ 0x0f,0x00,0x10,0x30,0x0f,0x01,0x21,0x31,0x0f,0x06,0x16,0x26,0x0f,0x09,0x19,0x29 };


void e_ok(void)
{
	unsigned char chr;
	
	oam_clear_fast();
	oam_size(0);
	oam_update();

	chr=CHR_FONT;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	
	mmc3_set_mirroring(M_HORIZONTAL);
	
	set_irq_handler(IRQ_EMPTY);
	set_nmi_handler(NMI_NORMAL);
	
	pal_bg(ok_palette);
	pal_spr(ok_palette);
	pal_bright(4);
	
	vram_adr(NAMETABLE_A);
	vram_unrle(ok);
	
	scroll(0,0);
	
	ppu_on_all();
	
	while(1);
}