const unsigned char noise_palette[16]={ 0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30 };


void e_noise(void)
{
	unsigned char i,chr,mask;
	unsigned int n,frame;
	
	oam_clear_fast();
	oam_size(0);

	chr=CHR_NOISE;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	mmc3_chr_bank(chr+0,2);
	mmc3_chr_bank(chr+1,3);
	mmc3_chr_bank(chr+2,4);
	mmc3_chr_bank(chr+3,5);

	mmc3_set_mirroring(M_HORIZONTAL);
	
	set_irq_handler(IRQ_EMPTY);
	set_nmi_handler(NMI_NORMAL);
	
	pal_bg(noise_palette);
	pal_bright(4);
	
	vram_adr(NAMETABLE_A);
	
	for(n=0;n<256;++n) vram_put(n);
	
	//prerare row list
	
	memfill(split_list,0,sizeof(split_list));
	
	frame=0;
	mask=7;
	
	for(i=0;i<30*2;i+=2)
	{
		split_list[i+0]=0x20;
		split_list[i+1]=rand8()&mask;
	}
	
	set_irq_handler(IRQ_ROW_ADR);
	mmc3_irq_enable(1);
	
	ppu_on_bg();
	
	while(frame<4*60)
	{
		scroll(frame+rand8(),0);
		
		for(i=0;i<30*2;i+=2)
		{
			split_list[i+0]=0x20;
			split_list[i+1]=i^frame+(rand8()&mask);
		}
	
		oam_update();
		
		ppu_wait_nmi();
		
		++frame;
		
		if(!(frame&31)) mask=(mask<<1)|1;
	}
	
	ppu_off();
	
	mmc3_irq_enable(0);
}
