const unsigned char intro_palette1_bg[16]={ 0x0f,0x06,0x16,0x38,0x0f,0x06,0x16,0x38,0x0f,0x06,0x16,0x38,0x0f,0x06,0x16,0x38 };
const unsigned char intro_palette2_bg[16]={ 0x0f,0x0f,0x06,0x16,0x0f,0x0f,0x06,0x16,0x0f,0x0f,0x06,0x16,0x0f,0x0f,0x06,0x16 };

const unsigned char intro_palette_spr[16]={ 0x0f,0x06,0x16,0x30,0x0f,0x1c,0x2c,0x30,0x0f,0x17,0x28,0x30,0x0f,0x00,0x10,0x30 };

const unsigned char dendy_0_data[]={

	-16,-24,0x01,3,
	  0,-24,0x02,3,
	  8,-24,0x03,3,
	-16,-16,0x07,3,
	- 8,-16,0x08,3,
	  0,-16,0x09,3,
	  8,-16,0x0a,3,
	-16,- 8,0x11,3,
	- 8,- 8,0x12,3,
	  0,- 8,0x13,3,
	  8,- 8,0x14,3,
	-16,  0,0x1b,3,
	- 8,  0,0x1c,3,
	  0,  0,0x1d,3,
	-16,  8,0x20,3,
	- 8,  8,0x21,3,
	  0,- 8,0x24,0,
	  8,- 8,0x25,0,
	-16,  0,0x29,0,
	- 8,  0,0x2a,0,
	  0,  0,0x2b,0,
	  8,  0,0x2c,0,
	- 8,  8,0x32,0,
	  0,  8,0x33,0,
	  8,  8,0x34,0,
	-16,-24,0x37,1,
	- 8,-24,0x38,1,
	  0,-24,0x39,1,
	-16, 16,0x3d,1,
	- 8, 16,0x3e,1,
	  0, 16,0x3f,1,
	  8, 16,0x40,1,
	- 8,  8,0x45,2,
	  0,  8,0x46,2,
	  8,  8,0x47,2,
	-16, 16,0x4b,2,
	- 8, 16,0x4c,2,
	  0, 16,0x4d,2,
	  8, 16,0x4e,2,
	128

};

const unsigned char dendy_1_data[]={

	-16,-24,0x01,3,
	  0,-24,0x02,3,
	  8,-24,0x03,3,
	-16,-16,0x07,3,
	- 8,-16,0x08,3,
	  0,-16,0x0b,3,
	  8,-16,0x0c,3,
	-16,- 8,0x11,3,
	- 8,- 8,0x12,3,
	  0,- 8,0x15,3,
	  8,- 8,0x16,3,
	-16,  0,0x1b,3,
	- 8,  0,0x1c,3,
	  0,  0,0x1d,3,
	-16,  8,0x20,3,
	- 8,  8,0x21,3,
	  0,- 8,0x26,0,
	-16,  0,0x29,0,
	- 8,  0,0x2a,0,
	  0,  0,0x2b,0,
	  8,  0,0x2d,0,
	- 8,  8,0x32,0,
	  0,  8,0x33,0,
	  8,  8,0x34,0,
	-16,-24,0x37,1,
	- 8,-24,0x38,1,
	  0,-24,0x39,1,
	-16, 16,0x3d,1,
	- 8, 16,0x3e,1,
	  0, 16,0x3f,1,
	  8, 16,0x40,1,
	- 8,  8,0x45,2,
	  0,  8,0x46,2,
	  8,  8,0x47,2,
	-16, 16,0x4b,2,
	- 8, 16,0x4c,2,
	  0, 16,0x4d,2,
	  8, 16,0x4e,2,
	128

};

const unsigned char dendy_2_data[]={

	-16,-24,0x04,3,
	  0,-24,0x05,3,
	  8,-24,0x06,3,
	-16,-16,0x0d,3,
	- 8,-16,0x0e,3,
	  0,-16,0x0f,3,
	  8,-16,0x10,3,
	-16,- 8,0x17,3,
	- 8,- 8,0x18,3,
	  0,- 8,0x19,3,
	  8,- 8,0x1a,3,
	-16,  0,0x1e,3,
	- 8,  0,0x1f,3,
	  0,  0,0x1d,3,
	-16,  8,0x22,3,
	- 8,  8,0x23,3,
	-16,- 8,0x27,0,
	  0,- 8,0x24,0,
	  8,- 8,0x28,0,
	-16,  0,0x2e,0,
	- 8,  0,0x2f,0,
	  0,  0,0x30,0,
	  8,  0,0x31,0,
	- 8,  8,0x35,0,
	  0,  8,0x36,0,
	  8,  8,0x1d,0,
	-16,-24,0x3a,1,
	- 8,-24,0x3b,1,
	  0,-24,0x3c,1,
	-16, 16,0x41,1,
	- 8, 16,0x42,1,
	  0, 16,0x43,1,
	  8, 16,0x44,1,
	- 8,  8,0x48,2,
	  0,  8,0x49,2,
	  8,  8,0x4a,2,
	- 8, 16,0x4f,2,
	  0, 16,0x50,2,
	  8, 16,0x51,2,
	128

};

const unsigned char* const dendy_list[]={

	dendy_0_data,
	dendy_1_data,
	dendy_2_data

};


const char lcd_chars[]={
	0xae,	//space
	0x60,	//D
	0x62,	//E
	0x64,	//N
	0x66,	//P
	0x68,	//y
	0x6a,	//C
	0x6c,	//b
	0x6e,	//-
	0x80,	//1
	0x82,	//3
	0x84,	//c.
	0x86,	//c
	0x88,	//[
	0x8a,	//]
	0x8c,	//A
	0x8e,	//S
	0xa0,	//H	
};
	
enum {
	LCD_SPACE=0,
	LCD_D,
	LCD_E,
	LCD_N,
	LCD_P,
	LCD_y,
	LCD_C,
	LCD_b,
	LCD_MINUS,
	LCD_1,
	LCD_3,
	LCD_c_,
	LCD_c,
	LCD_LBRA,
	LCD_RBRA,
	LCD_A,
	LCD_S,
	LCD_H,
	LCD_CHARS_ALL
};



unsigned char lcd_data[9];

const char lcd_scroll[]={
	LCD_SPACE,LCD_SPACE,LCD_SPACE,LCD_SPACE,
	LCD_P,LCD_y,LCD_C,LCD_b,LCD_MINUS,LCD_1,LCD_3,LCD_c,
	LCD_SPACE,LCD_SPACE,
	LCD_LBRA,LCD_c,LCD_RBRA,
	LCD_SPACE,
	LCD_P,LCD_A,LCD_S,LCD_H,LCD_A,LCD_SPACE,LCD_H,LCD_A,LCD_SPACE,
	LCD_H,LCD_A,LCD_SPACE,LCD_SPACE,
	LCD_H,LCD_A,LCD_SPACE,LCD_SPACE,
	LCD_H,LCD_A,LCD_SPACE,LCD_SPACE,
	LCD_H,LCD_A,LCD_SPACE,LCD_SPACE,
	LCD_H,LCD_A,LCD_SPACE,LCD_SPACE,
	LCD_H,LCD_A,LCD_SPACE,LCD_SPACE,
	LCD_H,LCD_A,LCD_SPACE,LCD_SPACE,
	LCD_H,LCD_A,LCD_SPACE,
	255
};
	
#define EI_FP	4



void e_intro_update_lcd(void)
{
	unsigned char i,ptr1,ptr2,tile;
	
	ptr1=3;
	ptr2=33;
	
	for(i=0;i<9;++i)
	{
		tile=lcd_chars[lcd_data[i]];
		
		update_list[ptr1+0]=tile+0x00;
		update_list[ptr1+1]=tile+0x01;
		update_list[ptr2+0]=tile+0x10;
		update_list[ptr2+1]=tile+0x11;
		
		ptr1+=3;
		ptr2+=3;
	}
}



void e_intro(void)
{
	unsigned char i,cnt,chr,mask,frame,center,step_cnt;
	unsigned char dendy_frame,dendy_y,dendy_ty;
	unsigned char lcd_move,lcd_ptr,lcd_speed;
	unsigned char spr_bright,bg_bright,spr_bright_div,bg_bright_div;
	unsigned int adr,part2;
	signed int dendy_x,lcd_x;
	signed char dendy_dx,lcd_dx;
	
	oam_clear_fast();
	oam_update();
	oam_size(0);

	chr=CHR_INTRO;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	mmc3_chr_bank(chr+0,2);
	mmc3_chr_bank(chr+1,3);
	mmc3_chr_bank(chr+2,4);
	mmc3_chr_bank(chr+3,5);

	mmc3_set_mirroring(M_VERTICAL);
	
	set_irq_handler(IRQ_EMPTY);
	set_nmi_handler(NMI_NORMAL);
	
	pal_bg (intro_palette1_bg);
	pal_spr(intro_palette_spr);

	vram_adr(NAMETABLE_A);
	vram_fill(0,1024);
	vram_adr(NAMETABLE_B);
	vram_fill(0,1024);
	
	pal_bright(0);
	
	bg_bright=0;
	bg_bright_div=0;
	spr_bright=0;
	spr_bright_div=0;
	
	dendy_x=(280<<EI_FP);
	dendy_dx=(2<<EI_FP);
	dendy_frame=0;
	dendy_ty=116;
	dendy_y=dendy_ty;
	
	lcd_x=(-220<<EI_FP);
	lcd_dx=(2<<EI_FP)-4;
	lcd_move=FALSE;
	lcd_ptr=0;
	lcd_speed=10;
	
	frame=0;
	center=0;
	part2=220;
	step_cnt=0;
	
	memfill(lcd_data,LCD_SPACE,sizeof(lcd_data));
	
	lcd_data[3]=LCD_D;
	lcd_data[4]=LCD_E;
	lcd_data[5]=LCD_N;
	lcd_data[6]=LCD_D;
	lcd_data[7]=LCD_y;

	memfill(update_list,0,sizeof(update_list));
	
	adr=NTADR_A(3,14);
	
	update_list[0]=MSB(adr)|NT_UPD_HORZ;
	update_list[1]=LSB(adr);
	update_list[2]=9*3;

	adr+=32;
	
	update_list[30]=MSB(adr)|NT_UPD_HORZ;
	update_list[31]=LSB(adr);
	update_list[32]=9*3;

	update_list[60]=NT_UPD_EOF;
	
	ppu_on_all();
	
	while(1)
	{
		oam_clear_fast();
		
		oam_off=0;
		oam_step=4;
		
		oam_meta_clip_x(dendy_x>>EI_FP,dendy_y,0,dendy_list[dendy_frame]);
		
		e_intro_update_lcd();
	
		set_vram_update();
		
		oam_update();
		
		if(part2)
		{
			pal_bg(frame&1?intro_palette1_bg:intro_palette2_bg);
			pal_bg_bright(bg_bright);
			pal_spr_bright(spr_bright);
		}
		else
		{
			mask=0;
			
			if(lcd_ptr>=18) mask=7;
			if(lcd_ptr>=22) mask=3;
			if(lcd_ptr>=26) mask=1;
			
			if(mask&&!(frame&mask))
			{
				switch(rand8()&3)
				{
				case 0:
				case 1:
					pal_col(0,0x0f);
					pal_bright(4);
					break;
				case 2:
					pal_col(0,0x06);
					pal_bright(4);
					break;
				case 3:
					pal_bright(0);
					break;
				}
			}
		}
		
		scroll(lcd_x>>EI_FP,0);
		
		ppu_wait_nmi();
		
		if(part2)
		{
			--part2;
			
			++spr_bright_div;
			
			if(spr_bright_div>=16)
			{
				spr_bright_div=0;

				if(spr_bright<4) ++spr_bright;
			}
			
			++bg_bright_div;
			
			if(bg_bright_div>=24)
			{
				bg_bright_div=0;
				
				if(bg_bright<4) ++bg_bright;
			}
			
			lcd_x+=lcd_dx;
			
			if(lcd_x>=(-24<<EI_FP))
			{
				if(lcd_dx>0) --lcd_dx;
				
				center|=1;
			}
			
			dendy_x-=dendy_dx;
			
			if(dendy_x<(105<<EI_FP))
			{
				if(dendy_dx>0) --dendy_dx;
				
				center|=2;
			}
			
			if(center==3)
			{
				dendy_frame=(frame>>4)&1;
			}
		}
		else
		{
			if(!lcd_move)
			{
				cnt=0;
				
				if(frame&1)
				{
				for(i=0;i<9;++i)
				{
					if(lcd_data[i]!=lcd_scroll[i])
					{
						lcd_data[i]+=7;
						while(lcd_data[i]>=LCD_CHARS_ALL) lcd_data[i]-=LCD_CHARS_ALL;
						++cnt;
					}
				}
				
				if(!cnt) lcd_move=TRUE;
				}
			}
			else
			{
				memcpy(lcd_data,&lcd_scroll[lcd_ptr],9);
				
				dendy_frame=2;
				
				++step_cnt;
				
				if(dendy_y<dendy_ty) ++dendy_y;
				
				if(step_cnt>=lcd_speed)
				{
					if(dendy_x>(-20<<EI_FP))
					{
						dendy_x-=(16<<EI_FP);
						dendy_y-=4;
					}

					step_cnt=0;
					
					++lcd_ptr;
					
					if(lcd_ptr>=12)
					{
						if(lcd_speed>4) --lcd_speed;
					}
					
					if(lcd_scroll[lcd_ptr+9]==255) break;
				}
			}
		}
		
		++frame;
	}
	
	ppu_off();
}