import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;

Minim minim;
AudioPlayer coffeemaker;
AudioPlayer pour; 
AudioPlayer sip;
AudioPlayer tiktok;
AudioPlayer end;

PImage sleepy;
PImage happy;
PImage mugsteam1;
PImage mugsteam2;
PImage mugempty;
PImage pot;
PImage potfull;
PImage potbrew;
PImage clock;

int deskX;
int deskY;
int mugX;
int mugY;
int doorX;
int doorY;
int handleX;
int handleY;
int potX;
int potY;
int clockX;
int clockY;
float secrad;
int cx, cy;

//DO NOT TOUCH!
float window_width = 1920;
float window_height = 1080;

ArrayList<PImage> mukit;
boolean empty;
boolean showClock;

void settings(){
  boolean fullscreen = true;
  if(fullscreen){
    fullScreen(P2D);
  } else {
    size(800, 450);
  }
}

void setup(){
  setupAudio();
  setupImages();
  dimensionsSetup();
  mukit = new ArrayList<PImage>();
  mukit.add(mugsteam1);
  mukit.add(mugsteam2);
  empty = true;
  showClock = true;
  tiktok.play();
}

void setupAudio(){
  minim = new Minim(this);
  coffeemaker = minim.loadFile("maker_441.wav");
  pour = minim.loadFile("pour_shortsilence.wav");
  sip = minim.loadFile("sipsilence.wav");
  sip.setGain(-20);
  tiktok = minim.loadFile("tiktok_441.wav");
  end = minim.loadFile("end.wav");
  end.setGain(-20);
  //volataso esim hiljemmalle, desibelejä: track.setGain(-20);
}

void setupImages(){
  sleepy = loadImage("desk_512.png");
  happy = loadImage("deskhappy_512.png");
  mugsteam1 = loadImage("kahvihoyry1.png");
  mugsteam2 = loadImage("kahvihoyry2.png");
  mugempty = loadImage("kahvityhja.png");
  pot = loadImage("keitin_128.png");
  potfull = loadImage("keitintaynna_128.png");
  potbrew = loadImage("keitinkeittaa_128.png");
  clock = loadImage("clock_128.png");
}

void dimensionsSetup(){
  deskX = (int)window_width/2 - 400;
  deskY = (int)window_height/2 - 80;
  mugX = deskX + 90;
  mugY = deskY + 186;
  potX = deskX - 180;
  //huomaa doorY, -128 = kuvan koko huomioitu
  potY = (int)window_height/2 -128 -30;
  clockX = (int)window_width/2 + 300;
  clockY = 150;
}

void steamAnimation(float time){
  int aika = floor(time);
  image(mukit.get(aika%2), mugX, mugY -16);
}

void secondHand(){
  secrad = 56;
  cx = clockX + 64;
  cy = clockY + 64;
  stroke(0);
  strokeWeight(2);
  //clockx, clocky
  float s = map(second(), 0, 60, 0, TWO_PI) - HALF_PI;
  line(cx, cy, cx + cos(s) * secrad, cy + sin(s) * secrad);
}

void cupboards(){
  //nämä koordinaatit eivät toimi setupista!
  //kaappi
  doorX = 0;
  doorY = (int)window_height/2 - 30;
  //kaapin kahva
  handleX = 150;
  handleY = doorY + 40;
  
  strokeWeight(2);
  //10 ei riitä täyteen leveyteen!
  for(int i = 0; i < 12; i++){
    //kaappi
    fill(240, 200, 125);
    rect(doorX, doorY, 180, 310);
    
    fill(60, 70, 80);
    circle(handleX, handleY, 20);
    
    //kaapinleveyden verran lisää
    doorX += 180;
    handleX += 180;
  }
  //taso
  strokeWeight(5);
  line(0, doorY, window_width, doorY);
}

void rotateClock(float time){
  pushMatrix();
  translate(clockX, clockY);
  float rotateSpeed = PI * time * 10;
  rotate(rotateSpeed);
  image(clock, 0, 0);
  popMatrix();
}

//processing.org example code
void createStar(float xpos, float ypos, float midrad, float pointlen, int points){
  float angle = TWO_PI / points;
  float halfAngle = angle/2.0;
  strokeWeight(3);
  beginShape();
  for (float a = 0; a < TWO_PI; a += angle) {
    float sx = xpos + cos(a) * pointlen;
    float sy = ypos + sin(a) * pointlen;
    vertex(sx, sy);
    sx = xpos + cos(a+halfAngle) * midrad;
    sy = ypos + sin(a+halfAngle) * midrad;
    vertex(sx, sy);
  }
  endShape(CLOSE);
}

void fillStars(float time){
  float midrad = 10;
  float pointlen = 30;
  float speed = time * 50;
  pushMatrix();
  fill(0, 255, 255);
  //koordinaatit silmien päälle
  createStar(deskX + 370, deskY + 63, (midrad + 3 * sin(speed)), (pointlen + 14 * sin(speed)), 5);
  fill(255,255,0);
  createStar(deskX + 413, deskY + 63, (midrad + 3 * cos(speed)), (pointlen + 14 * cos(speed)), 5);
  popMatrix();
}

void draw(){
  background(230, 210, 240);
  float time = (float)millis()/1000;
  scale(width/window_width, height/window_height);
  cupboards();
  if(showClock){
    image(clock, clockX, clockY);
    secondHand();
  }
  image(sleepy, deskX, deskY);
  image(pot, potX, potY);
  
  if(empty){
    image(mugempty, mugX, mugY);
  }
  if(empty == false){
    steamAnimation(time);
  }
  
  if(time >= 4){
    coffeemaker.play(); 
    image(potbrew, potX, potY);
  }
  if(time >= 11){
    image(potfull, potX, potY);
    coffeemaker.mute();
  }
  if(time >= 13){
    pour.play();
  }
  if(time >= 16){
    empty = false;
  }
  if(time >= 17){
    pour.mute();
    sip.play();
  }
  if(time >= 20){
    empty = true;
    image(happy, deskX, deskY); 
  }
  if(time >= 22){
    showClock = false;
    rotateClock(time);
  }
  if(time >= 24){
    tiktok.mute();  
    fillStars(time);
    end.play();
  }
  if(time >= 33){
    fill(0);
    rect(0, 0, window_width, window_height);
    fill(255,255,255);
    textSize(40);
    text("Thanks for watching!", window_width/2 -160, window_height/2);
  }
  if(time >= 34){
    exit();
  }
}
