#version 330 core

in vec2 UV;
uniform sampler2D colortex;
uniform sampler2D aotex;
uniform sampler2D glowtex;
uniform sampler2D fftTexture;
uniform float fftFactor;
uniform float fftCoordinate;
uniform float glowintensity;

layout(location = 0) out vec4 oColor;
#define COMBINE 1
void main(){
#ifdef COMBINE
	const float exposure = 0.115;
    const float gamma = 2.2;
    vec4 hdrColor = texture(colortex, UV) + (glowintensity + fftFactor * textureLod(fftTexture, vec2(fftCoordinate, 0.0), 3.0).r) * texture(glowtex, UV);
  
    // Exposure tone mapping
    vec4 mapped = vec4(1.0) - exp(-hdrColor * exposure);
    // Gamma correction 
    mapped = pow(mapped, vec4(1.0 / gamma));
    oColor = mapped; // + 10.0*textureLod(fftTexture, vec2(UV.x*UV.x, 0.0), 6.0).rrrr; // * texture(aotex, UV);
#else
    oColor = .01*texture(colortex, UV) + texture(aotex, UV);
#endif
}
