//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);


cbuffer GlobalRenderData: register(b0)
{
    float2 g_vecSampleDirection;
    float g_fMix;
    float gbrpad1;
    float3 g_vecRGBOffsets;
    float gbrpad2;
};



//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

	const float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord0, 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
	const float2 vecAspect = float2(1280.0 / 1024.0, 1.0);
	const float fStrength = pow(length((input.vecTexCoord0 - 0.5) * vecAspect) * 1, 2);

	const float2 fRA = tex0.Sample(sampLinearClamp, input.vecTexCoord0 - g_vecSampleDirection * g_vecRGBOffsets.r * fStrength).ra;
	const float2 fGA = tex0.Sample(sampLinearClamp, input.vecTexCoord0 - g_vecSampleDirection * g_vecRGBOffsets.g * fStrength).ga;
	const float2 fBA = tex0.Sample(sampLinearClamp, input.vecTexCoord0 - g_vecSampleDirection * g_vecRGBOffsets.b * fStrength).ba;
	const float4 vecColour = float4(fRA.x, fGA.x, fBA.x, (fRA.y + fGA.y + fBA.y) / 3);

	const float4 vecSrcColour = tex0.Sample(sampLinearClamp, input.vecTexCoord0);
    return lerp(vecSrcColour, vecColour, g_fMix);
}
