//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D texTexture : register(t0);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData : register(b3)
{
    matrix g_matWorld;
    matrix g_matView;
    matrix g_matProjection;
};

cbuffer FrameData : register(b2)
{
    float g_fTime;
    float pad1;
    float pad2;
    float pad3;
};

struct Billboard
{
    float4 m_vecPosition;
    float4 m_vecColour;
    float m_fSize;
    float m_fDistance;
    float m_fImage;
    float m_fStartTime;
};
StructuredBuffer<Billboard> g_aBillboards : register(t5);


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord : TEXCOORD;
    uint iInstanceID : SV_InstanceID;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord : TEXCOORD0;
    float4 vecTint : TEXCOORD1;
    float fActiveTime : TEXCOORD2;
    float m_fPhaseFlicker : TEXCOORD3;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS(VS_INPUT input)
{
    PS_INPUT output;

    Billboard billboard = g_aBillboards[input.iInstanceID];

    matrix matWorld = g_matWorld;
    matrix matWorldView = mul(matWorld, g_matView);
    matrix matWorldViewProjection = mul(matWorldView, g_matProjection);
    
    float3 vecRight = matWorldView._11_21_31;
    float3 vecUp = matWorldView._12_22_32;

    float fActiveTime = g_fTime - billboard.m_fStartTime;
    float fSize = billboard.m_fSize;
    float fBrightness = 1 - min(billboard.m_fDistance / 600, 0.9f);
    float fImage = billboard.m_fImage;
    float fGlow = sin(clamp(fActiveTime * 3.1415926535897932384626433832795 / 2, 0, 3.1415926535897932384626433832795)) * 0.5;
        
    float3 vecPosition = billboard.m_vecPosition.xyz +
                         input.vecPosition.x * fSize * pow(clamp(fActiveTime, 0, 1), 0.5) * 0.5 * vecRight +
                         (input.vecPosition.y + 0.5) * fSize * vecUp;

    output.vecPosition = mul(float4(vecPosition.xyz, 1), matWorldViewProjection);
    output.vecTexCoord = input.vecTexCoord * float2(0.25, 1) + float2(fImage * 0.25, 0);
    output.vecTint = billboard.m_vecColour * float4(fBrightness - fGlow, fBrightness - fGlow, fBrightness + fGlow, clamp(fActiveTime, 0, 1));
    output.fActiveTime = fActiveTime;
    output.m_fPhaseFlicker = (sin(g_fTime * 22.3) + sin(g_fTime * 3.17)) * 0.015 + 1.0;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
	float fScan = min(1,input.fActiveTime / 10.0);// lerp(0.2, 1.2, abs(sin(input.vecPosition.y * 720 / 4)));
    float fSpreadR = sin(input.vecPosition.y * 20);
    float fSpreadG = sin(input.vecPosition.y * 40);
    float fSpreadB = sin(input.vecPosition.y * 60);
    float fR = texTexture.Sample(sampLinearWrap, input.vecTexCoord + float2(fSpreadR * 0.001, 0)).r;
    float fG = texTexture.Sample(sampLinearWrap, input.vecTexCoord + float2(fSpreadG * 0.001, 0)).g;
    float fB = texTexture.Sample(sampLinearWrap, input.vecTexCoord + float2(fSpreadB * 0.001, 0)).b;
    float fA = texTexture.Sample(sampLinearWrap, input.vecTexCoord).a;

	return float4(fR, fG, fB, fA) * input.vecTint * fScan * input.m_fPhaseFlicker;
}
