//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
Texture2D tex1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b2)
{
    float g_fTime;
    float g_fFloat1;
    float g_fFloat2;
    float g_fFloat3;
    float g_fFloat4;
    float g_fFloat5;
    float g_fFloat6;
    float g_fSeed;
};


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord0 * float2(1, 1280.0f / 720.0f), 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0.xy * float2(1.0, 1.0) + float2(0, g_fFloat1 - (g_fFloat1 % (1.0 / 40.0)));

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    int iPY = int(input.vecTexCoord0.y * 40);
    if (iPY < 50 || iPY > 150)
    {
        return 0;
    }
    int iLineLength = tex0.Sample(sampNearestWrap, float2(0.4, iPY * 0.1)).r * 30.0 + 32;
    int iPX = int(input.vecTexCoord0.x * 32 * 2);
    if (iPX < iLineLength || iPX > 60)
    {
        return 0;
    }
    int iCharIndex = tex0.Sample(sampNearestWrap, float2(iPX * 0.41, iPY * 0.33)).r * 32.0;

    float fTX = (input.vecTexCoord0.x * 2) % (1.0 / 32.0) + (1.0 / 32.0) * iCharIndex;
    float fTY = input.vecTexCoord0.y * 40;

    float4 vecColour = tex1.Sample(sampLinearWrap, float2(fTX, fTY)).r;
    return vecColour * 2.0;
}
