//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture3D texLut : register(t0);
Texture2D texSource : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b0)
{
    float g_fStrength;
    float gbrPad1, gbrPad2, gbrPad3;
};


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Support functions
//--------------------------------------------------------------------------------------
float3 TetrahedralInterpolate(float3 pos)
{
    float3 dims;
    texLut.GetDimensions(dims.x, dims.y, dims.z);

    dims -= 1;

    int3 ipos = int3(pos * dims);
    float4 c000 = texLut.Load(int4(ipos.x + 0, ipos.y + 0, ipos.z + 0,0));
    float4 c100 = texLut.Load(int4(ipos.x + 1, ipos.y + 0, ipos.z + 0,0));
    float4 c010 = texLut.Load(int4(ipos.x + 0, ipos.y + 1, ipos.z + 0,0));
    float4 c110 = texLut.Load(int4(ipos.x + 1, ipos.y + 1, ipos.z + 0,0));
    float4 c001 = texLut.Load(int4(ipos.x + 0, ipos.y + 0, ipos.z + 1,0));
    float4 c101 = texLut.Load(int4(ipos.x + 1, ipos.y + 0, ipos.z + 1,0));
    float4 c011 = texLut.Load(int4(ipos.x + 0, ipos.y + 1, ipos.z + 1,0));
    float4 c111 = texLut.Load(int4(ipos.x + 1, ipos.y + 1, ipos.z + 1,0));
    float3 d = frac(pos * dims);
    float3 c;

    [flatten] if (d.x > d.y) 
    {
        [flatten] if (d.y > d.z) 
        {
            c.x = (1-d.x) * c000.x + (d.x-d.y) * c100.x + (d.y-d.z) * c110.x + (d.z) * c111.x;
            c.y = (1-d.x) * c000.y + (d.x-d.y) * c100.y + (d.y-d.z) * c110.y + (d.z) * c111.y;
            c.z = (1-d.x) * c000.z + (d.x-d.y) * c100.z + (d.y-d.z) * c110.z + (d.z) * c111.z;
        } 
        else if (d.x > d.z) 
        {
            c.x = (1-d.x) * c000.x + (d.x-d.z) * c100.x + (d.z-d.y) * c101.x + (d.y) * c111.x;
            c.y = (1-d.x) * c000.y + (d.x-d.z) * c100.y + (d.z-d.y) * c101.y + (d.y) * c111.y;
            c.z = (1-d.x) * c000.z + (d.x-d.z) * c100.z + (d.z-d.y) * c101.z + (d.y) * c111.z;
        } 
        else 
        {
            c.x = (1-d.z) * c000.x + (d.z-d.x) * c001.x + (d.x-d.y) * c101.x + (d.y) * c111.x;
            c.y = (1-d.z) * c000.y + (d.z-d.x) * c001.y + (d.x-d.y) * c101.y + (d.y) * c111.y;
            c.z = (1-d.z) * c000.z + (d.z-d.x) * c001.z + (d.x-d.y) * c101.z + (d.y) * c111.z;
        }
    } 
    else 
    {
        [flatten] if (d.z > d.y) 
        {
            c.x = (1-d.z) * c000.x + (d.z-d.y) * c001.x + (d.y-d.x) * c011.x + (d.x) * c111.x;
            c.y = (1-d.z) * c000.y + (d.z-d.y) * c001.y + (d.y-d.x) * c011.y + (d.x) * c111.y;
            c.z = (1-d.z) * c000.z + (d.z-d.y) * c001.z + (d.y-d.x) * c011.z + (d.x) * c111.z;
        } 
        else if (d.z > d.x) 
        {
            c.x = (1-d.y) * c000.x + (d.y-d.z) * c010.x + (d.z-d.x) * c011.x + (d.x) * c111.x;
            c.y = (1-d.y) * c000.y + (d.y-d.z) * c010.y + (d.z-d.x) * c011.y + (d.x) * c111.y;
            c.z = (1-d.y) * c000.z + (d.y-d.z) * c010.z + (d.z-d.x) * c011.z + (d.x) * c111.z;
        } 
        else 
        {
            c.x = (1-d.y) * c000.x + (d.y-d.x) * c010.x + (d.x-d.z) * c110.x + (d.z) * c111.x;
            c.y = (1-d.y) * c000.y + (d.y-d.x) * c010.y + (d.x-d.z) * c110.y + (d.z) * c111.y;
            c.z = (1-d.y) * c000.z + (d.y-d.x) * c010.z + (d.x-d.z) * c110.z + (d.z) * c111.z;
        }
    }

    return c;
}


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    float2 vecTexCoord0 = input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1);
    output.vecPosition = float4(vecTexCoord0, 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0.xy;
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    float3 vecSourceColour = saturate(texSource.Sample(sampLinearClamp, input.vecTexCoord0).rgb);
    float3 vecColouredRGB = TetrahedralInterpolate(vecSourceColour);
    float3 vecFinalRGB = lerp(vecSourceColour, vecColouredRGB, g_fStrength);
    return float4(vecFinalRGB.rgb, 1);
}
