//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
Texture2D tex1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData: register(b0)
{
    float g_fStrength;
    float grdpad1, grdpad2, grdpad3;
};


#define PI 3.1415926


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float3 vecPosition : POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output;

    float2 vecTexCoord0 = (input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1)) * float2(1, 1);
    output.vecPosition = float4(vecTexCoord0, 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0;

    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS(PS_INPUT input) : SV_Target
{
    float3 vecColour = tex0.Sample(sampLinearClamp, input.vecTexCoord0).rgb;
    float3 vecDotColour = float3(250.0/255.0, 255.0/255.0, 246.0/255.0);
    float3 vecBackgroundColour = float3(0.0, 0.0, 150.0/255.0);

    const float2 vecAspect = float2(1920.0 / 1080.0, 1.0);
    float2 vecCorrected = input.vecTexCoord0 * vecAspect;
    float2 vecOrigin = float2(0.89, 0.37);

    int iDots = 20 * (1 - g_fStrength);
    for (float i = 0; i < iDots; i++) {
        float fAngle = i/20 * PI*2;
        float2 vecDotOrigin = vecOrigin + float2(-sin(fAngle)*0.3,-cos(fAngle)*0.3);
        float fDotDistance = length(vecCorrected - vecDotOrigin);
        if (fDotDistance < 0.027) {
            vecColour = lerp(vecDotColour, vecBackgroundColour, pow(fDotDistance/0.027,38)) * 0.85;
        }

    }

    return float4(vecColour.rgb, 1);
}

