//--------------------------------------------------------------------------------------
// Constant buffer variables
//--------------------------------------------------------------------------------------
Texture2D texSource : register(t0);
Texture2D texMask : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer PSBuffer : register(b0)
{
    float2 g_vecPixelOffset;
    float g_fStrength;
    int g_iNumSamples;
};

struct Sample
{
    float m_fWeight;
    float m_fOffset;
    float pad1, pad2;
};
StructuredBuffer<Sample> g_aSamples : register(t5);


//--------------------------------------------------------------------------------------
// IO structures
//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float2 vecTexCoord : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Support functions
//--------------------------------------------------------------------------------------
float4 doBlur(float2 vecTexCoord, float2 vecPixelOffset)
{
    float4 vecColour = 0;
    for (int i = 0; i < g_iNumSamples; i++)
    {
        Sample sample = g_aSamples[i];
        float2 vecTexCoordOffset = sample.m_fOffset * vecPixelOffset;
        vecColour += texSource.Sample(sampLinearClamp, vecTexCoord + vecTexCoordOffset) * sample.m_fWeight;
        vecColour += texSource.Sample(sampLinearClamp, vecTexCoord - vecTexCoordOffset) * sample.m_fWeight;
    }

    return vecColour;
}


//--------------------------------------------------------------------------------------
// Vertex shader
//--------------------------------------------------------------------------------------
PS_INPUT VS(VS_INPUT input)
{
    PS_INPUT output;
    output.vecPosition = float4(input.vecTexCoord.xy * float2(2, -2) + float2(-1, 1), 0, 1);
    output.vecTexCoord = input.vecTexCoord;
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel shader
//--------------------------------------------------------------------------------------
float4 PS_NoMaskHorizontal(PS_INPUT input) : SV_Target
{
    float2 vecPixelOffset = float2(g_vecPixelOffset.x, 0) * g_fStrength;
    return doBlur(input.vecTexCoord, vecPixelOffset);
}
float4 PS_NoMaskVertical(PS_INPUT input) : SV_Target
{
    float2 vecPixelOffset = float2(0, g_vecPixelOffset.y) * g_fStrength;
    return doBlur(input.vecTexCoord, vecPixelOffset);
}
float4 PS_MaskHorizontal(PS_INPUT input) : SV_Target
{
    float4 vecMask = texMask.Sample(sampLinearClamp, input.vecTexCoord);
    float fMaskStrength = vecMask.a;
    float2 vecPixelOffset = float2(g_vecPixelOffset.x, 0) * g_fStrength * fMaskStrength;
    return doBlur(input.vecTexCoord, vecPixelOffset);
}
float4 PS_MaskVertical(PS_INPUT input) : SV_Target
{
    float4 vecMask = texMask.Sample(sampLinearClamp, input.vecTexCoord);
    float fMaskStrength = vecMask.a;
    float2 vecPixelOffset = float2(0, g_vecPixelOffset.y) * g_fStrength * fMaskStrength;
    return doBlur(input.vecTexCoord, vecPixelOffset);
}


