//--------------------------------------------------------------------------------------
// Constant buffer variables
//--------------------------------------------------------------------------------------
Texture2D tex0 : register(t0);
Texture2D tex1 : register(t1);
SamplerState sampLinearClamp : register(s0);
SamplerState sampNearestClamp : register(s1);
SamplerState sampLinearWrap : register(s2);
SamplerState sampNearestWrap : register(s3);

cbuffer GlobalRenderData : register(b0)
{
    float2 g_vecPixelOffset;
    int g_iNumSamples;
    float g_fStrength;
    float g_fMiddleGrey;
    float g_fWhiteCutoff;
    float g_fCutOff;
    float grdpad1;
};

struct Sample
{
    float m_fWeight;
    float m_fOffset;
    float pad1, pad2;
};
StructuredBuffer<Sample> g_aSamples : register(t5);


//--------------------------------------------------------------------------------------
// IO structures
//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float2 vecTexCoord0 : TEXCOORD0;
};

struct PS_INPUT
{
    float4 vecPosition : SV_POSITION;
    float2 vecTexCoord0 : TEXCOORD0;
};


//--------------------------------------------------------------------------------------
// Support functions
//--------------------------------------------------------------------------------------
float4 doBlur(float2 vecTexCoord, float2 vecPixelOffset)
{
    float4 vecColour = 0;
    for (int i = 0; i < g_iNumSamples; i++)
    {
        Sample sample = g_aSamples[i];
        float2 vecTexCoordOffset = sample.m_fOffset * vecPixelOffset;
        vecColour += tex0.Sample(sampLinearClamp, vecTexCoord + vecTexCoordOffset) * sample.m_fWeight;
        vecColour += tex0.Sample(sampLinearClamp, vecTexCoord - vecTexCoordOffset) * sample.m_fWeight;
    }

    return vecColour;
}


//--------------------------------------------------------------------------------------
// Vertex shader
//--------------------------------------------------------------------------------------
PS_INPUT VS(VS_INPUT input)
{
    PS_INPUT output;
    output.vecPosition = float4(input.vecTexCoord0.xy * float2(2, -2) + float2(-1, 1), 0, 1);
    output.vecTexCoord0 = input.vecTexCoord0;
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel shader
//--------------------------------------------------------------------------------------
float4 PS_Bright(PS_INPUT input) : SV_Target
{
    float4 vecColour = tex0.Sample(sampLinearClamp, input.vecTexCoord0);
    vecColour.rgb *= g_fMiddleGrey / g_fCutOff;
    vecColour.rgb *= (1.0f + (vecColour.rgb / (g_fWhiteCutoff * g_fWhiteCutoff)));
    vecColour.rgb -= 5.0f;

    vecColour.rgb = max(vecColour.rgb, 0.0f);

    vecColour.rgb /= (10.0f + vecColour.rgb);

    return vecColour;
}
float4 PS_Horizontal(PS_INPUT input) : SV_Target
{
    float2 vecPixelOffset = float2(g_vecPixelOffset.x, 0);
    return doBlur(input.vecTexCoord0, vecPixelOffset);
}
float4 PS_Vertical(PS_INPUT input) : SV_Target
{
    float2 vecPixelOffset = float2(0, g_vecPixelOffset.y);
    return doBlur(input.vecTexCoord0, vecPixelOffset);
}
float4 PS_Combine(PS_INPUT input) : SV_Target
{
    float4 vecResult = tex0.Sample(sampLinearClamp, input.vecTexCoord0) + tex1.Sample(sampLinearClamp, input.vecTexCoord0) * g_fStrength;
    return vecResult;
}
