#version 330 core

uniform mat4 uWorldMatrix;
uniform mat4 uProjectionMatrix;
uniform mat4 uViewMatrix;

uniform sampler2D uDiffuseMap;
uniform float uTime;

// Custom uniforms
uniform vec3 ucEndPos;
uniform float ucAcceleration;
uniform float ucLifeTime;

in vec3 aPosition;
in vec3 aNormal; // Movement direction
in vec2 aTexCoord; // (Color U-coord, Start time)

out vec4 fColor;

// Mesh is drawn as points and points are moved like particles.

void main()
{
	float particleSpeed = ucAcceleration;
	float lifeTimeSeconds = ucLifeTime;
	vec3 endPos = ucEndPos;


	float startTime = aTexCoord.y;	// This is in seconds
	// uTime is on [0, 1]
	float realTime = uTime * lifeTimeSeconds;
	float timeElapsed = max(0.0f, realTime - startTime);
	
	// Accelerate out of start position and move towards endPos
	vec3 acc = aNormal * particleSpeed;
	vec3 start = aPosition;
	vec3 v = normalize(endPos - start);
	float t = timeElapsed;
	
	vec3 pos = start + v * t + 0.5 * acc * t * t;
	
	
	vec4 worldPos = uWorldMatrix * vec4(pos, 1.0);
	vec4 viewPos = uViewMatrix * worldPos;
	gl_Position =  uProjectionMatrix * viewPos;
	
	float colorU = aTexCoord.x;
	vec4 sampled = texture(uDiffuseMap, vec2(colorU, 0.5f));
	sampled.w = 1.0 - (uTime * uTime);
	fColor = sampled;
}
