#version 330

uniform sampler2D uDiffuseMap;
uniform sampler2D uIlluminationMap;
uniform float uAlpha;

in vec2 fTexCoord;

out vec4 fragColor; // first out variable is automatically written to the screen

void main()
{
	vec4 color = texture(uDiffuseMap, fTexCoord);
	
	if (color.a < 0.1f)
	{
		discard;
	}
	vec4 alphaSample = texture(uIlluminationMap, fTexCoord);
	color.a = max(0.0f, min(uAlpha + alphaSample.x, 1.0f));
	
	fragColor = color;
}
