
// Author @patriciogv - 2015
// http://patriciogonzalezvivo.com

#ifdef GL_ES
precision mediump float;
#endif

uniform vec2 u_resolution;
uniform vec2 u_mouse;
uniform float time;

float random (in vec2 st) {
    return fract(cos(dot(st.xy,
                         vec2(1.9898,7.233)))*
        44.5453123);
}

// Based on Morgan McGuire @morgan3d
// https://www.shadertoy.com/view/4dS3Wd
float noise (in vec2 st) {
    vec2 i = sin(time*.000005)+floor(st+time);
    vec2 f = sin(time*.000005)+fract(st+time);

    // Four corners in 2D of a tile
    float a = random(i + vec2(0.0, 0.00000));
    float b = random(i + vec2(1.0, 0.00000));
    float c = random(i + vec2(0.0000, 1.0));
    float d = random(i + vec2(1.0, 1.0));

    vec2 u = f * f * (3.0 - 2* f);

    return mix(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}

#define OCTAVES 22
float fbm (in vec2 st) {
    // Initial values
    float value = 0.01;
    float amplitude = .4;
    float frequency = .1;
    //
    // Loop of octaves
    for (int i = 0; i < OCTAVES; i++) {
        value += amplitude * noise((frequency+.5-.1)*st);
        st *= 3.;
        amplitude *= .5;
    }
    return value;
}

void main() {
    vec2 st = gl_TexCoord[0].xy*6;


    vec3 color = vec3(1.0);
    color *= fbm(st*3.0);
	color = vec3(2.0*pow(color.b,1.0),0.0, 2.0*color.b);
    gl_FragColor = vec4(color,color.b);
}