/*
 * Decompiled with CFR 0.152.
 */
package states;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.ArrayList;
import sprites.Arne;
import sprites.Person;
import states.GameStateManager;
import states.State;
import states.WinState;

public class PlayState
extends State {
    private Texture blueBackground = new Texture("bg.png");
    private ArrayList<Person> persons = new ArrayList();
    private Arne arne = new Arne();
    private long startTime;
    public static long TIME_PASSED_IN_SECONDS;

    public PlayState(GameStateManager gsm) {
        super(gsm);
        for (int i = 0; i < 400; ++i) {
            this.persons.add(new Person());
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void handleInput() {
    }

    @Override
    public void update(float dt) {
        if (Gdx.input.justTouched() && this.hasClickedOnArne()) {
            this.gsm.push(new WinState(this.gsm));
        }
        TIME_PASSED_IN_SECONDS = System.currentTimeMillis() - this.startTime;
    }

    private boolean hasClickedOnArne() {
        return this.hasClickedBetweenXCoordinates() && this.hasClickedBetweenYCoordinates();
    }

    private boolean hasClickedBetweenXCoordinates() {
        float leftX = this.arne.getXCoordinate();
        float rightX = this.arne.getXCoordinate() + (float)this.arne.getArneImg().getWidth();
        return (float)Gdx.input.getX() > leftX && (float)Gdx.input.getX() < rightX;
    }

    private boolean hasClickedBetweenYCoordinates() {
        float lowYInverted = this.arne.getYCoordinate();
        float highYInverted = this.arne.getYCoordinate() + (float)this.arne.getArneImg().getHeight();
        float highY = 730.0f - lowYInverted;
        float lowY = 730.0f - highYInverted;
        return (float)Gdx.input.getY() > lowY && (float)Gdx.input.getY() < highY;
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.begin();
        sb.draw(this.blueBackground, 0.0f, 0.0f, 730.0f, 730.0f);
        for (Person person : this.persons) {
            sb.draw(person.getCurrentPersonImg(), person.getXCoordinate(), person.getYCoordinate());
        }
        sb.draw(this.arne.getArneImg(), this.arne.getXCoordinate(), this.arne.getYCoordinate());
        sb.end();
    }

    @Override
    public void dispose() {
    }
}

