;Just Plasma
;By Harekiet for revision 2018
;Big Thanks to HellMood for all kinds of tricks to get this to fit

cpu 386
org	0100h

;Setup video mode
mov	al,13h
int	10h

;set video segment
push 0xa000
pop es

;Setup font pointer 
push 0xf000 + 0xfa6
pop gs

;Needs to be 0 from the text to scroll correctly
xor bp,bp

restart:
cwd
mov ax, di

; xor dx, dx
mov cx, 320
CONST_320:
div cx

;fninit

;push now for plasma calculations later on
pusha

;Split the screen in 4 parts
;each part should be rendered in 512 counts
mov cl, 50
div cl

;part in al
;subrow in ah
movzx si, al
;512 frames
mov cx, bp
shr cx, 9

cmp cl, al


;just deal with the indiviual portion
movzx ax,ah
;Put column in ax
xchg ax, dx

je drawscroll
;Not yet time for this row
jb skiptext

;Draw at a fixed location
mov bp,-1

drawscroll:

drawstart:

and bp, 511
sub ax, 511+32
add ax,bp

push ax
shr ax, 2
and al, 7
xchg cx, ax

pop ax
shr ax, 5
cmp al, 7
ja skiptext

;Correct for the correct row of text
shl si, 3
add si, ax
movzx si, byte [si+text1]

;add the row, skip some rows to make it center
xchg ax,dx
sub al, (50-32)/2
cmp al, 31
ja skiptext
shr ax, 2

;get the font and extract the bit
shl si, 3
add si, ax
shl byte [gs:si+0xe],cl
jnc skiptext
mov al, 128
jmp drawtext
skiptext:
mov al, 0
drawtext:
mov [es:di],al

;Calculate some plasma thing
;pusha starts at 0xfffc with ax and bx-4

mov di, -8

fldz

;make si point to bp on the stack
;make bx a relative offset
mov si,-14
mov bx, axisscale0+8
%define BXOFFSET (bx-axisscale0-8)

axisloop:

;Different time speeds for both axes based on bp counter
fild word [si]	;load bp
fmul dword [BXOFFSET+speedscale0+8+di] 

fild word [di]	;load ax or dx
fmul dword [BXOFFSET+axisscale0+8+di]

fild word [si]	;load bp
fmul dword [BXOFFSET+axisscale0+12+di]
fmul dword [BXOFFSET+speedscale0+8+di] 
fcos
fdiv dword [BXOFFSET+speedscale0+8+di]
faddp
faddp

fsin
;add to the total color
faddp

add di, 4
jnz axisloop

;Scale by around 16
fdiv dword [BXOFFSET+axisscale1]
fistp word [si+10]

popa


;Add a color cycling factor
push bp
shr bp,3
add ax,bp
pop bp

;Nice palette trick
aam 23
add al,32+24
;Invert when everything is done
cmp bp, 512*4+128
jb directplasma
or byte [es:di],0
jz skipplasma
add al,128
directplasma:
add [es:di],al
skipplasma:

;semi randomly walk through the entire display space
imul di, byte 57
inc di
jnz restart

;Forward the internal timer
add bp,5

;No fancy key checking, just loop
jmp restart

text1 db '   NO   ' 
text2 db ' PLASMA ' 
text3 db '  JUST  '
text4 db 'REVISION'
;plasma speeds
axisscale0 dd 0.0242
axisscale1 dd 0.063
speedscale0 dd -0.056
speedscale1 dd 0.0323
