alias dinc { inc $+(%,$1) $calc(%dm.frt * $2) }
alias ddec { dec $+(%,$1) $calc(%dm.frt * $2) }

alias dmDrawFrame {

        var -g %dm.c = $ticks - %dm.ticks.main
        ;;dmDebug
        drawdot @demo
        drawcopy @demo 0 0 %dm.screen.w %dm.screen.h @demo.fs 0 0 %dm.fs.w %dm.fs.h
        .timerdmDrawFrame -mh 1 0 $1
        var -g %dm.frt = %dm.c - %dm.frt.start, %dm.frt.start = %dm.c
}

;; for hashtables
alias hdinc { hinc $1 $2 $calc(%dm.frt * $3) }
alias hddec { hdec $1 $2 $calc(%dm.frt * $3) }

;; $1 window, $2 transparent colour, $3 optional cycle push
alias dmInterlace {

        if (%dm.interlace == 1) {

                drawcopy -t @dm.interlace.1 $2 0 0 320 180 $1 0 0
                set %dm.interlace $iif($3 == 1, 1, 0)
        }

        else {

                drawcopy -t @dm.interlace.2 $2 0 0 320 180 $1 0 0
                set %dm.interlace $iif($3 == 1, 0, 1)
        }
}

alias dmDebug {

        if (%dm.debug == 1) {

                inc %dm.fps.count

                if ($calc($ticks - %dm.fps.ticks.start) >= 1000) {

                        set %dm.fps.current %dm.fps.count
                        set %dm.fps.count 0
                        set %dm.fps.ticks.start $ticks
                }

                drawtext -nrb @demo 65535 0 terminal 5 2 2 fps: %dm.fps.current frt: %dm.frt c: %dm.c
        }
}

alias dmInit {

        ;; check if we're running the correct version

        if ($version <= 6.35) {

                if (($version > 6.00) && ($version < 6.35)) {

                        echo -s You're running mIRC $version
                        echo -s This should be fine, but you may experience some issues.
                        echo -s For optimal results, get mIRC 6.35:
                        echo -s http://www.mirc.com/get.php?version=635
                }

                ;; set debug display options here

                set %dm.debug 1

                ;;--------------------------------------------------------
                ;;
                ;; okay, here we go! Experimental screenmode support!
                ;;
                ;; the system used to be fixed to resolutions of 320*180.
                ;; this is mainly for speed purposes, since mIRC is slower
                ;; than a snail on opiates.
                ;;
                ;; However, for some parts it may be desired to have a higher
                ;; resolution.
                ;;
                ;; What we do is, we define at the start different screenmodes.
                ;; When selecting a part, the signal "<partname> run" will be sent.
                ;; from there, you can simply execute the following:
                /*

                on *:SIGNAL:demo_foo: {

                        if ($1 == run) {

                                dmScreenMode n
                        }
                }

                */
                ;;
                ;; Where n is any of the following modes:
                ;;
                ;; 1) 320*180
                ;; 2) 640*360
                ;; 3) 854*480
                ;; 4) 1280*720
                ;; 5) 1600*900
                ;; 6) 1920*1080
                ;;
                ;; This list will be expanded; any future modes will be added
                ;; at the end of the list, and thus it is not sorted from lores
                ;; to hires.
                ;;
                ;; If you don't set a screenmode on init_run, don't worry. It'll
                ;; safely assume 320*180 for compatibility.
                ;;
                ;; Of course your custom screen will still be copied to the
                ;; fullscreen window if fullscreen is enabled, so keep in mind
                ;; that screenmodes will most likely be limited to 16:9 aspect
                ;; ratio resolutions.
                ;;
                ;; And please be aware that this has *nothing* to do with any
                ;; background buffers you may want to use. Those are still
                ;; "unlimited" in size, although using buffers equal to or
                ;; larger than the native resolution of the target machine
                ;; has a tendency to bug out. sometimes. Actually always.

                dmScreenMode 1

                window -oh @demo

                if ($1 == fs) {

                        set %dm.fs.w $window(-1).w
                        set %dm.fs.h $window(-1).h

                        if ($window(@demo.fs) != $null) {

                                window -c @demo.fs
                        }

                        window -dak0pfBbo +d @demo.fs 0 0 %dm.fs.w %dm.fs.h

                        ;; change to 0 before release (:
                        set %dm.setlayer 255
                        setlayer %dm.setlayer @demo.fs

                        ;; make the window background black!
                        drawrect -rf @demo 0 0 0 0 320 180

                        set %dm.fs 1

                        tokenize 32 $2-
                }

                elseif ($1 == fs2) {

                        ;; this is purely for me to test shit on my projector
                        ;; regardless, if you want to run fullscreen on a second monitor,
                        ;; just adjust the settings below at your own discretion.

                        set %dm.fs.w 640
                        set %dm.fs.h 360

                        if ($window(@demo.fs) != $null) {

                                window -c @demo.fs
                        }

                        window -dak0pfBbo +d @demo.fs $calc((2560 - %dm.fs.w) - 20) 80 %dm.fs.w %dm.fs.h

                        set %dm.fs 1

                        tokenize 32 $2-
                }

                set %dm.flags $1-

                set %dm.ticks.main $ticks
                set %dm.fps.ticks.start $ticks
                set %dm.fps.count 0
                set %dm.preload.ctab 0 197379 395015 657930 986639 1250068 1579032 1907997 2302498 2631720 3026222 3421236 3815994 4276289 4671303 5066062 5526613 6052700 6513506 6974058 7434609 7895160 8355967 8882055 9342606 9803413 10263708 10789796 11250346 11645362 12105912 12500927 12895685 13421771 13750737 14145495 14539996 14869218 15198183 15527148 15856112 16119029 16382200 16579836 16777215 16579836 16382201 16119029 15855856 15527148 15198183 14869218 14539996 14145495 13750737 13355979 12961221 12500926 12105912 11645361 11185066 10789796 10263965 9803157 9342606 8882055 8421504 7895160 7434609 6974058 6513506 5987419 5592405 5066317 4736839 4276544 3815994 3421235 3026477 2631720 2236962 1907997 1578776 1250067 986894 723722 395015 197379 0
                set %dm.preload.c 1

                window -he @dm.log
                clear @dm.log

                ;;----------------------------------------------------------

                ;; yes this is messy. but whatever, it makes my life a bit easier. Don't judge. ;(

                ;set %dm.music $qt($scriptdirsnd/demotrack.mp3)
                ;; use this for sync, by incrementing some variable. `dinc somevar %dm.bpm` will take ~1 beat to go from 0 to 1.
                ;; not an exact value. to be improved.
                set %dm.bpm 0.001587
                dmOpenBuffer @dm.interlace.1 320 320
                dmOpenBuffer @dm.interlace.2 320 320
                dmTilePic @dm.interlace.1 $scriptdirimg\raster-1.png
                dmTilePic @dm.interlace.2 $scriptdirimg\raster-2.png
                set %dm.interlace 0

                ;;----------------------------------------------------------

                .load -rs $qt($scriptdirpreload.mrc)

                set %dm.ticks $ticks
                set %dm.preload.tot $lines($scriptdirprecalc.ftg)

                if ($left(%dm.flags, 1) == !) {

                        set %dm.flags $right(%dm.flags, -1)

                        noop $read($scriptdirprecalc.ftg, nw, dmLoadPart $+(%dm.flags,.mrc))

                        set %dm.preload.cnt $readn

                        .signal -n dmSelectPart preloadSingle
                }

                else {

                        set %dm.preload.cnt 1

                        .signal -n dmSelectPart preload
                }
        }

        else {

                echo -s You're running mIRC $version
                echo -s Because of the internal change to unicode in 7.0 and newer,
                echo -s there are some severe performance penalties.
                echo -s For optimal results, get mIRC 6.35:
                echo -s http://www.mirc.com/get.php?version=635
                echo -s -------
                echo -s If you really do insist on using 7.xx or newer, feel free to hack the engine to remove this check,
                echo -s but don't blame us if you find that the entire demo runs at 5 fps.
                echo -s -------
                echo -s this demo will now die x.x;
        }
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Global functions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

alias dmScreenMode {

        var %modes.w 320   640   854  1280  1600  1920
        var %modes.h 180   360   480   720   900  1080

        if ($isid) {

                if ($1 == $null) {

                        return %dm.screenmode
                }

                else {
                        if ($prop == w) {

                                return $gettok(%modes.w, $1, 32)
                        }

                        elseif ($prop == h) {

                                return $gettok(%modes.h, $1, 32)
                        }
                }
        }

        if ($1 isnum) {

                ;echo -s Setting screenmode: $1

                set %dm.screen.w $gettok(%modes.w, $1, 32)
                set %dm.screen.h $gettok(%modes.h, $1, 32)

                set %dm.screenmode $1
        }

        elseif ($1 == -c) {

                ;echo -s Setting custom screenmode: $2-

                set %dm.screen.w $2
                set %dm.screen.h $3

                set %dm.screenmode 0
        }
        set %dm.screen.x $calc($window(-1).w - %dm.screen.w)
        set %dm.screen.y 0

        ;echo -s Screen will be set to %dm.screen.w * %dm.screen.h

        window -hdk0pfbB +b @demo %dm.screen.x %dm.screen.y %dm.screen.w %dm.screen.h
        ;window -hp @demo %dm.screen.x %dm.screen.y %dm.screen.w %dm.screen.h
}

alias dmExit {

        ;; Demoralization is a polite demosystem that (mostly)
        ;; cleans up after itself before leaving, as any decent being would do.

        .timerdmDrawFrame off
        splay stop
        drawpic -c
        unset %dm.*
        hfree -sw dm.*

        if ($window(@demo) != $null) {

                window -c @demo
        }

        if ($window(@demo.fs) != $null) {

                window -c @demo.fs
        }

        var %cnt 1
        var %tot $window(@dm.*, 0)

        while (%cnt <= %tot) {

                var %win $window(@dm.*, %cnt)

                if ((%win != $null) && (%win != @dm.log)) {

                        window -c %win
                }

                inc %cnt
        }

        if ($script(debug.mrc) != $null) {

                .unload -rs debug.mrc
        }
}

;; Generates a colour table based on a 1*n image.
;; $1- refers to any image.
;; If not called as an $identifier, $1 is a hashtable name.

alias dmGenCtab {

        var %pic $iif($isid == $true, $1-, $2-)
        var %cnt 0
        var %tot $calc($pic(%pic).height + 2)

        var %r

        if ($window(@palgen) != $null) {

                window -c @palgen
        }

        window -dak0pfh @palgen 0 0 1 %tot

        drawpic @palgen 0 0 $qt(%pic)

        while (%cnt < %tot) {

                var %dot $getdot(@palgen, 0, %cnt)

                if ($isid == $true) {

                        var %r $instok(%r, %dot, 0, 32)
                }

                else {
                        hadd $1 %cnt %dot
                }

                inc %cnt
        }

        ;; for some reason this garbage number is added to the end
        ;; of every table. This is just a quick'n'dirty hack to
        ;; get rid of it.

        return $remove(%r, 4294967295)

        window -c @palgen
}

;; just a temporary hack using the old dmGenCtab().

alias dmGenCtabAlt {

        var %w $+(@,$1)
        var %i $2

        ;; get all the colour values into a tokenized var

        var %tab $dmGenCtab(%i)

        ;; create window to store values

        if ($window(%w) != $null) {

                window -c %w
        }

        window -hl %w

        var %cnt 1
        var %tot $numtok(%tab, 32)

        while (%cnt <= %tot) {

                echo -s adding $+(%cnt,/,%tot) to %w
                aline %w $gettok(%tab, %cnt, 32)

                inc %cnt
        }
}





;; generates a table with random values
;; $1 = length, $2 = min value, $3 = max value
;; if called as command instead of $identifier, it populates a hastable.
;; $1 = tableName, $2 = length, $3 = min value, $4 = max value
alias dmRandTab {

        var %cnt 1

        if ($isid == $true) {

                while (%cnt <= $1) {

                        var %r $instok(%r, $rand($2, $3), $numtok(%r, 32), 32)
                        inc %cnt
                }

                return %r
        }

        else {

                while (%cnt <= $2) {

                        hadd $1 %cnt $rand($3, $4)
                        inc %cnt
                }
        }
}

;; build colour tables based on Pepto's c64 emulator palette
alias dmVicII {

        ;; vic-II palette:
        ;;1  black:    0
        ;;2  white:    16777215
        ;;3  red:      2832232
        ;;4  cyan:     11707504
        ;;5  purple:   8797551
        ;;6  green:    4427096
        ;;7  blue:     7940149
        ;;8  yellow:   7325624
        ;;9  li.brown: 2445167
        ;;10 brown:    14659
        ;;11 li.red:   5859226
        ;;12 darkgrey: 4473924
        ;;13 grey:     7105644
        ;;14 li.green: 8704666
        ;;15 li.blue:  11886188
        ;;16 li.grey:  9803157
        var %table 0 16777215 2832232 11707504 8797551 4427096 7940149 7325624 2445167 14659 5859226 4473924 7105644 8704666 11886188 9803157
        var %count 1
        var %total $0
        var %r

        while (%count <= %total) {

                var %r $instok(%r, $gettok(%table, $ [ $+ [ %count ] ], 32), $numtok(%r, 32), 32)

                inc %count
        }

        return %r
}

;; Opens a new background window/buffer/whatev
;; $1 == window name, $2- == w / h

alias dmOpenBuffer {

        echo -s opening: $1 / $2-

        if ($window($1) != $null) {

                ;echo -s already open, closing first

                window -c $1
        }

        window -dk0pfh $1 0 0 $2-
        drawrect -nrf $1 0 0 0 0 $2-

        if ($window($1) == $null) {

                echo -s Failed to open $1-
        }
}

;; Tiles an image across a background buffer
;; $1 == window, $2 == image
alias dmTilePic {

        var %win        $1
        var %win.w      $window(%win).w
        var %win.h      $window(%win).h
        var %pic        $2
        var %pic.w      $pic(%pic).width
        var %pic.h      $pic(%pic).height

        var %x 0

        while (%x < %win.w) {

                var %y 0

                while (%y < %win.h) {

                        drawpic -n %win %x %y %pic

                        inc %y %pic.h
                }

                inc %x %pic.w
        }
}

alias dmTexBuffer {

        var %win $1
        var %pic $2-

        dmOpenBuffer %win $pic(%pic).width $pic(%pic).height
        drawpic %win 0 0 $qt(%pic)
}


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ---- EVENTS ----
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

on *:SIGNAL:dmSelectPart: {

        dmScreenMode 1

        signal -n $+(demo_,$1) init
        signal -n $+(demo_,$1) run

        set %dm.ticks.main $ticks
        set %dm.fps.ticks.start $ticks
        ;set %dm.fps.count 0
        set %dm.c 0
        set %dm.frt.start 0

        $+(demo_,$1)
}

on *:CLOSE:@demo*: {

        dmExit
}

on *:KEYDOWN:*:*: {

        echo -s Keypress: $keyval


        ;; ESC
        if ($keyval == 27) {

                dmExit
        }

        ;; space

        if ($keyval == 32) {

                echo -s %dm.c
        }


        ;; F3
        if ($keyval == 114) {

                set %dm.debug $xor(%dm.debug, 1)
        }

        ;; F4
        if ($keyval == 115) {

                set %dm.dcpf $xor(%dm.dcpf, 1)

                if (%dm.dcpf == 1) {

                        .load -rs $qt($scriptdirdebug.mrc)
                }

                else {

                        .unload -rs $qt($scriptdirdebug.mrc)
                }
        }
        ;; F5
        if ($keyval == 116) {

                ;var %mode $dmScreenMode
                ;var %screen.w $dmScreenMode($dmScreenMode).w
                ;var %screen.h $dmScreenMode($dmScreenMode).h

                ;window -dak0pfbBo +b @debug.view $calc($window(-1).w - %screen.w) 0 %screen.w %screen.h

                .load -rs $qt($scriptdirdebug.mrc)

                set %dm.debug 0
                set %dm.debug.height 40
                set %dm.debug.total $line(@dm.debug, 0)
                set %dm.debug.offset $calc((%dm.debug.total) - (%dm.debug.height / 2))

                .timerdmDrawFrame off

                .signal -n dmSelectPart debug
        }

        ;; F6
        if ($keyval == 117) {

                set %dm.framedump 1
                echo -s framedumping enabled.
        }

        ;; up
        if ($keyval == 38) {

                dec %dm.debug.offset
        }

        ;; down
        if ($keyval == 40) {

                inc %dm.debug.offset
        }

        ;;pgup
        if ($keyval == 33) {

                dec %dm.debug.offset %dm.debug.height

        }

        ;;pgdn
        if ($keyval == 34) {

                inc %dm.debug.offset %dm.debug.height
        }
}

on *:LOAD: {

        var %file $scriptdirtools.mrc

        if ($file(%file) != $null) {

                load -rs $qt(%file)
        }
}

alias dmLoadPart {

        var %file $+($scriptdir,$1-)

        if ($nopath(%file) != demo.mrc) {

                echo @dm.log > %file

                .load -rs $qt(%file)
        }
}

alias ftg01 {

        dmInit fs title
}

;; copy/paste this in a status window to force-unload all scripts:
;; //var %x $script(0) | while (%x > 0) { unload -rs $qt($script(%x)) | dec %x }


;; note: non-antaliased fonts:
;; Courier, Fixedsys, Modern, MS Sans Serif, Ms Serif, Script, Small Fonts, System, Terminal, Webdings, Wingdings