<?php

date_default_timezone_set('Europe/Berlin');

// $sessionStartTime= strtotime('2018-04-01 17:25')*1000;
$sessionStartTime= strtotime('2018-03-31 18:48')*1000;
// $sessionEndTime= $sessionStartTime+4*60*1000;
$sessionEndTime= $sessionStartTime+10*60*1000;
// debugAndDie( date("Y-m-d H:i:s", time()) );


require_once('Db.php');

$buildingTypes= array(
	0 => array(
		'name'=>'Bitcoin miner',
		'hp'=>1000,
		'build_time'=>10*1000,
		'cost'=>100,
	),
	1 => array(
		'name'=>'Demogroup HQ',
		'hp'=>1000,
		'build_time'=>40*1000,
		'cost'=>250,
	),
	2 => array(
		'name'=>'Pub',
		'hp'=>1500,
		'build_time'=>15*1000,
		'cost'=>100,
	),
	3 => array(
		'name'=>'Garage',
		'hp'=>2000,
		'build_time'=>20*1000,
		'cost'=>200,
	),
	4 => array(
		'name'=>'Programmer 7 bedrooms villa with swimmingpool and bar',
		'hp'=>1000,
		'build_time'=>20*1000,
		'cost'=>300,
	),
);



$unitTypes= array(
	array(
		'name'=>'Dog',
		'speed'=>200,
		'hp'=>80,
		'build_time'=>5*1000,
		'cost'=>30,
		'train_in'=>2,
		'attack'=>10,
		'range'=>1,
		'cooldown'=>500,
	),
	array(
		'name'=>'Infranty',
		'speed'=>100,
		'hp'=>100,
		'build_time'=>5*1000,
		'cost'=>50,
		'train_in'=>2,
		'attack'=>20,
		'range'=>3,
		'cooldown'=>1*1000,
	),
	array(
		'name'=>'Tank',
		'speed'=>120,
		'hp'=>500,
		'build_time'=>15*1000,
		'cost'=>500,
		'train_in'=>3,
		'attack'=>500,
		'range'=>5,
		'cooldown'=>2*1000,
	),
	array(
		'name'=>'F16',
		'speed'=>250,
		'hp'=>300,
		'build_time'=>20*1000,
		'cost'=>450,
		'train_in'=>3,
		'attack'=>100,
		'range'=>4,
		'cooldown'=>2*1000,
	),
	///@todo more units
);




function debug($var){
	static $css= false;
	if(!$css){
		echo '<style>body{background-color:#000;color:#888;}</style><pre>';
		$css= true;
	}
	print_r($var);
	echo "\n";
}



function debugAndDie($var){
	debug($var);
	die();
}



function redirect($url){
	header("Location: $url");
	die();
}



function strhextoint($str){
	list($r)= sscanf($str,"%X");
	// debugAndDie($r);
	return $r;
}



function getTime(){
	// $configStartTime= 1522006846;
	// return microtime(true) - $configStartTime;
	// return microtime(true);
	return floor(microtime(true)*1000);
}



function getUnitCurrentPosition($unit, $time){
	global $unitTypes;
	$type= $unitTypes[$unit['type_id']];
	$speed= $type['speed'];
	$tt= $time - $unit['utime'];
	$sx=$unit['x'];
	$sy=$unit['y'];
	$tx=$unit['tx'];
	$ty=$unit['ty'];
	$dis= sqrt( ($tx-$sx)*($tx-$sx) + ($ty-$sy)*($ty-$sy) );
	if( $dis <= 0 )
		return array($sx,$sy);
	
	$h= $tt * $speed / $dis / 1000 / 60;
	if( 1.0 < $h )
		$h= 1.0;

	$r= array();
	$r[0]= $sx*(1-$h) + $tx*$h;
	$r[1]= $sy*(1-$h) + $ty*$h;

	return $r;
}



function getUserGold($userId,$time=null){
	global $sessionEndTime;
	if($time===null)
		$time= getTime();
	if( $sessionEndTime < $time )
		$time= $sessionEndTime;
	$userId= (int)$userId;
	return floor(DB::I()->getOne("
		SELECT u.gold + IFNULL( (
			SELECT SUM( ($time - b.utime) / 1000 )
			FROM buildings AS b
			WHERE b.user_id = '$userId'
			AND b.type_id = 0
		), 0)
		FROM users AS u
		WHERE u.id = '$userId' 
		LIMIT 1
	"));
}



function getUserScore($userId,$time=null){
	global $sessionEndTime;
	if($time===null)
		$time= getTime();
	if( $sessionEndTime < $time )
		$time= $sessionEndTime;
	$userId= (int)$userId;
	return floor(DB::I()->getOne("
		SELECT u.score + IFNULL( (
			SELECT SUM( ($time - b.utime) / 1000 )
			FROM buildings AS b
			WHERE b.user_id = '$userId'
			AND b.type_id = 4
		), 0)
		FROM users AS u
		WHERE u.id = '$userId' 
		LIMIT 1
	"));
}



/// apply data cached in buildings
function upgradeUserData($userId){
	global $sessionEndTime;
	$userId= (int)$userId;
	$gold= (int)(getUserGold($userId));
	$score= (int)(getUserScore($userId));
	$time= getTime();
	if( $sessionEndTime < $time )
		$time= $sessionEndTime;
	DB::I()->exec("UPDATE users SET gold='$gold', score='$score' WHERE id = '$userId' LIMIT 1");
	DB::I()->exec("UPDATE buildings SET utime='$time' WHERE user_id = '$userId' AND type_id IN (0,4)");
}



function getTopUsersList(){
	global $sessionEndTime;
	$time= getTime();
	if( $sessionEndTime < $time )
		$time= $sessionEndTime;
	$users= DB::I()->fetchAll("
		SELECT 
			u.nickname,
			u.color,
			( 
				u.score + IFNULL( (
					SELECT SUM( ($time - b.utime) / 1000 )
					FROM buildings AS b
					WHERE b.user_id = u.id
					AND b.type_id = 4
				), 0)
			) AS total_score
		FROM users AS u
		ORDER BY total_score DESC, u.id DESC
		LIMIT 100
	");
	return $users;
}



function main(){
	session_start();
	global $unitTypes, $buildingTypes, $sessionStartTime, $sessionEndTime;

	$mod= isset($_GET['mod']) ? $_GET['mod'] : 'app';
	switch($mod){
		case 'login':{
			if( $sessionEndTime < getTime() ){
				///@todo maybe some nice error message with some HTML+CSS
				die("Session is already ended. Maybe some other time.");
			}
			$view= 'login.php'; 
			require('view/layout.php'); 
			die();
		}
		case 'join':{
			if( $sessionEndTime < getTime() ){
				///@todo maybe some nice error message with some HTML+CSS
				die("Session is already ended. Maybe some other time.");
			}
			/// join action, and redirect 
			$nickname= substr(preg_replace('/[^A-Za-z0-9_]+/','_',$_POST['nickname']),0,30);
			$color= '';
			for($a=0;$a<3;$a++)
				$color .= sprintf("%X",mt_rand(3,0xE));
			DB::I()->exec("INSERT INTO users (nickname,color) VALUES('$nickname','$color');");
			$userId=  DB::I()->lastInsertRowID();
			$_SESSION['user_id']= $userId;

			/// select starting point
			$rad= sqrt($userId) * 0x10;
			$rad2= 0.5;
			$sx= (int)($rad*sin($rad*0.2)*$rad2);
			$sy= (int)($rad*cos($rad*0.2)*$rad2);

			/// insert starting buildings
			$hp= (int)($buildingTypes[1]['hp']);
			DB::I()->exec("INSERT INTO buildings (user_id,x,y,type_id,hp) VALUES($userId,$sx,$sy,1,$hp);");

			/// creating starting unit
			$utime= max( getTime(), $sessionStartTime );
			$hp= (int)($unitTypes[1]['hp']);
			for($a=-1;$a<=1;$a++)
				DB::I()->exec("INSERT INTO units (user_id,type_id,hp,utime,x,y,tx,ty) VALUES($userId,1,$hp,$utime,".($sx+$a).",".($sy+1).",".($sx+2*$a).",".($sy+3).");");

			/// redirecrt to app
			redirect('?mod=app&mapx='.$sx.'&mapy='.$sy);
		}
		case 'app':{
			/// code for application session (important part)
			global $user, $users, $buildings, $units, $userId;
			if(!isset($_SESSION['user_id']))
				redirect("?mod=login");
			$userId= (int)$_SESSION['user_id'];
			$user= DB::I()->fetchRow("SELECT * FROM users WHERE id = '$userId'");
			if(count($user)<=0)
				redirect("?mod=login");
			$users= DB::I()->fetchAll("SELECT * FROM users");
			$buildings= DB::I()->fetchAll("SELECT * FROM buildings");
			$units= DB::I()->fetchAll("SELECT * FROM units");
			break;}
		case 'update':{
			/// get some data and return json data

			if( isset($_GET['miny']) )
				$miny= (int)$_GET['miny'];
			else 
				$miny= -0x1000;
			if( isset($_GET['minx']) )
				$minx= (int)$_GET['minx'];
			else 
				$minx= -0x1000;
			if( isset($_GET['maxy']) )
				$maxy= (int)$_GET['maxy'];
			else 
				$maxy=  0x1000;
			if( isset($_GET['maxx']) )
				$maxx= (int)$_GET['maxx'];
			else 
				$maxx=  0x1000;

			/// make sure sesion is started
			$time= getTime();
			if( $time < $sessionStartTime )
				die("wait");
			if( $sessionEndTime < $time )
				die("to late");
			
			/// first end tasks of our buildings
			$userId= (int)$_SESSION['user_id'];
			$buildings= DB::I()->fetchAll("SELECT * FROM buildings WHERE user_id = '$userId' AND task_end_time < '$time'");
			foreach( $buildings as $b ){
				if(false){
				}elseif( 200 <= $b['task_id'] ){
					///@test units buildings
					$x= $b['x'];
					$y= $b['y'];
					$ty= $b['y']+1;
					$unitTypeId= (int)($b['task_id']-200);
					$hp= $unitTypes[$unitTypeId]['hp'];
					DB::I()->exec("INSERT INTO units (user_id,type_id,utime,x,y,tx,ty,hp) VALUES($userId,$unitTypeId,$time,$x,$y,$x,$ty,$hp);");
					DB::I()->exec("UPDATE buildings SET task_id = 0, utime=$time WHERE id = $b[id] LIMIT 1");
				}elseif( 100 <= $b['task_id'] ){
					/// buildings building
					/// if will be finished when user will click where to build it
				}elseif( 1 == $b['task_id'] ){
					/// some other building tasks may be added here
				}
			}

			///@todo use filters to return on part of data
			$users= DB::I()->fetchAll("
				SELECT * 
				FROM users
			");
			$buildings= DB::I()->fetchAll("
				SELECT * 
				FROM buildings
				WHERE user_id = '$userId'
				OR (
					$minx < x AND x < $maxx
					AND
					$miny < y AND y < $maxy
				)
			");
			$units= DB::I()->fetchAll("
				SELECT * 
				FROM units
				WHERE user_id = '$userId'
				OR (
					$minx < x AND x < $maxx
					AND
					$miny < y AND y < $maxy
				)
			");
			$you= array(
				'gold'=>getUserGold($userId,$time),
				'score'=>getUserScore($userId,$time),
			);
			die(json_encode(array(
				// 't'=>getTime(),
				'p'=>$users,
				'b'=>$buildings,
				'u'=>$units,
				'y'=>$you,
			)));}
		case 'prebuild':{
			global $buildingTypes;
			$time= getTime();
			if( $time < $sessionStartTime )
				die("wait");
			if( $sessionEndTime < $time )
				die("to late");
			/// start prebuilding building
			$buildingId= (int)$_GET['buildingId']; /// id of main building, that will be building new building
			$userId= $_SESSION['user_id'];
			$buildingTypeId= (int)$_GET['buildingTypeId'];
			$b= DB::I()->fetchRow("SELECT * FROM buildings WHERE id = $buildingId LIMIT 1");
			if( count($b) <= 0 )
				throw new Excption("Wrong main building ID");
			if( $b['user_id']!=$userId )
				throw new Exception("wrong user ID");
			if( $b['type_id']!=1 )
				throw new Exception("wrong building type ID");

			///@todo make sure that all requirements are fullfilled (if there will be any)

			/// building cost
			$gold= getUserGold($userId,$time);
			$cost= $buildingTypes[$buildingTypeId]['cost'];
			if( $gold < $cost )
				throw new Exception("you dont have enought gold");
			$gold -= $cost;
			DB::I()->exec("UPDATE users SET gold = gold - $cost WHERE id = '$userId' ");

			/// set prebuilding
			$taskId= $buildingTypeId + 100;
			$taskEndTime= $time + $buildingTypes[$buildingTypeId]['build_time'];
			DB::I()->exec("UPDATE buildings SET task_id = '$taskId', task_end_time = '$taskEndTime' WHERE id = '$buildingId' LIMIT 1");

			/// done
			die("ok");
		}
		case 'build':{
			global $buildingTypes;

			/// validate input
			$time= getTime();
			if( $time < $sessionStartTime )
				die("wait");
			if( $sessionEndTime < $time )
				die("to late");
			$mainBuildingId= (int)$_GET['mainBuildingId'];
			$x= floor($_GET['x']);
			$y= floor($_GET['y']);
			$userId= $_SESSION['user_id'];

			/// load main building
			$mb= DB::I()->fetchRow("SELECT * FROM buildings WHERE id = '$mainBuildingId' LIMIT 1");
			if( count($mb)<=0 )
				throw new Exception("wrong main building ID");
			if( $mb['user_id']!=$userId )
				throw new Exception("wrong user ID");
			if( $time < $mb['task_end_time'] )
				throw new Exception("prebuilding is not completed yet");

			/// is place free ?
			if( 0 < DB::I()->getOne("SELECT COUNT(*) FROM buildings WHERE x='$x' AND y='$y'") )
				throw new Exception("There is already some building in there");

			/// insert building
			$buildingTypeId= ($mb['task_id']-100);
			$hp= $buildingTypes[$buildingTypeId]['hp'];
			DB::I()->exec("INSERT INTO buildings(x,y,utime,user_id,type_id,hp) VALUES($x,$y,$time,$userId,$buildingTypeId,$hp)");

			/// free mainbuilding from building it
			DB::I()->exec("UPDATE buildings SET task_id=0 WHERE id = '$mainBuildingId' LIMIT 1");

			die("ok");
		}
		case 'train':{
			global $buildingTypes, $unitTypes;
			$time= getTime();
			if( $time < $sessionStartTime )
				die("wait");
			if( $sessionEndTime < $time )
				die("to late");

			/// validate input
			$buildingId= (int)$_GET['buildingId'];
			$unitTypeId= (int)$_GET['unitTypeId'];
			$userId= $_SESSION['user_id'];

			/// load building
			$b= DB::I()->fetchRow("SELECT * FROM buildings WHERE id = '$buildingId' LIMIT 1");
			if( count($b)<=0 )
				throw new Exception("wrong main building ID");
			if( $b['user_id']!=$userId )
				throw new Exception("wrong user ID");
			if( $time < $b['task_end_time'] )
				throw new Exception("building is busy at the moment");

			/// training cost
			$gold= getUserGold($userId,$time);
			$cost= $unitTypes[$unitTypeId]['cost'];
			if( $gold < $cost )
				throw new Exception("you dont have enought gold");
			$gold -= $cost;
			DB::I()->exec("UPDATE users SET gold = gold - $cost, utime=$time WHERE id = '$userId' ");

			/// set training
			$taskId= 200+$unitTypeId;
			$tet= $time + $unitTypes[$unitTypeId]['build_time'];
			DB::I()->exec("UPDATE buildings SET task_id=$taskId, utime=$time, task_end_time=$tet WHERE id = '$buildingId' LIMIT 1");

			/// done
			die("ok");
		}
		case 'unit-move':{
			$time= getTime();
			if( $time < $sessionStartTime )
				die("wait");
			if( $sessionEndTime < $time )
				die("to late");

			$unitId= (int)$_GET['unitId'];
			$unit= DB::I()->fetchRow("SELECT * FROM units WHERE id = '$unitId' LIMIT 1");
			/// make sure it's your unit
			$userId= $_SESSION['user_id'];
			if( $unit['user_id'] != $userId )
				throw new Exception("it's not your unit");
			$tx= (float)$_GET['x'];
			$ty= (float)$_GET['y'];
			/// update position
			$p= getUnitCurrentPosition($unit, $time);
			DB::I()->exec("UPDATE units SET x=$p[0], y=$p[1], utime=$time, tx=$tx, ty=$ty WHERE id=$unitId ");
			/// done
			die('ok');}
		case 'attack':{
			///@test at all
			$userId= $_SESSION['user_id'];
			$time= getTime();
			if( $time < $sessionStartTime )
				die("wait");
			if( $sessionEndTime < $time )
				die("to late");

			/// input
			$unitId= (int)$_GET['unitId'];
			$targetId= (int)$_GET['targetId'];
			$unit= DB::I()->fetchRow("SELECT * FROM units WHERE id = '$unitId' LIMIT 1");
			$target= DB::I()->fetchRow("SELECT * FROM units WHERE id = '$targetId' LIMIT 1");
			
			/// validate
			if( count($unit) <= 0 || count($target) <= 0 )
				throw new Exception("no such unit");
			if( $unit['user_id'] != $userId )
				throw new Exception("it's not your unit");
			if( $time < $unit['la'] + $unitTypes[$unit['type_id']]['cooldown'] )
				throw new Exception("still in cooldown");

			/// are we close enought
			$p1= getUnitCurrentPosition($unit, $time);
			$p2= getUnitCurrentPosition($target, $time);
			$dis= sqrt( ($p1[0]-$p2[0])*($p1[0]-$p2[0]) + ($p1[1]-$p2[1])*($p1[1]-$p2[1]) );
			if( $unitTypes[$unit['type_id']]['range'] < $dis  )
				throw new Exception("still in cooldown");

			/// update hp
			$attack= $unitTypes[$unit['type_id']]['attack'];
			$target['hp'] -= $attack;
			if( $target['hp'] <= 0 ){
				DB::I()->exec("DELETE FROM units WHERE id=$targetId LIMIT 1");
			}else{
				DB::I()->exec("UPDATE units SET hp=$target[hp], utime=$time, x=$p2[0], y=$p2[1] WHERE id=$targetId LIMIT 1");
			}

			/// done
			die('ok');}
		case 'attack-building':{
			$userId= $_SESSION['user_id'];
			$time= getTime();
			if( $time < $sessionStartTime )
				die("wait");
			if( $sessionEndTime < $time )
				die("to late");
			
			/// input
			$unitId= (int)$_GET['unitId'];
			$targetId= (int)$_GET['targetId'];
			$unit= DB::I()->fetchRow("SELECT * FROM units WHERE id = '$unitId' LIMIT 1");
			$target= DB::I()->fetchRow("SELECT * FROM buildings WHERE id = '$targetId' LIMIT 1");
			
			/// validate
			if( count($unit) <= 0 || count($target) <= 0 )
				throw new Exception("no such unit");
			if( $unit['user_id'] != $userId )
				throw new Exception("it's not your unit");
			if( $time < $unit['la'] + $unitTypes[$unit['type_id']]['cooldown'] )
				throw new Exception("still in cooldown");

			/// are we close enought
			$p1= getUnitCurrentPosition($unit, $time);
			$dis= sqrt( ($p1[0]-$target['x'])*($p1[0]-$target['x']) + ($p1[1]-$target['y'])*($p1[1]-$target['y']) );
			if( $unitTypes[$unit['type_id']]['range'] < $dis  )
				throw new Exception("still in cooldown");

			/// update hp
			$attack= $unitTypes[$unit['type_id']]['attack'];
			$target['hp'] -= $attack;
			///@todo it will be best to upgradeUserData for just this one building
			if( in_array($target['type_id'],[0,4]) )
				upgradeUserData($target['user_id']);
			if( $target['hp'] <= 0 ){
				DB::I()->exec("DELETE FROM buildings WHERE id=$targetId LIMIT 1");
			}else{
				DB::I()->exec("UPDATE buildings SET hp=$target[hp], utime=$time WHERE id=$targetId LIMIT 1");
			}

			/// done
			die('ok');}
		case 'top':{
			/// list of top users

			/// calculate best users
			$users= getTopUsersList();
						
			/// view html
			$view= 'top.php'; 
			require('view/layout.php'); 
			die();
		}
		case 'bigscreen':{
			/// list of top users

			$time= getTime();

			$link= 'http://'.$_SERVER['SERVER_ADDR'].'/rts/';

			/// calculate best users
			$users= getTopUsersList();

			$usersNum= DB::I()->getOne("SELECT COUNT(*) FROM users");

			/// view html
			require('view/bigscreen.php'); 
			die();
		}
		case 'help':{
			/// help window
			echo '<title>Help</title>';
			global $buildingTypes;
			global $unitTypes; 
			// debug($buildingTypes);
			// debug($unitTypes);
			// debugAndDie("");
			$view= 'help.php'; 
			require('view/layout.php'); 
			die();
		}
		case 'migrate':{
			/// migration
			/// roll back everything
			DB::I()->exec("DROP TABLE IF EXISTS users");
			DB::I()->exec("DROP TABLE IF EXISTS buildings");
			DB::I()->exec("DROP TABLE IF EXISTS units");
			/// create new database
			DB::I()->exec("
				CREATE TABLE users (
					`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
					`utime` bigint(20) DEFAULT 0,
					`nickname` varchar(30) NOT NULL DEFAULT 'anonymous',
					`score` int(11) DEFAULT 0,
					`gold` int(11) DEFAULT 1000,
					`color` varchar(3) DEFAULT 'FFF',
					PRIMARY KEY(id)
				) ENGINE=MyISAM
			");
			DB::I()->exec("
				CREATE TABLE buildings (
					`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
					`user_id` int(11) DEFAULT 0,
					`type_id` int(11) DEFAULT 0,
					`utime` bigint(20) DEFAULT 0,
					`x` int(11) DEFAULT 0,
					`y` int(11) DEFAULT 0,
					`task_id` int(11) DEFAULT 0,
					`task_end_time` bigint(20) DEFAULT 0,
					`hp` int(11) DEFAULT 0,
					PRIMARY KEY(id)
				) ENGINE=MyISAM
			");
			DB::I()->exec("
				CREATE TABLE units (
					`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
					`user_id` int(11) DEFAULT 0,
					`type_id` int(11) DEFAULT 0,
					`hp` int(11) DEFAULT 0,
					`utime` bigint(20) DEFAULT 0,
					`la` bigint(20) DEFAULT 0, -- last attack time
					`x` real DEFAULT 0.0,
					`y` real DEFAULT 0.0,
					`tx` real DEFAULT 0.0,
					`ty` real DEFAULT 0.0,
					PRIMARY KEY(id)
				) ENGINE=MyISAM
			");
			echo '<title>migration</title>';
			debugAndDie("migration done");
		}
		case 'map':
			$size= isset($_GET['size']) ? (int)$_GET['size'] : 0x200;
			$img= imagecreatetruecolor($size, $size);
			imagecolorallocate($img, 0, 0, 0);

			$list= DB::I()->fetchAll("
				SELECT b.x, b.y, b.type_id, u.color
				FROM buildings AS b
				INNER JOIN users AS u ON u.id = b.user_id
				-- WHERE b.type_id = 1
			");

			foreach( $list as $v ){
				$x= $size/2+$v['x'];
				$y= $size/2+$v['y'];

				if( 0<=$x && $x<$size && 0<=$y && $y<$size ){
					imagesetpixel($img,$x,$y, 0x110000*strhextoint($v['color'][2]) + 0x1100*strhextoint($v['color'][1]) + 0x11*strhextoint($v['color'][1]) );
				}
			}

			header("Content-type: image/png");
			imagepng($img);
			imagedestroy($img);
			die();
			break;
		case 'phpinfo':
			phpinfo();
			die();
		case 'test':
			// $_SESSION['test']= '123';
			// debug($_SESSION);
			// debug(DB::I()->fetchAll("SHOW TABLES"));
			header("Content-type: image/png");
			$img= imagecreatetruecolor(0x400, 0x400);
			imagecolorallocate($img, 0, 0, 0);

			for( $id=0;$id<300;$id++){
				$rad= sqrt($id) * 0x10;
				$s= 0.2;
				$sx= $rad*sin($rad*$s);
				$sy= $rad*cos($rad*$s);

				imagesetpixel($img,0x200-$sx,0x200-$sy,0xFF0011);
			}

			imagepng($img);
			imagedestroy($img);
			die();
			break;
		default:
			throw new Exception("unknown module $mod");
	}

}

main();

?><!DOCTYPE html>
<html>
	<head>
		<title>Revision</title>
		<link rel="stylesheet" href="app.css" type="text/css" />
		<style>
			#menu .makeoption .progressbar .progress{background-color:#<?=$user['color']?>;}
		</style>
		<script src="jquery.js"></script>
		<script>
			///@todo geneate js file with it
			unitTypes = <?= json_encode($unitTypes) ?>;
			buildingTypes = <?= json_encode($buildingTypes) ?>;
		</script>
		<script>
			/// js + php
			// users= <?= json_encode($users) ?>;
			// units= <?= json_encode($units) ?>;
			// buildings= <?= json_encode($buildings) ?>;
			users= new Array();
			units= new Array();
			buildings= new Array();
			corpses= new Array();
			function initStartingData(){
				var h= <?= json_encode($users) ?>;
				for(var i=0;i<h.length;i++)
					users[h[i].id]= h[i];
				h= <?= json_encode($units) ?>;
				for(var i=0;i<h.length;i++)
					units[h[i].id]= h[i];
				h= <?= json_encode($buildings) ?>;
				for(var i=0;i<h.length;i++)
					buildings[h[i].id]= h[i];
			}
			initStartingData();

			var userId= <?=$userId?>;
			var timeServerDelay = (new Date()).getTime() - <?=getTime()?>;

			var gridSize= 64; /// size of one grid

			var mapX= <?php echo (int)(@$_GET['mapx']); ?> - ($(window).width()-310) / gridSize / 2;
			var mapY= <?php echo (int)(@$_GET['mapy']); ?> - $(window).height() / gridSize / 2;

			sessionStartTime= <?=$sessionStartTime?>;
			sessionEndTime= <?=$sessionEndTime?>;
			
		</script>
		<script src="app.js"></script>
	</head>
	<body onkeypress="onKeyPress(event);" onkeydown="onKeyDown(event);" onkeyup="onKeyUp(event);">
		<div id="map" >
			<div id="mapBackground" onclick="onMapClick(event.clientX,event.clientY);"></div>
			<button style="position:absolute;z-index:1000;top:0px;left:50%;" onclick="mapY-=5;updateMap();">UP</button>
			<button style="position:absolute;z-index:1000;bottom:0px;left:50%;" onclick="mapY+=5;updateMap();">DOWN</button>
			<button style="position:absolute;z-index:1000;top:50%;left:0px;" onclick="mapX-=5;updateMap();">LEFT</button>
			<button style="position:absolute;z-index:1000;top:50%;right:0px;" onclick="mapX+=5;updateMap();">RIGHT</button>
		</div>
		<div id="sidebar">

			<div style="border-bottom:1px solid #888;">
				<!-- <div class="icon" style="background-color:#<?=$user['color']?>;"><a href="?mod=app" title="App">A</a></div> -->
				<div class="icon" style="background-color:#<?=$user['color']?>;"><a href="?mod=top" title="Top Users">T</a></div>
				<div class="icon" style="background-color:#<?=$user['color']?>;"><a href="?mod=map" title="Map">M</a></div>
				<div class="icon" style="background-color:#<?=$user['color']?>;"><a href="?mod=help" title="Help">?</a></div>
				<div class="icon" style="background-color:#<?=$user['color']?>;float:right;"><a href="?mod=login" title="Restart as different user">X</a></div>
				<div style="clear:both;"></div>
			</div>

			<div style="height:100px;"></div>

			<div style="border-bottom: 1px solid #888; border-top: 1px solid #888;">

				<div style="background-color:#<?=$user['color']?>;color:#000;text-align:center;margin:5px;">
					<div style="float:left;" title="bitcoins"><img src="img/bitcoin.png" alt="$" style="margin-top:3px;margin-bottom:-3px;margin-left:2px;" /> <span id="gold"><?=getUserGold($user['id'],getTime())?><!-- <?=$user['gold']?> --></span></div>
					<div style="float:right;" title="C++ modules"><span id="score"><?=getUserScore($user['id'],getTime())?></span> C</div>
					<div class="sessionTime" title="time left">??:??</div>
					<div style="clear:both;"></div>
				</div>

			</div>
			
			<div id="menu">
				<!--
				///@todo delete that debug
				time: <?=time()?><br/>
				microtime: <?=microtime(true)?><br/>
				getTime() = <?=getTime()?> (php)<br/>
				getTime() = <script>document.write(getTime());</script> (js)<br/>
				-->
				Build, Recrut, Kill, Code.<br/>
				Good luck.
			</div>

			<div style="position:absolute;bottom:0px;width:100%;border-top:1px solid #888;">
				<div style="background-color:#<?=$user['color']?>;color:#000;text-align:center;margin:5px;">
					<div style="float:right;">(<?=$_SESSION['user_id']?>) </div>
					<?=$user['nickname']?>
				</div>
			</div>

		</div>

		<?php if( getTime() < $sessionStartTime ){ ?>
			<div id="beforeSessionStartsCountDown">
				<div class="text">
					Session will start in <span id="sessionStartTimeLeft">???</span>
				</div>
			</div>
		<?php } ?>

	</body>
</html>