var bpm = 180;
beatLen = 60/bpm;
scenes = {};    
var masterTimeline;

function min(a, b) {
	return a < b ? a : b;
}

function max(a, b) {
	return a > b ? a : b;
}

function resize() {
	var xscale = window.innerWidth / 1920;
	var yscale = window.innerHeight / 1080;
	var scale = min(xscale, yscale);
	var xofs = Math.floor((window.innerWidth - (1920*scale)) / 2);
	var yofs = Math.floor((window.innerHeight - (1080*scale)) / 2);
	var stageStyle = document.getElementById("stage").style;
	stageStyle.transform = "scale("+scale+")";
	stageStyle.left = xofs+"px";
	stageStyle.top  = yofs+"px";
}

function start() {
	document.getElementById("loader").remove();
	
	initializeCall();
	initializeKitchen();
	initializeWozi();
	initializeIntro();
	
	masterTimeline = new TimelineMax({paused: true});	
	masterTimeline
		.add(introTimeline.play())
		.add(prefaceTimeline.play())
		.add(createCallTimeline("medo", [
			{ thought: true,  time: 2, text: "Guess I better call Mayor MedO and ask what happened." },
			{ enterPhone: true },
			{ spirou: false, time: 3, text: "Hello SunSpirou, what a fine morning it is!<br>How can I be of help?", file: "Medo01" },
			{ spirou: true,  time: 3.5, text: "Did anything weird happen at the party last night? I don't remember a thing.", file: "Medo02" },
			{ spirou: false, time: 2, text: "Hmmm, I don't think I remember anything special.", file: "Medo03" },
			{ spirou: false, time: 3, text: "Count T$ of Champignac and I went into the kitchen pretty early.", file: "Medo04" },
			{ fadeToScene: true, label: "kitchenStart" },
			{ spirou: false, time: 4, text: "We had found a recipe for WonderWaffel and just had to try it out!", file: "Medo05" },			
		]))
		.add([ scenes.kitchen.set({opacity: 1}), kitchenTimeline.play() ], findLabelTime( masterTimeline, "kitchenStart" ) - 0.5 )
		.add(createCallTimeline("kaomau", [
			{ thought: true,  time: 3, text: "Ehh, that didn't help so much.<br>Let's see if pipmau knows what happened." },
			{ enterPhone: true },
			{ spirou: false, time: 2, text: "Hi SunSpirou, you're up early! ^^", file: "Pip01" },
			{ spirou: true,  time: 2, text: "Hey pipmau, can you tell me what happened yesterday?", file: "Pip02" },
			{ spirou: true,  time: 4, text: "It was all nice and cozy, but I woke up with a splitting headache and have no idea why.", file: "Pip03" },
			{ fadeToScene: true, label: "woziSwitch" },
			{ spirou: false, time: 2, text: "Oh yeah, it was all nice and cozy.", file: "Pip04" },
			{ spirou: false, time: 5, text: "Wellll, maybe Gastenius and Captain Neo had a nice spliff together, but that's hardly a surprise ^^", label: "NeoArv", delay: 3, file: "Pip05" },
			{ spirou: false, time: 3.5, text: "And at some point everything started to smell of Waffel, but that's all I know.", delay: 2, file: "Pip06" },
		]), findLabelTime(masterTimeline, "gunpowderPot") + 11 )
		.add([ scenes.wozi.normal.fizzer.set({ y:"+=0", x:"+=40" }), scenes.wozi.set({opacity: 1}), scenes.kitchen.set({opacity: 0}) ], findLabelTime(masterTimeline, "woziSwitch" ) )
		.call(kitchenTimeline.pause, null, kitchenTimeline, findLabelTime(masterTimeline, "woziSwitch" ) )
		.add(chaosTimelines.neoarv.play(), findLabelTime(masterTimeline, "NeoArv") + 1.5 )
		.add(createCallTimeline("rbr", [
			{ thought: true,  time: 2, text: "Huh, well, maybe the RbRsupilami knows more." },
			{ enterPhone: true },
			{ spirou: false, time: 2, text: "Yo SunSpirou, what up?", file: "RbR01" },
			{ spirou: true,  time: 3, text: "Hi Lami! I'm totally blacking out about last night, what the hell?", file: "RbR02" },
			{ spirou: false, time: 2, text: "Dude, you must have gone really wild! xD", file: "RbR03" },
			{ spirou: true,  time: 2.5, text: "Yeah, I've got no idea! Why don't you tell me what happened?", file: "RbR04" },
			{ fadeToScene: true },
			{ spirou: false, time: 2.5, text: "To be honest, I'm mostly drawing a blank too...", file: "RbR05" },
			{ spirou: false, time: 5, text: "...but at one point fiZZotrop got bored and started playing Happy Hardcore on that weird controller.", label: "fizzer", file: "RbR06" },
			{ spirou: false, time: 2, text: "We're kinda sorry for your neighbors.", file: "RbR07" },
			{ spirou: false, time: 1, text: "...not really ^^", delay: 0.5, file: "RbR08" },			
		]), "+=6")
		.add(chaosTimelines.fizzer.play(), findLabelTime(masterTimeline, "fizzer"))
		.add(createCallTimeline("sentcool", [
			{ thought: true,  time: 3.5, text: "Hmm, guess we had a blast! I wonder what Sentasio can tell me." },
			{ enterPhone: true },
			{ spirou: false, time: 3, text: "Hey SunSpirou, what's up?<br>Awesome party yesternight, amiright?", file: "Sent01" },
			{ spirou: true,  time: 3.5, text: "Hi Sentasio! Yeah, seems like it rocked hard, I just don't remember a thing.", file: "Sent02" },
			{ spirou: false, time: 4, text: "Hehheh, it really kicked ass!<br>I remember how pipmau went nuts thanks to nut spirit!", file: "Sent03" },
			{ fadeToScene: true, label: "pipmau" },
			{ spirou: false, time: 3.5, text: "And later, Zantafijoe and I had a nice round of Krawall :)", delay: 5, file: "Sent04" },
		]), "+=8")
		.add(chaosTimelines.kaomau.play(), findLabelTime(masterTimeline, "pipmau") + 2)
		.add(chaosTimelines.sentjoe.play(), "-=4")
		.add(createCallTimeline("arvenius", [
			{ thought: true,  time: 2, text: "So much about cozy. Let's ask Gastenius." },
			{ enterPhone: true },
			{ spirou: true,  time: 4.5, text: "Hi Gastenius, what the hell happened last night? I remember nothing and my head hurts!", file: "Arv01" },
			{ spirou: false, time: 2.5, text: "Oh, hehhehh, join the club ^^<br>I must have had one too many :)", file: "Arv02" },
			{ fadeToScene: true },
			{ spirou: false, time: 3.5, text: "All I remember is the RbRsupilami dangling off the ceiling at one point! xD", label: "supilami", file: "Arv03" },
		]), "+=1.5")
		.add([ scenes.wozi.normal.fizzer.set({ y:"-=0", x:"-=40" }), chaosTimelines.rbr.play() ], findLabelTime(masterTimeline, "supilami"))
		.add(createCallTimeline("ts", [
			{ thought: true,  time: 4, text: "Aww man, that explains the chaos, but not how I got messed up so hard!" },
			{ thought: true,  time: 3, text: "Count T$ of Champignac must know something, he's a scientist!" },
			{ enterPhone: true },
			{ spirou: false, time: 2, text: "Oh, hello, SunSpirou, my boy! What can I do for you?", file: "TS01" },
			{ spirou: true,  time: 5, text: "Count T$, you have to help me! I don't remember anything about last night! What happened to me?", file: "TS02" },
			{ fadeToScene: true, label: "woziFlashback" },
			{ spirou: false, time: 3.5, text: "Oh boy, you don't remember? You must have hit your head really hard.", file: "TS03" },
			{ spirou: true,  time: 1, text: "I hit my WHAT?", file: "TS04" },
			{ spirou: false, time: 3, text: "When we arrived, you performed a leap of joy<br>...against your cupboard.", label: "autschn", file: "TS05" },
			{ spirou: false, time: 2, delay: 5, text: "It seems you took quite a long time to recover.", label: "end", file: "TS06" },
		]), "+=3")
		.add(chaosTimelines.flashback.play(), findLabelTime(masterTimeline, "woziFlashback"))
		.add(chaosTimelines.spireouch.play(), findLabelTime(masterTimeline, "autschn"))
		.add(chaosTimelines.end.play(), findLabelTime(masterTimeline, "end") + 3)
		.add([ scenes.wozi.to(2, { opacity: 0 }), TweenMax.to(scenes.kitchen.sound, 3, { volume: 0 }), scenes.ending.to(3, { opacity: 0 }) ], "+=16")

		.call(unfullscreen, null, null, "+=5")
	;

	resize();
	document.getElementById("stage").style.visibility = '';
	masterTimeline.play();
	
	if (window.location.search) {
		searchVal = window.location.search.substring(1);
		if (!isNaN(searchVal))
			masterTimeline.time(searchVal);
	}
}

function key(event) {
	if (event.key == ' ')
		masterTimeline.paused(!masterTimeline.paused());
}

function fullscreen() {
	var body = document.body;
	var func = body.requestFullscreen || body.msRequestFullscreen || body.mozRequestFullScreen || body.webkitRequestFullscreen;
	if (func)
		func.call(body);
}

function unfullscreen() {
	var func = document.cancelFullScreen || document.mozCancelFullScreen || document.webkitCancelFullScreen;
	if (func)
		func.call(document);
}

function main() {
	window.onkeydown = key;
	loadScenes(scenes, [ "kitchen", "wozi", "call", "preface", "intro", "ending" ], function(success) {
		if (success && window.location.search) {
			start();
		} else {
			document.getElementById("loading").innerHTML = "done loading." + (success ? "" : " (with errors, proceed at your own risk)");
			document.getElementById("start").style.visibility = "";
		}
	});	
}
