#version 330

out vec3 color;

uniform ivec2 uViewportSize;

uniform float uTime;

uniform sampler1D uPalette;

uniform sampler2D uScroller;

vec3 hsv2rgb(vec3 c) {
  vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
  vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
  return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec3 rgb2xyz( vec3 c ) {
    vec3 tmp;
    tmp.x = ( c.r > 0.04045 ) ? pow( ( c.r + 0.055 ) / 1.055, 2.4 ) : c.r / 12.92;
    tmp.y = ( c.g > 0.04045 ) ? pow( ( c.g + 0.055 ) / 1.055, 2.4 ) : c.g / 12.92,
    tmp.z = ( c.b > 0.04045 ) ? pow( ( c.b + 0.055 ) / 1.055, 2.4 ) : c.b / 12.92;
    const mat3 mat = mat3(
		0.4124, 0.3576, 0.1805,
        0.2126, 0.7152, 0.0722,
        0.0193, 0.1192, 0.9505
	);
    return 100.0 * mat * tmp;
}

vec3 xyz2lab( vec3 c ) {
    vec3 n = c / vec3(95.047, 100, 108.883);
    vec3 v;
    v.x = ( n.x > 0.008856 ) ? pow( n.x, 1.0 / 3.0 ) : ( 7.787 * n.x ) + ( 16.0 / 116.0 );
    v.y = ( n.y > 0.008856 ) ? pow( n.y, 1.0 / 3.0 ) : ( 7.787 * n.y ) + ( 16.0 / 116.0 );
    v.z = ( n.z > 0.008856 ) ? pow( n.z, 1.0 / 3.0 ) : ( 7.787 * n.z ) + ( 16.0 / 116.0 );
    return vec3(( 116.0 * v.y ) - 16.0, 500.0 * ( v.x - v.y ), 200.0 * ( v.y - v.z ));
}

vec3 rgb2lab( vec3 c ) {
    vec3 lab = xyz2lab( rgb2xyz( c ) );
    return vec3( lab.x / 100.0, 0.5 + 0.5 * ( lab.y / 127.0 ), 0.5 + 0.5 * ( lab.z / 127.0 ));
}

vec3 palettize(vec3 cref)
{
	vec3 reflab = rgb2lab(cref);

	vec3 result = texelFetch(uPalette, 0, 0).rgb;
	// int len = textureSize(uPalette, 0);
	for(int i = 1; i < 34; i++)
	{
		vec3 cpal = texelFetch(uPalette, i, 0).rgb;

		if(distance(reflab, rgb2lab(cpal)) < distance(reflab, rgb2lab(result.rgb)))
			result = cpal;
	}
	return result;
}

void main()
{
	vec2 uv = gl_FragCoord.xy / vec2(uViewportSize);
	uv *= 2.0;
	uv -= 1.0;
	uv.x *= float(uViewportSize.x) / float(uViewportSize.y);

	float i = sin(uv.x + uTime)
		+ 0.4 * sin(1.3 * uv.y + 0.3 * uTime)
		+ sin(uv.y + uTime + 2)
		+ 1.2 * sin(0.3 * uv.y + 0.7 * uTime)
		;

	vec3 c = hsv2rgb(vec3(i, 1.0, 1.0));

	color = palettize(c);
}
