ifeq ($(USE_DIRTY),)
POSTSTUB := src/stub/post-clean
else
POSTSTUB := src/stub/post-dirty
endif

ifeq ($(ZIP),cat)
ZFLAGS ?=
ZCAT   ?=
NOSTUB := 1
else
ifeq ($(ZIP),gz)
ZCAT   ?= zcat
ifeq ($(USE_7Z),)
ZPRG   ?= gzip
ZFLAGS ?= -cnk9
else
ZPRG   ?= 7z
ZFLAGS ?= a -tgzip -si -so -y -mx=9
endif
else
ifeq ($(ZIP),xz)
ZCAT   ?= xzcat
ifeq ($(USE_7Z),)
ZFLAGS ?= -T 0 -9 --extreme --keep --stdout --x86 --lzma2=preset=9,lc=1,lp=0,pb=0
else
ZPRG   ?= 7z
ZFLAGS ?= a -txz -si -so -y -mx=9 -mf=BCJ -mt=on # -m0=LZMA2:lc=1:lp=0:pb=0
endif
else
ifeq ($(ZIP),bz2)
ZCAT   ?= bzcat
ifeq ($(USE_7Z),)
ZPRG   ?= bzip2
ZFLAGS ?= -czk9
else
ZPRG   ?= 7z
ZFLAGS ?= a -tbzip2 -si -so -y -mx=9 -mt=on
endif
else
ifeq ($(ZIP),lzma)
ZCAT   ?= xzcat
ZFLAGS ?= --format=lzma --lzma1=preset=0,lc=1,lp=0,pb=0 --keep --stdout
else
ifeq ($(ZIP),zopfli)
ZCAT   ?= zcat
ZFLAGS ?= --gzip -c -v --i1024
else
ifeq ($(ZIP),lzip)
ZCAT   ?= lzip -dc
ZFLAGS ?= -c9 # -s dict-size -m max-match-len
else
ifeq ($(ZIP),)
$(error "Custom zip, please provide ZPRG, ZFLAGS and ZCAT.")
endif # custom
endif # lzip
endif # zopfli
endif # lzma
endif # bzip2
endif # xz
endif # gz
endif # cat

ZCAT ?= $(ZIP)cat
ZPRG ?= $(ZIP)

