#!/usr/bin/env bash

set -e

rm -rvf pcy-k2-ltnv.tar.gz ar/
mkdir -p ar/src

for backend in "espeak" "speechd"; do
    ARGS="NAME=prod-$backend"

    if [[ "$backend" = "speechd" ]]; then
        ARGS="$ARGS ADEFS=-DUSE_SPD_SAY"
    fi

    make clean && make $ARGS $EXTRAMAKEFLAGS && \
        cp -v "bin/prod-$backend" ar/
done

cp -v README ar/file_id.diz

# simplest way not to include crap
git archive -v --format=tar HEAD > ar/src.tar
cd ar/src && bsdtar -xf ../src.tar && cd ../..

rm -vf ar/src.tar

cd ar && bsdtar -cvzf ../pcy-k2-ltnv.tar.gz . && cd ..

