const WaveFile = require("wavefile");
const fs = require("fs");

let wav = new WaveFile();

const MIN_FREQ = 10;
const MAX_FREQ = 44100;
const SAMPLE_RATE = 44100;

const randomFreq = () => MIN_FREQ + Math.random() * (MAX_FREQ - MIN_FREQ);

const sinOsc = (f, t) => Math.sin(f * t * Math.PI * 2);
const sqrOsc = (f, t) => (Math.sin(f * t * Math.PI * 2) < 0 ? -1 : 1);
const noise = () => Math.random() * 2 - 1;

const limiter = n => Math.min(Math.max(-1, n), 1);

const randomOsc = () => {
  const x = Math.random() < 0.5;
  if (x < 0.33) {
    return sinOsc;
  }
  if (x < 0.66) {
    return sqrOsc;
  }
  return noise;
};

const randomSlope = (maxLength) => {
  const freq1 = randomFreq() / Math.pow(2, Math.round(Math.random() * 4));
  const freq2 = Math.random() < 0.5 ? freq1 * Math.random() : freq1;
  const length = Math.round(Math.max(100, 100 + Math.random() * maxLength));
  const osc = randomOsc();
  return Array(length)
    .fill(0)
    .map((x, i) => {
      const f = freq1 + (freq2 - freq1) * (i / length);
      const t = i / SAMPLE_RATE;
      return (osc(f, t) * (length - i)) / length;
    });
};

const randomSilence = (maxLength) => {
  const length = Math.round(Math.max(100, 100 + Math.random() * maxLength));
  return Array(length).fill(0);
};

const randomSong = () => {
  let samples = [];
  for (let i = 0; i < 100; i++) {
    let innerSample = [];
    const a = 2 + Math.floor(Math.random() * 4);
    const b = 2 + Math.floor(Math.random() * 4);

    for (let j = 0; j < a; j++) {
      innerSample = innerSample.concat(randomSlope(5000 - i * 50));
      innerSample = innerSample.concat(randomSilence(15000 - i * 500));
    }

    const length = b * innerSample.length;

    const leadFreq = Math.random() * 600 + 20;
    const vibra = 0.005 * Math.random()
    const lead = Array(length)
      .fill(0)
      .map((x, i) => {
        const it = (length - i) / length
        const f = leadFreq + leadFreq * 0.005 * Math.sin(it * 100) * it;
        return sinOsc(f, i / SAMPLE_RATE);
      });

    const bassFreq = leadFreq / 4;
    const bassLFOFreq = Math.random() * 10;
    const bassline = Array(length)
      .fill(0)
      .map(
        (x, i) =>
          sqrOsc(bassFreq, i / SAMPLE_RATE) *
          Math.max(0, sqrOsc(bassLFOFreq, i / SAMPLE_RATE))
      );

    let foobosaea = [];
    for (let j = 0; j < b; j++) {
      foobosaea = foobosaea.concat(innerSample);
    }

    foobosaea = foobosaea.map((s, i) => limiter(s + lead[i] + bassline[i] * 0.5));
    samples = samples.concat(foobosaea);
  }
  return samples;
};

// Create a mono wave file, 44.1 kHz, 32-bit and 4 samples
wav.fromScratch(1, SAMPLE_RATE, "32f", randomSong());
fs.writeFileSync("highend.wav", wav.toBuffer());
