import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import damkjer.ocd.*; 
import moonlander.library.*; 
import java.util.logging.*; 
import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class deeplyfishy extends PApplet {



//import queasycam.*;




// Minim is needed for the music playback
// (even when using Moonlander)


float TURN = PI*2;

// These control how big the opened window is.
// Before you release your demo, set these to 
// full HD resolution (1920x1080).
int CANVAS_WIDTH = 1920; //480;
int CANVAS_HEIGHT = 1080; // 360;

int fps = 60;

// For syncing with music etc
Moonlander moonlander;

// Ocean shaders
PShader ocean;
PShader oceanLight;

// Camera
//QueasyCam cam;
Camera camera;

float worblePos = 0f;

Ruins ruins;
Terrain terrain;
Scroller scroller;

PVector camPos = new PVector();
PVector focusPos = new PVector();

public float sinNoise(float t, float x) {
  return 0.5f*sin(t * x) + 0.5f*cos(t * 0.31232f * x) + 0.5f*sin( (t * 0.123f + cos(t * 0.001351f)) * 0.871f * x);
}

public float shakyNoise(float time, float freq, float bass, float discant, float seed) {
  return (noise(time * 0.2f*freq, seed * 123.321f) * 2 - 1) * bass +
         (noise(time * 1*freq, seed * 887.213f) * 2 - 1) * discant; 
}

public void calcTargetPos(PVector pos, float time, float speed, float mag, float yScale, float yDelta) {
  pos.x = sinNoise(time + 782.213f, speed) * mag;
  pos.y = sinNoise(time + 3712.321f, speed * yScale) * mag + yDelta;
  pos.z = sinNoise(time + 12.876f, speed) * mag;
}

/*
 * settings() must be used when calling size with variable height and width
 */
public void settings() {
  // Set up the drawing area size and renderer (P2D / P3D).
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P3D);
  fullScreen(P3D);
  randomSeed(8719);
  noiseSeed(2131);

}

/*
 * Processing's setup method.
 *
 * Do all your one-time setup routines in here.
 */
public void setup() {
  
  noCursor();
  
  rectMode(CENTER);
  
  translate(width /2, height/2);
  scale(height / 1000.0f);
  
  // Setup camera
  camera = new Camera(this, -20, 0, 0);
  camera.aim(0,0,0);
  camera.feed();
//  camera(0, 10, -80, 0,0,0, 0,1,0);
/*  
  cam = new QueasyCam(this);
  cam.controllable = false;
  cam.speed = 1.1f;
  cam.sensitivity = 1f;
  cam.friction = 0.3f;
  cam.position.set(-20, 0, 0);
  cam.position.x = -5;
  cam.position.y = 0;
  cam.position.z = 0;
*/

  setupfishes();
  
  frameRate(fps);

  // Load shader
  ocean = loadShader("ocean_frag.glsl", "ocean_vert.glsl");
  ocean.set("fade", 1.0f);
  oceanLight = loadShader("ocean_light_frag.glsl", "ocean_light_vert.glsl");
  oceanLight.set("fade", 1.0f);
  

  // Parameters: 
  // - PApplet
  // - soundtrack filename (relative to sketch's folder)
  // - beats per minute in the song
  // - how many rows in Rocket correspond to one beat
  moonlander = Moonlander.initWithSoundtrack(this, "Final Battle of the Dark Wizards.mp3", 112, 8);
//  moonlander.changeLogLevel(Level.FINEST);

  // Last thing in setup; start Moonlander. This either
  // connects to Rocket (development mode) or loads data 
  // from 'syncdata.rocket' (player mode).
  // Also, in player mode the music playback starts immediately.
  //moonlander.start("localhost", 9001, "syncfile");
  moonlander.start();
  
  terrain = new Terrain(100, 100);
  terrain.init();


  ruins = new Ruins();
  ruins.init(terrain);
  
  scroller = new Scroller();
  
}

/*
 * Processing's drawing method
 */
public void draw() {
  background(0);
  fill(255);
  resetShader();

  // Handles communication with Rocket
  moonlander.update();

  int stopNow = moonlander.getIntValue("stopNow");
  if (stopNow >= 1) {
    exit();
  }


  // Seconds since start
  float time = (float) moonlander.getCurrentTime();
  //float time = millis() / 1000.0;
  float deltaTime = 1f / fps; 

  // Render credits etc
  scroller.render(time, deltaTime);

  // Fading
  float fade = (float) moonlander.getValue("fade");
  ocean.set("fade", fade);
  oceanLight.set("fade", fade);

  // Update fish speed
  float predatorSpeed = (float) moonlander.getValue("predatorSpeed");
  bigScool1.scoolSpeedMod = predatorSpeed;
  bigScool2.scoolSpeedMod = predatorSpeed;
  float mediumSpeed = (float) moonlander.getValue("mediumFishSpeed");
  averageScool.scoolSpeedMod = mediumSpeed;

  // Update fish targets
  float fishTargetSpeed = 0.05f;
  float fishTargetDist = 5;
  calcTargetPos(smallScool.target, time+31.32f, fishTargetSpeed, fishTargetDist*0.8f, 0.5f, 2); 
  calcTargetPos(averageScool.target, time + 9823.3f, fishTargetSpeed*0.7f, fishTargetDist*1.1f, 0.6f, -1); 
  calcTargetPos(averageScool2.target, time + 732.3f, fishTargetSpeed*1.2f, fishTargetDist*0.8f, 0.6f, 0.5f); 
  smallScool2.target.set(20,-3, 10);
  averageScool3.target.set(-20,-10, 30);
  bigScool3.target.set(5, -16, -40);

  // Position camera
  int cameraMode = moonlander.getIntValue("cameraMode");
  float baseCamMoveSpeed = (float) moonlander.getValue("camMoveSpeed");
  float baseCamMoveDist = (float) moonlander.getValue("camMoveDist");
  float targetY = (float) moonlander.getValue("targetY");
  float cameraY = (float) moonlander.getValue("camY");
  if (cameraMode == 1 && bigScool1.fishes.size() > 0) {
    // Chase fish
    Fish fish = bigScool1.fishes.get(0);
    float blend = 0.5f;
    //focusPos.set(bigScool1.scoolCenter);
    focusPos.set(fish.position);
    camPos.lerp(camPos,focusPos,baseCamMoveDist);
  }
  else if (cameraMode == 2) {
    // Slow rotate
    float camMoveSpeed = 0.01f * baseCamMoveSpeed;
    float camMoveDist = 20 * baseCamMoveDist;
    focusPos.set(0,targetY, 0);
    camPos.set(-cos(time*camMoveSpeed*TURN) * camMoveDist, 0, sin(time*camMoveSpeed*TURN) * camMoveDist);
  }
  else if (cameraMode == 3) {
    // Credit cam
    float camMoveSpeed = 0.03f * baseCamMoveSpeed;
    float camMoveDist = 20 * baseCamMoveDist;
    focusPos.set(0,targetY, 0);
    camPos.set(-cos(time*camMoveSpeed*TURN) * camMoveDist, 3, sin(time*camMoveSpeed*TURN) * camMoveDist*0.4f+camMoveDist*0.8f);
  }
  else {
    float camMoveSpeed = 0.1f * baseCamMoveSpeed;
    float camMoveSpeedY = camMoveSpeed * 0.2f;
    float camMoveDist = 50 * baseCamMoveDist;
  
    float focusPosSpeed = 0.89f * baseCamMoveSpeed;
    float focusPosDist = 20 * baseCamMoveDist;
  
    calcTargetPos(camPos, time, camMoveSpeed, camMoveDist, 0.2f, 0);
    calcTargetPos(focusPos, time + 3125.342f, focusPosSpeed, focusPosDist, 0.5f, targetY);
  }
  
  camera.jump(camPos.x, camPos.y + cameraY, camPos.z);
  camera.aim(focusPos.x, focusPos.y, focusPos.z);
  camera.feed();

  // Get values from Rocket using 
  // moonlander.getValue("track_name") or
  // moonlander.getIntValue("track_name")
  
  
  // Debug lines
  noStroke();
 // stroke(0,255, 0);
   

  //lights();

  // Ocean background
  shader(ocean);
  //fill(200, 50, 50);
  pushMatrix();
  // Center background on camera
  translate(camPos.x, camPos.y, camPos.z);
  sphere(160);
  popMatrix();

  // Sunlight
  float sunWorbleAmount = (float) moonlander.getValue("sunWorbleAmount");
  float sunWorbleSpeed = (float) moonlander.getValue("sunWorbleSpeed");
  worblePos += deltaTime*sunWorbleSpeed;
  directionalLight(255, 255, 255, sin(worblePos)*sunWorbleAmount, 10, cos(worblePos)*sunWorbleAmount);
  
  // Things in ocean
  shader(oceanLight);

  // Terrain
  terrain.render();

  // Ruins 
  ruins.render(time, deltaTime);

  // Fish
  fill(100, 200, 255);
  drawfishes(deltaTime);
  noStroke();

  // DEBUG: Red blob at origo
  // fill(255, 100, 100);
  // sphere(1);

}
Scool smallScool;
Scool smallScool2;
Scool averageScool;
Scool averageScool2;
Scool averageScool3;
Scool bigScool1;
Scool bigScool2;
Scool bigScool3;
 
public void setupfishes() {
  smallScool = new Scool(200, new PVector(0, 0, 0), 2.5f, 0.1f, 0.3f, 0.8f, 50, 175, 235, 50, 200, 200);
  smallScool2 = new Scool(50, new PVector(22, -5,22), 2.5f, 0.2f, 0.5f, 0.8f, 160, 111, 55, 200, 60, 200);
  averageScool = new Scool(100, new PVector(-22.5f, -17.5f, 117.5f), 2.5f, 0.25f, 1, 1, 60, 125, 235, 50, 200, 50);
  averageScool2 = new Scool(100, new PVector(4, -4, 1), 3.5f, 1, 2, 1, 70, 125, 50, 200, 50, 50);
  averageScool3 = new Scool(40, new PVector(4, -4, 1), 3.5f, 2, 3, 1, 100, 55, 200, 200, 150, 50);
  bigScool1 = new Scool(1, new PVector(-100.5f, -17.5f, 122.5f), 10, 15, 20, 1.5f, 50, 235, 160, 200, 50, 50);
  bigScool2 = new Scool(2, new PVector(-102.5f, -17.5f, -100.5f), 10, 2, 5, 1.5f, 50, 235, 100, 200, 50, 50);
  bigScool3 = new Scool(5, new PVector(302.5f, -17.5f, 300.5f), 10, 12, 25, 1.5f, 100, 125, 130, 80, 90, 110);
  smallScool.predators.add(bigScool1);
  averageScool.predators.add(bigScool2);
  bigScool1.prey = smallScool;
  bigScool1.prey = averageScool;
  noStroke();
}
 
public void drawfishes(float deltaTime) {
  smallScool.drawScool(deltaTime);
  averageScool.drawScool(deltaTime);
  bigScool1.drawScool(deltaTime);
  bigScool2.drawScool(deltaTime);
}

class Scool {
  ArrayList<Fish> fishes = new ArrayList<Fish>();
  int scoolsize;
  PVector target=  new PVector(0,-2,0);
  ArrayList<PVector> avoidThese = new ArrayList<PVector>(); 
  ArrayList<Scool>  predators = new ArrayList<Scool>(); 
  Scool prey;
  PVector scoolCenter;
  float scoolSpeedMod = 1;

  
  Scool(int amount,PVector averageStartPosition, float positionSpread, float minsize, float maxSize, float speedModifier, 
  float fishred, float fishgreen, float fishblue, float tailred, float tailgree, float tailblue){
    scoolsize = amount;
    for (int i = 0; i < amount; i++) {
      fishes.add(new Fish(averageStartPosition, positionSpread,  minsize,  maxSize, speedModifier,fishred, fishgreen, fishblue, tailred,  tailgree,  tailblue));
        
    }
    scoolCenter = averageStartPosition;
    
    


    
  }
  
  
  
  public void drawScool(float deltaTime){
    if (prey != null){
      target = prey.scoolCenter;
    }
    int num = 0;
    scoolCenter.set(0,0,0);
    for (Fish f : fishes){     
         scoolCenter.add(f.position);
         num ++;
         
      
    }  
    if (num != 0){
    scoolCenter.div(num);
    }
    for (Fish f : fishes) {
      f.render(deltaTime);
    //  //println("rendering fish");
      
      f.step(fishes, deltaTime, target, avoidThese, 3, predators, scoolCenter.copy(), scoolSpeedMod);
      
    } 

 
    
  }
}  



 
class Fish {
  PVector position = new PVector(random(10, 15), random(-20, -15), random(-10, -5));
  PVector velocition = new PVector(random(-0.5f, 0.5f), random(-0.5f, 0.5f), random(-0.5f, 0.5f));
  float maxVelocity = random(4, 8);
  
  float maxVelocityChange = random(0.01f, 0.05f);

  float searchDist = random(7, 10);
    float size = random(0.05f, 0.2f);
      float minVelosity = random(0.02f*size, 0.2f*size);
  float contentDist = random(0.5f*size, 2*size); 

  float crowdedDist = random(size*0.1f, size*2);
  
  float tailPos = random(0, 1);
  float tailSpeed = random(25, 40);
  float maxMouthUp = random(0.1f, 1);
  float moutPos = random(0, 1);
  float moutSpeed = random(5, 10);
  int fishColor = color(random(0, 175), random(100, 255), 255);
  int finColor = color(random(0, 100), random(200, 255), random(100, 255));
  float minDistToBottom = 1;
  //0 = calm , 5= terrified,
  int terror = 0;
  // 0 = not lonly, 1 = lonly;
  int lonly = 0;
  Fish(PVector averageStartPosition, float positionSpread, float minsize, float maxSize, float speedModifier,
  float fishred, float fishgreen, float fishblue, float tailred, float tailgreen, float tailblue){
        position = new PVector(random(averageStartPosition.x-positionSpread, averageStartPosition.x+positionSpread), random(averageStartPosition.y-positionSpread, averageStartPosition.y+positionSpread), random(averageStartPosition.z-positionSpread, averageStartPosition.z+positionSpread));
        size = random(minsize, maxSize);
        maxVelocity = random(4*speedModifier, 8*speedModifier);

        fishColor = color(random(fishred-50, fishred+50), random(fishgreen-50, fishgreen+50), random(fishblue-20, fishblue+20));
        finColor = color(random(tailred-50, tailred+50), random(tailgreen-50, tailgreen+50), random(tailblue-50, tailblue+50));
        
  }  
 

 
  public void step(ArrayList<Fish> fishes, float deltaTime, PVector target, ArrayList<PVector> avoidThese, float avoidDist, ArrayList<Scool> predators, PVector scoolCenter, float scoolSpeedMod) {
    PVector center = new PVector();
    PVector avoid = new PVector();
    PVector toward = new PVector();
    PVector match = new PVector();
    PVector avoidObj = new PVector();
    PVector velocityChange = new PVector();
    
    float relativeMaxYVelocity = 0.5f;

    center = findMass(this, fishes, searchDist, contentDist);
    
    avoid = avoidFriends(this, fishes);
    toward = tovardPosition(this,target).mult(100);
    match = matchSpeed(this,fishes);
    avoidObj = avoidObjects(avoidThese,this,avoidDist).mult(100000);
    velocityChange.add(center).add(avoid).add(toward).add(match).add(avoidObj);
    velocityChange.mult(deltaTime);
    
    // Reduce y velocity change, slower for fishes
    velocityChange.y = velocityChange.y * relativeMaxYVelocity;    
    if (velocityChange.mag() > maxVelocityChange){
      velocityChange.normalize().mult(maxVelocityChange);  
    }
    //do normal swimming if not terrified
    if (terror <= 2/deltaTime){
      velocition.add(velocityChange);
    }
    // check loneliness

    
    //check for predators
    float distToPredator = 0;
    if (predators != null){
    for (Scool predatorScool : predators){  
    for (Fish predator : predatorScool.fishes){
         distToPredator = predator.position.dist(position);
         if (distToPredator < 2){
           terror = 4 * (int)(1 / deltaTime);
           
           PVector direction = position.copy().sub(predator.position).normalize();
           velocition = direction.mult(maxVelocity*2);
           
         }
    }
    }
    }
    //to not collide in bottom
    float bottomY = -terrain.roughHeightAt(position.x,position.y);
    float bottomDist = abs(position.y-bottomY);
    if (velocition.y < 0 && bottomDist < minDistToBottom){
      velocition.y += maxVelocityChange*0.2f;
    } 
    if (bottomDist < -0.2f){
      velocition.y = 0.1f;
    }  
    // Clamp y velocity
    if (abs(velocition.y) > maxVelocity * relativeMaxYVelocity *(terror*deltaTime+1)) {
      float sign = 1;
      if (velocition.y < 0) sign = -1;
      velocition.y = sign * maxVelocity * relativeMaxYVelocity *(terror*deltaTime+1);
    }
    //if terrified
    if (terror >= 1/deltaTime){
      if (velocition.mag() > maxVelocity*terror*deltaTime){
         velocition.normalize().mult(maxVelocity); 
      }
      else if (velocition.mag() < minVelosity*terror*deltaTime){
        velocition.normalize().mult(minVelosity);
       
      }
    terror --;  
  }  
    else{
      if (velocition.mag() > maxVelocity){
         velocition.normalize().mult(maxVelocity); 
      }
      else if (velocition.mag() < minVelosity){
        velocition.normalize().mult(minVelosity);      
    }
    }
    
    
    
    PVector temp = velocition.copy().mult(deltaTime).mult(scoolSpeedMod);
     position.add(temp);
      
     
 

  }
  
  
  public PVector findMass(Fish thisFish, ArrayList<Fish> fishes, float searchDist, float contentDist){
    PVector centerOfMass = new PVector();
    int num = 0;
    for (Fish f : fishes){
      float dist = f.position.dist(thisFish.position);
      if (f != thisFish &&  dist < searchDist){
         centerOfMass.add(f.position);
         num ++;
      }
    }  
    if (num != 0){
      centerOfMass.div(num);
      centerOfMass.sub(thisFish.position);
      float dist = thisFish.position.dist(centerOfMass);
      float distFromContent = dist-contentDist;
      if (distFromContent < 0){
        distFromContent = 0;
      }  
      float magnitude = distFromContent/(searchDist-contentDist);
      centerOfMass.normalize().mult(magnitude);
    }
    
     
    return centerOfMass;
  }  


  public PVector avoidFriends(Fish thisFish, ArrayList<Fish> fishes){
    PVector avoidance = new PVector();
    float avoidDist = 1f;
    int num = 0;
    PVector temp = new PVector();
    for (Fish f : fishes){
      float dist = f.position.dist(thisFish.position); 
      if (f != thisFish && dist < avoidDist) {
        num ++;
        temp = f.position.copy().sub(thisFish.position).div(avoidDist);
        float magn = avoidDist - temp.mag();
        temp.normalize().mult(magn);
        avoidance.sub(temp);
      }

    }
    if (num > 0){
        avoidance.div(num);
     }  
   //println(avoidance.mag());
    return avoidance;
  }  
  
  public PVector tovardPosition(Fish thisFish, PVector pos){
    PVector towardPos = new PVector();
    towardPos.add(pos).sub(thisFish.position).div(100);
    return towardPos;
  }
  
  
  public PVector matchSpeed(Fish thisFish, ArrayList<Fish> fishes){
    PVector avgSpeed = new PVector();
    int num = 0;
    for (Fish f : fishes){
      float dist = f.position.dist(thisFish.position);
      if (f != thisFish &&  dist < 3){
         avgSpeed.add(f.position);
         num ++;
      }
    } 
    if (num > 0){
      avgSpeed.div(num);
      
    }  
    return avgSpeed.mult(0.005f);
  } 
  
  public PVector avoidObjects(ArrayList<PVector> objects, Fish thisFish, float distToAvoid){
    PVector avoidDirection = new PVector();
    PVector distToObjectVec = new PVector();
    for (PVector object : objects){
         distToObjectVec = object.copy().sub(thisFish.position);
         float dot = distToObjectVec.dot(thisFish.velocition);
         if (distToObjectVec.mag() < distToAvoid*2 && dot > 0){
             PVector distChange = distToObjectVec.copy().normalize().mult(-dot);
             avoidDirection.sub(distChange).normalize();
             float avoidSpeed = ((distToAvoid*2) - distToObjectVec.mag())/distToAvoid*2;
             avoidDirection.mult(-avoidSpeed);
             //println(avoidDirection.mag());
         }
    }
    return avoidDirection;
  }
    public void render(float deltaTime) {
    tailPos += deltaTime;
    moutPos += deltaTime;
    
    
    pushMatrix();
    
    //rotate(velocition);
    translate(position.x, position.y, position.z);
    scale(size/5.5f);

    // Determine xz direction
    float x = velocition.x;
    float z = velocition.z;
    // Rotate around y
    float angle = atan2(-z, x);
    rotateY(angle);
    
    //rotateY(radians(90));
    rotateX(radians(180));
    translate(0, 0.4f, 0);
    fill(220, 190, 100);
    sphereDetail(10);
    sphere(0.3f);
    translate(0.05f, 0.1f, 0.2f);
    fill(0,0,0);
    sphere(0.1f);
    translate(0, 0, -0.4f);
    sphere(0.1f);
    translate(-0.05f, -0.5f, 0.2f);
    beginShape(TRIANGLE); 
    fill(fishColor);

    
    //tail
    fill(finColor);    
    float tailz = sin(tailPos*tailSpeed)*(0.5f);
    vertex(-3, 0,0);
    vertex(-4.5f, 1, tailz);
    vertex(-4, 0, tailz);
    
    vertex(-3, 0,0);
    vertex(-4.5f, -1, tailz);
    vertex(-4, 0, tailz);
    
    //headfin
    vertex(0,1,0);
    vertex(-0.5f, 1.5f, -tailz*0.3f);
    vertex(-1,1, 0);
    
    vertex(-1,1, 0);
    vertex(-0.5f, 1.5f, -tailz*0.3f);
    vertex(-1.5f, 1.5f, -tailz*0.3f);
    
    //sidefin
    float sidez = (sin(tailPos*tailSpeed)+1.5f)/2.5f;
    vertex(0,0,0.5f);
    vertex(-1, -1, sidez);
    vertex(-1, -0.5f, sidez);
    
    vertex(0,0,-0.5f);
    vertex(-1, -1, -sidez);
    vertex(-1, -0.5f, -sidez);
    
    
    
    //head
    //shape.stroke(0,0,255);
    float mouty = ((sin(moutPos*moutSpeed)-1)*0.5f)*(maxMouthUp);
    fill(fishColor);
    normal(0, 0, -1);
    vertex(0,0,-0.5f);
    normal(0, -1, 0);
    vertex(0,-1,0);
    normal(1, 0, 0);
    vertex(1, mouty,0);
    
    normal(0, 0, -1);
    vertex(0,0,-0.5f);
    normal(1, 0, 0);
    vertex(1, -0.5f*mouty,0);
    normal(0, 1, 0);
    vertex(0, 1,0);
     
    normal(1, 0, 0);
    vertex(1, -0.5f*mouty,0);
    normal(0, 1, 0);
    vertex(0, 1,0);
    normal(0, 0, 1);
    vertex(0,0,0.5f);
    
    normal(1, 0, 0);
    vertex(1, mouty,0);
    normal(0, 0, 1);
    vertex(0,0,0.5f);
    normal(0, -1, 0);
    vertex(0,-1,0);
    
    //moutIn
    //down
    fill(160, 30, 30);
    normal(0, 1, 0);
    vertex(1, mouty, 0);
    vertex(0, 0, 0.5f);
    fill(0,0,0);
    vertex(0, 0, 0);
    fill(160, 30, 30);
    
    vertex(1, mouty, 0);
    vertex(0, 0, -0.5f);
    fill(0,0,0);
    vertex(0, 0, 0);
    
    //up
    fill(160, 30, 30);
    normal(0, -1, 0);
    vertex(1, -mouty*0.5f, 0);
    vertex(0, 0, 0.5f);
    fill(0,0,0);
    vertex(0, 0, 0);
    fill(160, 30, 30);
    
    vertex(1, -mouty*0.5f, 0);
    vertex(0, 0, -0.5f);
    fill(0,0,0);
    vertex(0, 0, 0);
    
    
    fill(fishColor);
    //Body front
    normal(0, 0, -1);
    vertex(0,0,-0.5f);
    normal(0, 1, 0);
    vertex(0,1,0);
    normal(0, 0, -1);
    vertex(-1, 0, -0.5f);
    
    normal(0, 0, -1);
    vertex(-1, 0, -0.5f);
     normal(0, 1, 0);
    vertex(0,1,0);
     normal(0, 1, 0);
    vertex(-1, 1, 0);
    
    normal(0, 0, 1);
    vertex(0,0,0.5f);
    normal(0, 1, 0);
    vertex(0,1,0);
    normal(0, 0, 1);
    vertex(-1, 0, 0.5f);
    
    normal(0, 0, 1);
    vertex(-1, 0, 0.5f);
    normal(0, 1, 0);
    vertex(0,1,0);
    normal(0, 1, 0);
    vertex(-1, 1, 0);
    
     normal(0, 0, -1);
    vertex(0,0,-0.5f);
      normal(0, -1, 0);
    vertex(0,-1,0);
     normal(0, 0, -1);
    vertex(-1, 0, -0.5f);
    
     normal(0, 0, -1);
    vertex(-1, 0, -0.5f);
      normal(0, -1, 0);
    vertex(0,-1,0);
      normal(0, -1, 0);
    vertex(-1, -1, 0);
    
     normal(0, 0, 1);
    vertex(0,0,0.5f);
       normal(0, -1, 0);
    vertex(0,-1,0);
    normal(0, 0, 1);
    vertex(-1, 0, 0.5f);
    
    normal(0, 0, 1);
    vertex(-1, 0, 0.5f);
       normal(0, -1, 0);
    vertex(0,-1,0);
       normal(0, -1, 0);
    vertex(-1, -1, 0);
    
    
    
    
    
    //body back
    normal(0, 1, 0);
    vertex(-1,1,0);
    normal(0, 0, -1);
    vertex(-1, 0, -0.5f);
    normal(0, 0, -1);
    vertex(-3, 0,0);
    
    normal(0, 0, 1);
    vertex(-1,0, 0.5f);
    normal(0, 1, 0);
    vertex(-1,1,0);
    normal(0, 0, 1);
    vertex(-3, 0,0);
    
    normal(0, -1, 0);
    vertex(-1, -1, 0);
    normal(0, 0, -1);
    vertex(-1, 0, -0.5f);
    normal(0, 0, -1);
    vertex(-3, 0,0);
    
    normal(0, -1, 0);
    vertex(-1, -1, 0);
    normal(0, 0, 1);
    vertex(-1,0, 0.5f);
    normal(0, 0, 1);
    vertex(-3, 0, 0);
    

    
    
    
    
    endShape();
    //sphere(size);
   
    popMatrix();
    
    
 
   // println(position.toString());
    }


  
  

}

class Ruins {

  ArrayList<RuinGroup> groups = new ArrayList();
  Terrain terrain;

  public void init(Terrain terrain) {
    this.terrain = terrain;
    int num = 30;
    for (int i = 0; i < num; i++) {
      RuinGroup group = new RuinGroup();
      groups.add(group);
    }
  }
  
  public void render(float time, float deltaTime) {
    
    for (RuinGroup group: groups) {
      group.render(time, deltaTime);
    }
    
    // Back to normal
    oceanLight.set("ruins", 0f);
    oceanLight.set("ruinsExpanded", 0f);
  }
}


class RuinGroup {
  PVector pos = new PVector();
  ArrayList<Ruin> ruins = new ArrayList();

  RuinGroup() {
    int num = (int) random(2, 10);
    pos.set(random(-80, 80), random(-20, -4),random(-80, 80));
    for (int i = 0; i < num; i++) {
      float size = random(0.2f, 1.7f)*random(0.3f, 2);
      float x = pos.x + random(-12, 12);
      float z = pos.z + random(-12, 12);
      float a = random(-PI, PI);
      int levels = (int)(random(1, 3)*random(1, 3));
      for (int level = 0; level < levels+2; level++) {
        Ruin ruin = new Ruin(this, size, x, level, z, levels, a);
        ruins.add(ruin);
      }
    }
  }
  
  public void render(float time, float deltaTime) {
    for (Ruin ruin: ruins) {
      ruin.render(time, deltaTime);
    }
  }
}


class Ruin {
  PVector pos = new PVector();
  float angleX = 0;
  float angleY = 0;
  float angleZ = 0;
  float size = 10;
  float seed;
    float blockColorR;
    float blockColorG;
    float blockColorB;
    int blockColor;
    int levels;
  
  Ruin (RuinGroup group, float size, float x, float dy, float z, int levels, float ya) {
    this.levels = levels;
    float y = terrain.heightAt(x,z) + dy * size;
    pos.set(x,y,z);
    float ra = TURN*0.01f;
    angleX = random(-ra, ra);        
    angleY = ya + random(-ra, ra);        
    angleZ = random(-ra, ra);
    this.size = size;
    seed = random(0, 100);
    blockColorR = 220 + random(-20, 20);
    blockColorG = 180 + random(-15, 15);
    blockColorB = 120 + random(-10, 10);
    blockColor = color(blockColorR, blockColorG, blockColorB);
  }
  
  public void render(float time, float deltaTime) {
    float ruinDance = (float) moonlander.getValue("ruinDanceFreq");
    float ruinDanceAmpl = (float) moonlander.getValue("ruinDanceAmpl");
    float ruinRaise = (float) moonlander.getValue("ruinRaise");
    float ruinExtend = (float) moonlander.getValue("ruinExtend");
    
    float ruinDeltaY = -ruinRaise * levels * size;

    oceanLight.set("ruinsExpanded", max(0, sin(time*PI*2) * ruinExtend));
        

    pushStyle();
    pushMatrix();

    // Position
    float freq =100;
    float angleFreq = 0.7f*freq;
    float bassAmount = ruinDanceAmpl*0.06f;
    float discantAmount = ruinDanceAmpl*0.002f;
    translate(pos.x + 0.2f*ruinDance * shakyNoise(time, freq, bassAmount, discantAmount, 1234.213f*seed), 
              pos.y + ruinDance * shakyNoise(time, freq, bassAmount, discantAmount, 8734.234f*seed) + ruinDeltaY, 
              pos.z + 0.2f*ruinDance * shakyNoise(time, freq, bassAmount, discantAmount, 7313.173f*seed));
    rotateX(angleX + ruinDance * shakyNoise(time, angleFreq, bassAmount, discantAmount, 896.45f*seed));
    rotateY(angleY + ruinDance * shakyNoise(time, angleFreq, bassAmount, discantAmount, 1534.3f*seed));
    rotateZ(angleZ + ruinDance * shakyNoise(time, angleFreq, bassAmount, discantAmount, 312.312f*seed));
    
    // Render
    fill(blockColor);
    box(size, size, size);

    // Sub-blocks
    randomSeed((long)(seed*100));
    if (random(0,1) < 0.96f) {
      int count = (int) (random(2, 6)*random(2, 4));
      for (int i = 0; i < count; i++) {
        randomSeed((long)(seed*7876.76f*i));
        pushMatrix();
 
        // Tell shader we are rendering cool stuff now
        oceanLight.set("ruins", random(0.7f, 1.0f));

        float r = blockColorR + random(-10, 10);
        float g = blockColorG + random(-10, 10);
        float b = blockColorB + random(-10, 10);
        blockColor = color(r, g, b);
        fill(blockColor);
        float p = 2;
        float ms =size/(1.5f*p);
        float extendX = 0 + random(0,1) < 0.3f ? random(-1, 1) * ruinExtend * ms : 0;
        float extendZ = 0 + random(0,1) < 0.3f ? random(-1, 1) * ruinExtend * ms : 0;
        translate(size*(int)random(-p, p)/(p*1.5f) + extendX,
                  size*(int)random(-p, p)/(p*1.5f), //-size*0.5*random(0,1),
                  size*(int)random(-p, p)/(p*1.5f) + extendZ);
        float ra = 0.1f;          
        rotateX(random(-ra, ra));          
        rotateY(random(-ra, ra));          
        rotateZ(random(-ra, ra));   
        float rs = size*0.07f;
        box(ms+random(-rs,rs), ms+random(-rs,rs), ms+random(-rs,rs));
        popMatrix();
      }
    }
    popMatrix();
    popStyle();
  }
}

String credits = 
  "Deeply Fishy\n"+
  "Coded in 24 hours at\nGraffathon 2018\n"+
  "by\n"+
  "FractalPixel\n"+
  "and\n"+
  "Shiera\n"+
  "\n"+
  "Music:\n"+
  "\"Final Battle of the Dark Wizards\" \nby \nKevin MacLeod (incompetech.com)\n"+
  "Licensed under Creative Commons: \nBy Attribution 3.0 License\n"+
  "\n";
  
class Scroller {
  
  float yPos = 1000;
  PFont font;
  float creditsTime = 2f * 60f;
  
  Scroller() {
    String fontName = "Cinzel-Regular.ttf";    
    font = createFont(fontName,128);
    textFont(font);
    textMode(SHAPE);
  }
  
  public void render(float time, float deltaTime) {
    float scrollSpeed = (float) moonlander.getValue("creditScrollSpeed");
    if (scrollSpeed > 0) {
     
      yPos -= deltaTime*200f * scrollSpeed;
      int col = (int)(sin(time*PI*2*0.5f) * 50);
      fill(80, 190+col/3, 200+col);
      textAlign(CENTER, TOP);
      pushMatrix();
      scale(0.01f);
      text(credits, 0, yPos, 200);
      popMatrix();
    }
  }
}
class Terrain {
  int sizeX;
  int sizeZ;
  float frequency = 15;
  float amplitude = 15;
  
  float cellSize = 0.2f;
  
  PShape terrainShape;

  private PVector tempNormal = new PVector();

  Terrain(int sizeX, int sizeZ) {
    this.sizeX = sizeX;
    this.sizeZ = sizeZ;
  }
  
  public void render() {
    shape(terrainShape);
  }
  
  public float sign(float x){
    if (x < 0) return -1;
    else return 1;
  }
  
  public float cellPos(float x) {
    return sign(x) * pow(abs(x), 1.2f) * cellSize;
  }
  
  public void init() {
    fill(180, 120, 80);
    terrainShape = createShape();
    terrainShape.beginShape(TRIANGLE);
    // terrainShape.stroke(0,255, 0);

    for (int z = -sizeZ; z < sizeZ; z++) {
      for (int x = -sizeX; x < sizeX; x++) {
        float x1 = cellPos(x);
        float x2 = cellPos(x+1);
        float z1 = cellPos(z);
        float z2 = cellPos(z+1);
        
        addVertex(x1, z1);
        addVertex(x1, z2);
        addVertex(x2, z1);

        addVertex(x2, z1);
        addVertex(x2, z2);
        addVertex(x1, z2);
        
      }
    }
    
    terrainShape.endShape();
  }
  
  public void addVertex(float x, float z) {
    normalAt(x, z, tempNormal);
    float y = heightAt(x, z);
    terrainShape.normal(tempNormal.x, tempNormal.y, tempNormal.z);
    terrainShape.vertex(x, y, z);
  }
  
  public float heightAt(float x, float z) {
    float h = roughHeightAt(x, z);
    
    float a = 3.0f;
    float s = 0.01f;
    float sx = noise(s*x+39.123f, s*z+1311.1f) * a * 0.5f + x;
    float sz = noise(s*x+113.13f, s*z+13.83f) * a * 0.5f + z;

    float scale = 5; 
    h += noise(sx/frequency+32.123f, sz/frequency+7657.234f) * amplitude;
    h += noise(123.321f + sx/(frequency*scale), 7321.321f + sz/(frequency*scale)) * amplitude * 0.5f;
    
    return h;
  }

  public float roughHeightAt(float x, float z) {
    // Hill
    float h = (x*x + z*z) * 0.01f - 2;
    return h;
  }

  public void normalAt(float x, float z, PVector normal) {
    // Based on: https://stackoverflow.com/questions/13983189/opengl-how-to-calculate-normals-in-a-terrain-height-grid
    float d = cellSize/2;
    float hL = heightAt(x-d, z);
    float hR = heightAt(x+d, z);
    float hD = heightAt(x, z-d);
    float hU = heightAt(x, z+d);
    normal.x = -(hL - hR);
    normal.z = -(hD - hU);
    normal.y = -d;
    normal.normalize();
  }
  
  
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "deeplyfishy" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
