/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import ddf.minim.UGen;
import java.util.Arrays;

public class Line
extends UGen {
    private float begAmp;
    private float endAmp;
    private float amp;
    private float lineTime;
    private float timeStepSize;
    private float lineNow;
    private boolean isActivated;

    public Line() {
        this(1.0f, 1.0f, 0.0f);
    }

    public Line(float dT) {
        this(dT, 1.0f, 0.0f);
    }

    public Line(float dT, float beginningAmplitude) {
        this(dT, beginningAmplitude, 0.0f);
    }

    public Line(float dT, float beginningAmplitude, float endAmplitude) {
        this.lineTime = dT;
        this.amp = this.begAmp = beginningAmplitude;
        this.endAmp = endAmplitude;
        this.lineNow = 0.0f;
        this.isActivated = false;
        Minim.debug(" dampTime = " + this.lineTime + " begAmp = " + this.begAmp + " now = " + this.lineNow);
    }

    public void activate() {
        this.lineNow = 0.0f;
        this.amp = this.begAmp;
        this.isActivated = true;
    }

    public void activate(float duration, float beginAmp, float endingAmp) {
        this.begAmp = beginAmp;
        this.endAmp = endingAmp;
        this.lineTime = duration;
        this.activate();
    }

    public boolean isAtEnd() {
        return this.lineNow >= this.lineTime;
    }

    public void setEndAmp(float newEndAmp) {
        this.endAmp = newEndAmp;
    }

    public void setLineTime(float newLineTime) {
        this.lineTime = newLineTime;
    }

    @Override
    protected void sampleRateChanged() {
        this.timeStepSize = 1.0f / this.sampleRate();
    }

    @Override
    protected void uGenerate(float[] channels) {
        if (!this.isActivated) {
            Arrays.fill(channels, this.begAmp);
        } else if (this.lineNow >= this.lineTime) {
            Arrays.fill(channels, this.endAmp);
        } else {
            this.amp += (this.endAmp - this.amp) * this.timeStepSize / (this.lineTime - this.lineNow);
            Arrays.fill(channels, this.amp);
            this.lineNow += this.timeStepSize;
        }
    }
}

