/*
 * Decompiled with CFR 0.152.
 */
import damkjer.ocd.Camera;
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.PShader;

public class deeplyfishy
extends PApplet {
    float TURN = (float)Math.PI * 2;
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    int fps = 60;
    Moonlander moonlander;
    PShader ocean;
    PShader oceanLight;
    Camera camera;
    float worblePos = 0.0f;
    Ruins ruins;
    Terrain terrain;
    Scroller scroller;
    PVector camPos = new PVector();
    PVector focusPos = new PVector();
    Scool smallScool;
    Scool smallScool2;
    Scool averageScool;
    Scool averageScool2;
    Scool averageScool3;
    Scool bigScool1;
    Scool bigScool2;
    Scool bigScool3;
    String credits = "Deeply Fishy\nCoded in 24 hours at\nGraffathon 2018\nby\nFractalPixel\nand\nShiera\n\nMusic:\n\"Final Battle of the Dark Wizards\" \nby \nKevin MacLeod (incompetech.com)\nLicensed under Creative Commons: \nBy Attribution 3.0 License\n\n";

    public float sinNoise(float t, float x) {
        return 0.5f * deeplyfishy.sin((float)(t * x)) + 0.5f * deeplyfishy.cos((float)(t * 0.31232f * x)) + 0.5f * deeplyfishy.sin((float)((t * 0.123f + deeplyfishy.cos((float)(t * 0.001351f))) * 0.871f * x));
    }

    public float shakyNoise(float time, float freq, float bass, float discant, float seed) {
        return (this.noise(time * 0.2f * freq, seed * 123.321f) * 2.0f - 1.0f) * bass + (this.noise(time * 1.0f * freq, seed * 887.213f) * 2.0f - 1.0f) * discant;
    }

    public void calcTargetPos(PVector pos, float time, float speed, float mag, float yScale, float yDelta) {
        pos.x = this.sinNoise(time + 782.213f, speed) * mag;
        pos.y = this.sinNoise(time + 3712.321f, speed * yScale) * mag + yDelta;
        pos.z = this.sinNoise(time + 12.876f, speed) * mag;
    }

    public void settings() {
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
        this.fullScreen("processing.opengl.PGraphics3D");
        this.randomSeed(8719L);
        this.noiseSeed(2131L);
    }

    public void setup() {
        this.noCursor();
        this.rectMode(3);
        this.translate(this.width / 2, this.height / 2);
        this.scale((float)this.height / 1000.0f);
        this.camera = new Camera((PApplet)this, -20.0f, 0.0f, 0.0f);
        this.camera.aim(0.0f, 0.0f, 0.0f);
        this.camera.feed();
        this.setupfishes();
        this.frameRate(this.fps);
        this.ocean = this.loadShader("ocean_frag.glsl", "ocean_vert.glsl");
        this.ocean.set("fade", 1.0f);
        this.oceanLight = this.loadShader("ocean_light_frag.glsl", "ocean_light_vert.glsl");
        this.oceanLight.set("fade", 1.0f);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"Final Battle of the Dark Wizards.mp3", (int)112, (int)8);
        this.moonlander.start();
        this.terrain = new Terrain(100, 100);
        this.terrain.init();
        this.ruins = new Ruins();
        this.ruins.init(this.terrain);
        this.scroller = new Scroller();
    }

    public void draw() {
        float camMoveDist;
        float mediumSpeed;
        float predatorSpeed;
        this.background(0);
        this.fill(255);
        this.resetShader();
        this.moonlander.update();
        int stopNow = this.moonlander.getIntValue("stopNow");
        if (stopNow >= 1) {
            this.exit();
        }
        float time = (float)this.moonlander.getCurrentTime();
        float deltaTime = 1.0f / (float)this.fps;
        this.scroller.render(time, deltaTime);
        float fade = (float)this.moonlander.getValue("fade");
        this.ocean.set("fade", fade);
        this.oceanLight.set("fade", fade);
        this.bigScool1.scoolSpeedMod = predatorSpeed = (float)this.moonlander.getValue("predatorSpeed");
        this.bigScool2.scoolSpeedMod = predatorSpeed;
        this.averageScool.scoolSpeedMod = mediumSpeed = (float)this.moonlander.getValue("mediumFishSpeed");
        float fishTargetSpeed = 0.05f;
        float fishTargetDist = 5.0f;
        this.calcTargetPos(this.smallScool.target, time + 31.32f, fishTargetSpeed, fishTargetDist * 0.8f, 0.5f, 2.0f);
        this.calcTargetPos(this.averageScool.target, time + 9823.3f, fishTargetSpeed * 0.7f, fishTargetDist * 1.1f, 0.6f, -1.0f);
        this.calcTargetPos(this.averageScool2.target, time + 732.3f, fishTargetSpeed * 1.2f, fishTargetDist * 0.8f, 0.6f, 0.5f);
        this.smallScool2.target.set(20.0f, -3.0f, 10.0f);
        this.averageScool3.target.set(-20.0f, -10.0f, 30.0f);
        this.bigScool3.target.set(5.0f, -16.0f, -40.0f);
        int cameraMode = this.moonlander.getIntValue("cameraMode");
        float baseCamMoveSpeed = (float)this.moonlander.getValue("camMoveSpeed");
        float baseCamMoveDist = (float)this.moonlander.getValue("camMoveDist");
        float targetY = (float)this.moonlander.getValue("targetY");
        float cameraY = (float)this.moonlander.getValue("camY");
        if (cameraMode == 1 && this.bigScool1.fishes.size() > 0) {
            Fish fish = this.bigScool1.fishes.get(0);
            this.focusPos.set(fish.position);
            PVector.lerp((PVector)this.camPos, (PVector)this.focusPos, (float)baseCamMoveDist);
        } else if (cameraMode == 2) {
            float camMoveSpeed = 0.01f * baseCamMoveSpeed;
            camMoveDist = 20.0f * baseCamMoveDist;
            this.focusPos.set(0.0f, targetY, 0.0f);
            this.camPos.set(-deeplyfishy.cos((float)(time * camMoveSpeed * this.TURN)) * camMoveDist, 0.0f, deeplyfishy.sin((float)(time * camMoveSpeed * this.TURN)) * camMoveDist);
        } else if (cameraMode == 3) {
            float camMoveSpeed = 0.03f * baseCamMoveSpeed;
            camMoveDist = 20.0f * baseCamMoveDist;
            this.focusPos.set(0.0f, targetY, 0.0f);
            this.camPos.set(-deeplyfishy.cos((float)(time * camMoveSpeed * this.TURN)) * camMoveDist, 3.0f, deeplyfishy.sin((float)(time * camMoveSpeed * this.TURN)) * camMoveDist * 0.4f + camMoveDist * 0.8f);
        } else {
            float camMoveSpeed = 0.1f * baseCamMoveSpeed;
            camMoveDist = 50.0f * baseCamMoveDist;
            float focusPosSpeed = 0.89f * baseCamMoveSpeed;
            float focusPosDist = 20.0f * baseCamMoveDist;
            this.calcTargetPos(this.camPos, time, camMoveSpeed, camMoveDist, 0.2f, 0.0f);
            this.calcTargetPos(this.focusPos, time + 3125.342f, focusPosSpeed, focusPosDist, 0.5f, targetY);
        }
        this.camera.jump(this.camPos.x, this.camPos.y + cameraY, this.camPos.z);
        this.camera.aim(this.focusPos.x, this.focusPos.y, this.focusPos.z);
        this.camera.feed();
        this.noStroke();
        this.shader(this.ocean);
        this.pushMatrix();
        this.translate(this.camPos.x, this.camPos.y, this.camPos.z);
        this.sphere(160.0f);
        this.popMatrix();
        float sunWorbleAmount = (float)this.moonlander.getValue("sunWorbleAmount");
        float sunWorbleSpeed = (float)this.moonlander.getValue("sunWorbleSpeed");
        this.worblePos += deltaTime * sunWorbleSpeed;
        this.directionalLight(255.0f, 255.0f, 255.0f, deeplyfishy.sin((float)this.worblePos) * sunWorbleAmount, 10.0f, deeplyfishy.cos((float)this.worblePos) * sunWorbleAmount);
        this.shader(this.oceanLight);
        this.terrain.render();
        this.ruins.render(time, deltaTime);
        this.fill(100.0f, 200.0f, 255.0f);
        this.drawfishes(deltaTime);
        this.noStroke();
    }

    public void setupfishes() {
        this.smallScool = new Scool(200, new PVector(0.0f, 0.0f, 0.0f), 2.5f, 0.1f, 0.3f, 0.8f, 50.0f, 175.0f, 235.0f, 50.0f, 200.0f, 200.0f);
        this.smallScool2 = new Scool(50, new PVector(22.0f, -5.0f, 22.0f), 2.5f, 0.2f, 0.5f, 0.8f, 160.0f, 111.0f, 55.0f, 200.0f, 60.0f, 200.0f);
        this.averageScool = new Scool(100, new PVector(-22.5f, -17.5f, 117.5f), 2.5f, 0.25f, 1.0f, 1.0f, 60.0f, 125.0f, 235.0f, 50.0f, 200.0f, 50.0f);
        this.averageScool2 = new Scool(100, new PVector(4.0f, -4.0f, 1.0f), 3.5f, 1.0f, 2.0f, 1.0f, 70.0f, 125.0f, 50.0f, 200.0f, 50.0f, 50.0f);
        this.averageScool3 = new Scool(40, new PVector(4.0f, -4.0f, 1.0f), 3.5f, 2.0f, 3.0f, 1.0f, 100.0f, 55.0f, 200.0f, 200.0f, 150.0f, 50.0f);
        this.bigScool1 = new Scool(1, new PVector(-100.5f, -17.5f, 122.5f), 10.0f, 15.0f, 20.0f, 1.5f, 50.0f, 235.0f, 160.0f, 200.0f, 50.0f, 50.0f);
        this.bigScool2 = new Scool(2, new PVector(-102.5f, -17.5f, -100.5f), 10.0f, 2.0f, 5.0f, 1.5f, 50.0f, 235.0f, 100.0f, 200.0f, 50.0f, 50.0f);
        this.bigScool3 = new Scool(5, new PVector(302.5f, -17.5f, 300.5f), 10.0f, 12.0f, 25.0f, 1.5f, 100.0f, 125.0f, 130.0f, 80.0f, 90.0f, 110.0f);
        this.smallScool.predators.add(this.bigScool1);
        this.averageScool.predators.add(this.bigScool2);
        this.bigScool1.prey = this.smallScool;
        this.bigScool1.prey = this.averageScool;
        this.noStroke();
    }

    public void drawfishes(float deltaTime) {
        this.smallScool.drawScool(deltaTime);
        this.averageScool.drawScool(deltaTime);
        this.bigScool1.drawScool(deltaTime);
        this.bigScool2.drawScool(deltaTime);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"deeplyfishy"};
        if (passedArgs != null) {
            PApplet.main((String[])deeplyfishy.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Fish {
        PVector position;
        PVector velocition;
        float maxVelocity;
        float maxVelocityChange;
        float searchDist;
        float size;
        float minVelosity;
        float contentDist;
        float crowdedDist;
        float tailPos;
        float tailSpeed;
        float maxMouthUp;
        float moutPos;
        float moutSpeed;
        int fishColor;
        int finColor;
        float minDistToBottom;
        int terror;
        int lonly;

        Fish(PVector averageStartPosition, float positionSpread, float minsize, float maxSize, float speedModifier, float fishred, float fishgreen, float fishblue, float tailred, float tailgreen, float tailblue) {
            this.position = new PVector(deeplyfishy.this.random(10.0f, 15.0f), deeplyfishy.this.random(-20.0f, -15.0f), deeplyfishy.this.random(-10.0f, -5.0f));
            this.velocition = new PVector(deeplyfishy.this.random(-0.5f, 0.5f), deeplyfishy.this.random(-0.5f, 0.5f), deeplyfishy.this.random(-0.5f, 0.5f));
            this.maxVelocity = deeplyfishy.this.random(4.0f, 8.0f);
            this.maxVelocityChange = deeplyfishy.this.random(0.01f, 0.05f);
            this.searchDist = deeplyfishy.this.random(7.0f, 10.0f);
            this.size = deeplyfishy.this.random(0.05f, 0.2f);
            this.minVelosity = deeplyfishy.this.random(0.02f * this.size, 0.2f * this.size);
            this.contentDist = deeplyfishy.this.random(0.5f * this.size, 2.0f * this.size);
            this.crowdedDist = deeplyfishy.this.random(this.size * 0.1f, this.size * 2.0f);
            this.tailPos = deeplyfishy.this.random(0.0f, 1.0f);
            this.tailSpeed = deeplyfishy.this.random(25.0f, 40.0f);
            this.maxMouthUp = deeplyfishy.this.random(0.1f, 1.0f);
            this.moutPos = deeplyfishy.this.random(0.0f, 1.0f);
            this.moutSpeed = deeplyfishy.this.random(5.0f, 10.0f);
            this.fishColor = deeplyfishy.this.color(deeplyfishy.this.random(0.0f, 175.0f), deeplyfishy.this.random(100.0f, 255.0f), 255.0f);
            this.finColor = deeplyfishy.this.color(deeplyfishy.this.random(0.0f, 100.0f), deeplyfishy.this.random(200.0f, 255.0f), deeplyfishy.this.random(100.0f, 255.0f));
            this.minDistToBottom = 1.0f;
            this.terror = 0;
            this.lonly = 0;
            this.position = new PVector(deeplyfishy.this.random(averageStartPosition.x - positionSpread, averageStartPosition.x + positionSpread), deeplyfishy.this.random(averageStartPosition.y - positionSpread, averageStartPosition.y + positionSpread), deeplyfishy.this.random(averageStartPosition.z - positionSpread, averageStartPosition.z + positionSpread));
            this.size = deeplyfishy.this.random(minsize, maxSize);
            this.maxVelocity = deeplyfishy.this.random(4.0f * speedModifier, 8.0f * speedModifier);
            this.fishColor = deeplyfishy.this.color(deeplyfishy.this.random(fishred - 50.0f, fishred + 50.0f), deeplyfishy.this.random(fishgreen - 50.0f, fishgreen + 50.0f), deeplyfishy.this.random(fishblue - 20.0f, fishblue + 20.0f));
            this.finColor = deeplyfishy.this.color(deeplyfishy.this.random(tailred - 50.0f, tailred + 50.0f), deeplyfishy.this.random(tailgreen - 50.0f, tailgreen + 50.0f), deeplyfishy.this.random(tailblue - 50.0f, tailblue + 50.0f));
        }

        public void step(ArrayList<Fish> fishes, float deltaTime, PVector target, ArrayList<PVector> avoidThese, float avoidDist, ArrayList<Scool> predators, PVector scoolCenter, float scoolSpeedMod) {
            PVector center = new PVector();
            PVector avoid = new PVector();
            PVector toward = new PVector();
            PVector match = new PVector();
            PVector avoidObj = new PVector();
            PVector velocityChange = new PVector();
            float relativeMaxYVelocity = 0.5f;
            center = this.findMass(this, fishes, this.searchDist, this.contentDist);
            avoid = this.avoidFriends(this, fishes);
            toward = this.tovardPosition(this, target).mult(100.0f);
            match = this.matchSpeed(this, fishes);
            avoidObj = this.avoidObjects(avoidThese, this, avoidDist).mult(100000.0f);
            velocityChange.add(center).add(avoid).add(toward).add(match).add(avoidObj);
            velocityChange.mult(deltaTime);
            velocityChange.y *= relativeMaxYVelocity;
            if (velocityChange.mag() > this.maxVelocityChange) {
                velocityChange.normalize().mult(this.maxVelocityChange);
            }
            if ((float)this.terror <= 2.0f / deltaTime) {
                this.velocition.add(velocityChange);
            }
            float distToPredator = 0.0f;
            if (predators != null) {
                for (Scool predatorScool : predators) {
                    for (Fish predator : predatorScool.fishes) {
                        distToPredator = predator.position.dist(this.position);
                        if (!(distToPredator < 2.0f)) continue;
                        this.terror = 4 * (int)(1.0f / deltaTime);
                        PVector direction = this.position.copy().sub(predator.position).normalize();
                        this.velocition = direction.mult(this.maxVelocity * 2.0f);
                    }
                }
            }
            float bottomY = -deeplyfishy.this.terrain.roughHeightAt(this.position.x, this.position.y);
            float bottomDist = deeplyfishy.abs((float)(this.position.y - bottomY));
            if (this.velocition.y < 0.0f && bottomDist < this.minDistToBottom) {
                this.velocition.y += this.maxVelocityChange * 0.2f;
            }
            if (bottomDist < -0.2f) {
                this.velocition.y = 0.1f;
            }
            if (deeplyfishy.abs((float)this.velocition.y) > this.maxVelocity * relativeMaxYVelocity * ((float)this.terror * deltaTime + 1.0f)) {
                float sign = 1.0f;
                if (this.velocition.y < 0.0f) {
                    sign = -1.0f;
                }
                this.velocition.y = sign * this.maxVelocity * relativeMaxYVelocity * ((float)this.terror * deltaTime + 1.0f);
            }
            if ((float)this.terror >= 1.0f / deltaTime) {
                if (this.velocition.mag() > this.maxVelocity * (float)this.terror * deltaTime) {
                    this.velocition.normalize().mult(this.maxVelocity);
                } else if (this.velocition.mag() < this.minVelosity * (float)this.terror * deltaTime) {
                    this.velocition.normalize().mult(this.minVelosity);
                }
                --this.terror;
            } else if (this.velocition.mag() > this.maxVelocity) {
                this.velocition.normalize().mult(this.maxVelocity);
            } else if (this.velocition.mag() < this.minVelosity) {
                this.velocition.normalize().mult(this.minVelosity);
            }
            PVector temp = this.velocition.copy().mult(deltaTime).mult(scoolSpeedMod);
            this.position.add(temp);
        }

        public PVector findMass(Fish thisFish, ArrayList<Fish> fishes, float searchDist, float contentDist) {
            PVector centerOfMass = new PVector();
            int num = 0;
            for (Fish f : fishes) {
                float dist = f.position.dist(thisFish.position);
                if (f == thisFish || !(dist < searchDist)) continue;
                centerOfMass.add(f.position);
                ++num;
            }
            if (num != 0) {
                centerOfMass.div((float)num);
                centerOfMass.sub(thisFish.position);
                float dist = thisFish.position.dist(centerOfMass);
                float distFromContent = dist - contentDist;
                if (distFromContent < 0.0f) {
                    distFromContent = 0.0f;
                }
                float magnitude = distFromContent / (searchDist - contentDist);
                centerOfMass.normalize().mult(magnitude);
            }
            return centerOfMass;
        }

        public PVector avoidFriends(Fish thisFish, ArrayList<Fish> fishes) {
            PVector avoidance = new PVector();
            float avoidDist = 1.0f;
            int num = 0;
            PVector temp = new PVector();
            for (Fish f : fishes) {
                float dist = f.position.dist(thisFish.position);
                if (f == thisFish || !(dist < avoidDist)) continue;
                ++num;
                temp = f.position.copy().sub(thisFish.position).div(avoidDist);
                float magn = avoidDist - temp.mag();
                temp.normalize().mult(magn);
                avoidance.sub(temp);
            }
            if (num > 0) {
                avoidance.div((float)num);
            }
            return avoidance;
        }

        public PVector tovardPosition(Fish thisFish, PVector pos) {
            PVector towardPos = new PVector();
            towardPos.add(pos).sub(thisFish.position).div(100.0f);
            return towardPos;
        }

        public PVector matchSpeed(Fish thisFish, ArrayList<Fish> fishes) {
            PVector avgSpeed = new PVector();
            int num = 0;
            for (Fish f : fishes) {
                float dist = f.position.dist(thisFish.position);
                if (f == thisFish || !(dist < 3.0f)) continue;
                avgSpeed.add(f.position);
                ++num;
            }
            if (num > 0) {
                avgSpeed.div((float)num);
            }
            return avgSpeed.mult(0.005f);
        }

        public PVector avoidObjects(ArrayList<PVector> objects, Fish thisFish, float distToAvoid) {
            PVector avoidDirection = new PVector();
            PVector distToObjectVec = new PVector();
            for (PVector object : objects) {
                distToObjectVec = object.copy().sub(thisFish.position);
                float dot = distToObjectVec.dot(thisFish.velocition);
                if (!(distToObjectVec.mag() < distToAvoid * 2.0f) || !(dot > 0.0f)) continue;
                PVector distChange = distToObjectVec.copy().normalize().mult(-dot);
                avoidDirection.sub(distChange).normalize();
                float avoidSpeed = (distToAvoid * 2.0f - distToObjectVec.mag()) / distToAvoid * 2.0f;
                avoidDirection.mult(-avoidSpeed);
            }
            return avoidDirection;
        }

        public void render(float deltaTime) {
            this.tailPos += deltaTime;
            this.moutPos += deltaTime;
            deeplyfishy.this.pushMatrix();
            deeplyfishy.this.translate(this.position.x, this.position.y, this.position.z);
            deeplyfishy.this.scale(this.size / 5.5f);
            float x = this.velocition.x;
            float z = this.velocition.z;
            float angle = deeplyfishy.atan2((float)(-z), (float)x);
            deeplyfishy.this.rotateY(angle);
            deeplyfishy.this.rotateX(deeplyfishy.radians((float)180.0f));
            deeplyfishy.this.translate(0.0f, 0.4f, 0.0f);
            deeplyfishy.this.fill(220.0f, 190.0f, 100.0f);
            deeplyfishy.this.sphereDetail(10);
            deeplyfishy.this.sphere(0.3f);
            deeplyfishy.this.translate(0.05f, 0.1f, 0.2f);
            deeplyfishy.this.fill(0.0f, 0.0f, 0.0f);
            deeplyfishy.this.sphere(0.1f);
            deeplyfishy.this.translate(0.0f, 0.0f, -0.4f);
            deeplyfishy.this.sphere(0.1f);
            deeplyfishy.this.translate(-0.05f, -0.5f, 0.2f);
            deeplyfishy.this.beginShape(8);
            deeplyfishy.this.fill(this.fishColor);
            deeplyfishy.this.fill(this.finColor);
            float tailz = deeplyfishy.sin((float)(this.tailPos * this.tailSpeed)) * 0.5f;
            deeplyfishy.this.vertex(-3.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(-4.5f, 1.0f, tailz);
            deeplyfishy.this.vertex(-4.0f, 0.0f, tailz);
            deeplyfishy.this.vertex(-3.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(-4.5f, -1.0f, tailz);
            deeplyfishy.this.vertex(-4.0f, 0.0f, tailz);
            deeplyfishy.this.vertex(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(-0.5f, 1.5f, -tailz * 0.3f);
            deeplyfishy.this.vertex(-1.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(-1.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(-0.5f, 1.5f, -tailz * 0.3f);
            deeplyfishy.this.vertex(-1.5f, 1.5f, -tailz * 0.3f);
            float sidez = (deeplyfishy.sin((float)(this.tailPos * this.tailSpeed)) + 1.5f) / 2.5f;
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.5f);
            deeplyfishy.this.vertex(-1.0f, -1.0f, sidez);
            deeplyfishy.this.vertex(-1.0f, -0.5f, sidez);
            deeplyfishy.this.vertex(0.0f, 0.0f, -0.5f);
            deeplyfishy.this.vertex(-1.0f, -1.0f, -sidez);
            deeplyfishy.this.vertex(-1.0f, -0.5f, -sidez);
            float mouty = (deeplyfishy.sin((float)(this.moutPos * this.moutSpeed)) - 1.0f) * 0.5f * this.maxMouthUp;
            deeplyfishy.this.fill(this.fishColor);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.normal(1.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(1.0f, mouty, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(1.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(1.0f, -0.5f * mouty, 0.0f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(1.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(1.0f, -0.5f * mouty, 0.0f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(1.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(1.0f, mouty, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.fill(160.0f, 30.0f, 30.0f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(1.0f, mouty, 0.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.5f);
            deeplyfishy.this.fill(0.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.0f);
            deeplyfishy.this.fill(160.0f, 30.0f, 30.0f);
            deeplyfishy.this.vertex(1.0f, mouty, 0.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, -0.5f);
            deeplyfishy.this.fill(0.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.0f);
            deeplyfishy.this.fill(160.0f, 30.0f, 30.0f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(1.0f, -mouty * 0.5f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.5f);
            deeplyfishy.this.fill(0.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.0f);
            deeplyfishy.this.fill(160.0f, 30.0f, 30.0f);
            deeplyfishy.this.vertex(1.0f, -mouty * 0.5f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, -0.5f);
            deeplyfishy.this.fill(0.0f, 0.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.0f);
            deeplyfishy.this.fill(this.fishColor);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(-1.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(-1.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(-1.0f, -1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(0.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(-1.0f, -1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(-1.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(-3.0f, 0.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(0.0f, 1.0f, 0.0f);
            deeplyfishy.this.vertex(-1.0f, 1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(-3.0f, 0.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(-1.0f, -1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, -0.5f);
            deeplyfishy.this.normal(0.0f, 0.0f, -1.0f);
            deeplyfishy.this.vertex(-3.0f, 0.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, -1.0f, 0.0f);
            deeplyfishy.this.vertex(-1.0f, -1.0f, 0.0f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(-1.0f, 0.0f, 0.5f);
            deeplyfishy.this.normal(0.0f, 0.0f, 1.0f);
            deeplyfishy.this.vertex(-3.0f, 0.0f, 0.0f);
            deeplyfishy.this.endShape();
            deeplyfishy.this.popMatrix();
        }
    }

    class Ruin {
        PVector pos = new PVector();
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float size = 10.0f;
        float seed;
        float blockColorR;
        float blockColorG;
        float blockColorB;
        int blockColor;
        int levels;

        Ruin(RuinGroup group, float size, float x, float dy, float z, int levels, float ya) {
            this.levels = levels;
            float y = deeplyfishy.this.terrain.heightAt(x, z) + dy * size;
            this.pos.set(x, y, z);
            float ra = deeplyfishy.this.TURN * 0.01f;
            this.angleX = deeplyfishy.this.random(-ra, ra);
            this.angleY = ya + deeplyfishy.this.random(-ra, ra);
            this.angleZ = deeplyfishy.this.random(-ra, ra);
            this.size = size;
            this.seed = deeplyfishy.this.random(0.0f, 100.0f);
            this.blockColorR = 220.0f + deeplyfishy.this.random(-20.0f, 20.0f);
            this.blockColorG = 180.0f + deeplyfishy.this.random(-15.0f, 15.0f);
            this.blockColorB = 120.0f + deeplyfishy.this.random(-10.0f, 10.0f);
            this.blockColor = deeplyfishy.this.color(this.blockColorR, this.blockColorG, this.blockColorB);
        }

        public void render(float time, float deltaTime) {
            float ruinDance = (float)deeplyfishy.this.moonlander.getValue("ruinDanceFreq");
            float ruinDanceAmpl = (float)deeplyfishy.this.moonlander.getValue("ruinDanceAmpl");
            float ruinRaise = (float)deeplyfishy.this.moonlander.getValue("ruinRaise");
            float ruinExtend = (float)deeplyfishy.this.moonlander.getValue("ruinExtend");
            float ruinDeltaY = -ruinRaise * (float)this.levels * this.size;
            deeplyfishy.this.oceanLight.set("ruinsExpanded", deeplyfishy.max((float)0.0f, (float)(deeplyfishy.sin((float)(time * (float)Math.PI * 2.0f)) * ruinExtend)));
            deeplyfishy.this.pushStyle();
            deeplyfishy.this.pushMatrix();
            float freq = 100.0f;
            float angleFreq = 0.7f * freq;
            float bassAmount = ruinDanceAmpl * 0.06f;
            float discantAmount = ruinDanceAmpl * 0.002f;
            deeplyfishy.this.translate(this.pos.x + 0.2f * ruinDance * deeplyfishy.this.shakyNoise(time, freq, bassAmount, discantAmount, 1234.213f * this.seed), this.pos.y + ruinDance * deeplyfishy.this.shakyNoise(time, freq, bassAmount, discantAmount, 8734.234f * this.seed) + ruinDeltaY, this.pos.z + 0.2f * ruinDance * deeplyfishy.this.shakyNoise(time, freq, bassAmount, discantAmount, 7313.173f * this.seed));
            deeplyfishy.this.rotateX(this.angleX + ruinDance * deeplyfishy.this.shakyNoise(time, angleFreq, bassAmount, discantAmount, 896.45f * this.seed));
            deeplyfishy.this.rotateY(this.angleY + ruinDance * deeplyfishy.this.shakyNoise(time, angleFreq, bassAmount, discantAmount, 1534.3f * this.seed));
            deeplyfishy.this.rotateZ(this.angleZ + ruinDance * deeplyfishy.this.shakyNoise(time, angleFreq, bassAmount, discantAmount, 312.312f * this.seed));
            deeplyfishy.this.fill(this.blockColor);
            deeplyfishy.this.box(this.size, this.size, this.size);
            deeplyfishy.this.randomSeed((long)(this.seed * 100.0f));
            if (deeplyfishy.this.random(0.0f, 1.0f) < 0.96f) {
                int count = (int)(deeplyfishy.this.random(2.0f, 6.0f) * deeplyfishy.this.random(2.0f, 4.0f));
                int i = 0;
                while (i < count) {
                    deeplyfishy.this.randomSeed((long)(this.seed * 7876.76f * (float)i));
                    deeplyfishy.this.pushMatrix();
                    deeplyfishy.this.oceanLight.set("ruins", deeplyfishy.this.random(0.7f, 1.0f));
                    float r = this.blockColorR + deeplyfishy.this.random(-10.0f, 10.0f);
                    float g = this.blockColorG + deeplyfishy.this.random(-10.0f, 10.0f);
                    float b = this.blockColorB + deeplyfishy.this.random(-10.0f, 10.0f);
                    this.blockColor = deeplyfishy.this.color(r, g, b);
                    deeplyfishy.this.fill(this.blockColor);
                    float p = 2.0f;
                    float ms = this.size / (1.5f * p);
                    float extendX = 0.0f + deeplyfishy.this.random(0.0f, 1.0f) < 0.3f ? deeplyfishy.this.random(-1.0f, 1.0f) * ruinExtend * ms : 0.0f;
                    float extendZ = 0.0f + deeplyfishy.this.random(0.0f, 1.0f) < 0.3f ? deeplyfishy.this.random(-1.0f, 1.0f) * ruinExtend * ms : 0.0f;
                    deeplyfishy.this.translate(this.size * (float)((int)deeplyfishy.this.random(-p, p)) / (p * 1.5f) + extendX, this.size * (float)((int)deeplyfishy.this.random(-p, p)) / (p * 1.5f), this.size * (float)((int)deeplyfishy.this.random(-p, p)) / (p * 1.5f) + extendZ);
                    float ra = 0.1f;
                    deeplyfishy.this.rotateX(deeplyfishy.this.random(-ra, ra));
                    deeplyfishy.this.rotateY(deeplyfishy.this.random(-ra, ra));
                    deeplyfishy.this.rotateZ(deeplyfishy.this.random(-ra, ra));
                    float rs = this.size * 0.07f;
                    deeplyfishy.this.box(ms + deeplyfishy.this.random(-rs, rs), ms + deeplyfishy.this.random(-rs, rs), ms + deeplyfishy.this.random(-rs, rs));
                    deeplyfishy.this.popMatrix();
                    ++i;
                }
            }
            deeplyfishy.this.popMatrix();
            deeplyfishy.this.popStyle();
        }
    }

    class RuinGroup {
        PVector pos = new PVector();
        ArrayList<Ruin> ruins = new ArrayList();

        RuinGroup() {
            int num = (int)deeplyfishy.this.random(2.0f, 10.0f);
            this.pos.set(deeplyfishy.this.random(-80.0f, 80.0f), deeplyfishy.this.random(-20.0f, -4.0f), deeplyfishy.this.random(-80.0f, 80.0f));
            int i = 0;
            while (i < num) {
                float size = deeplyfishy.this.random(0.2f, 1.7f) * deeplyfishy.this.random(0.3f, 2.0f);
                float x = this.pos.x + deeplyfishy.this.random(-12.0f, 12.0f);
                float z = this.pos.z + deeplyfishy.this.random(-12.0f, 12.0f);
                float a = deeplyfishy.this.random((float)(-Math.PI), (float)Math.PI);
                int levels = (int)(deeplyfishy.this.random(1.0f, 3.0f) * deeplyfishy.this.random(1.0f, 3.0f));
                int level = 0;
                while (level < levels + 2) {
                    Ruin ruin = new Ruin(this, size, x, level, z, levels, a);
                    this.ruins.add(ruin);
                    ++level;
                }
                ++i;
            }
        }

        public void render(float time, float deltaTime) {
            for (Ruin ruin : this.ruins) {
                ruin.render(time, deltaTime);
            }
        }
    }

    class Ruins {
        ArrayList<RuinGroup> groups = new ArrayList();
        Terrain terrain;

        Ruins() {
        }

        public void init(Terrain terrain) {
            this.terrain = terrain;
            int num = 30;
            int i = 0;
            while (i < num) {
                RuinGroup group = new RuinGroup();
                this.groups.add(group);
                ++i;
            }
        }

        public void render(float time, float deltaTime) {
            for (RuinGroup group : this.groups) {
                group.render(time, deltaTime);
            }
            deeplyfishy.this.oceanLight.set("ruins", 0.0f);
            deeplyfishy.this.oceanLight.set("ruinsExpanded", 0.0f);
        }
    }

    class Scool {
        ArrayList<Fish> fishes = new ArrayList();
        int scoolsize;
        PVector target = new PVector(0.0f, -2.0f, 0.0f);
        ArrayList<PVector> avoidThese = new ArrayList();
        ArrayList<Scool> predators = new ArrayList();
        Scool prey;
        PVector scoolCenter;
        float scoolSpeedMod = 1.0f;

        Scool(int amount, PVector averageStartPosition, float positionSpread, float minsize, float maxSize, float speedModifier, float fishred, float fishgreen, float fishblue, float tailred, float tailgree, float tailblue) {
            this.scoolsize = amount;
            int i = 0;
            while (i < amount) {
                this.fishes.add(new Fish(averageStartPosition, positionSpread, minsize, maxSize, speedModifier, fishred, fishgreen, fishblue, tailred, tailgree, tailblue));
                ++i;
            }
            this.scoolCenter = averageStartPosition;
        }

        public void drawScool(float deltaTime) {
            if (this.prey != null) {
                this.target = this.prey.scoolCenter;
            }
            int num = 0;
            this.scoolCenter.set(0.0f, 0.0f, 0.0f);
            for (Fish f : this.fishes) {
                this.scoolCenter.add(f.position);
                ++num;
            }
            if (num != 0) {
                this.scoolCenter.div((float)num);
            }
            for (Fish f : this.fishes) {
                f.render(deltaTime);
                f.step(this.fishes, deltaTime, this.target, this.avoidThese, 3.0f, this.predators, this.scoolCenter.copy(), this.scoolSpeedMod);
            }
        }
    }

    class Scroller {
        float yPos = 1000.0f;
        PFont font;
        float creditsTime = 120.0f;

        Scroller() {
            String fontName = "Cinzel-Regular.ttf";
            this.font = deeplyfishy.this.createFont(fontName, 128.0f);
            deeplyfishy.this.textFont(this.font);
            deeplyfishy.this.textMode(5);
        }

        public void render(float time, float deltaTime) {
            float scrollSpeed = (float)deeplyfishy.this.moonlander.getValue("creditScrollSpeed");
            if (scrollSpeed > 0.0f) {
                this.yPos -= deltaTime * 200.0f * scrollSpeed;
                int col = (int)(deeplyfishy.sin((float)(time * (float)Math.PI * 2.0f * 0.5f)) * 50.0f);
                deeplyfishy.this.fill(80.0f, 190 + col / 3, 200 + col);
                deeplyfishy.this.textAlign(3, 101);
                deeplyfishy.this.pushMatrix();
                deeplyfishy.this.scale(0.01f);
                deeplyfishy.this.text(deeplyfishy.this.credits, 0.0f, this.yPos, 200.0f);
                deeplyfishy.this.popMatrix();
            }
        }
    }

    class Terrain {
        int sizeX;
        int sizeZ;
        float frequency = 15.0f;
        float amplitude = 15.0f;
        float cellSize = 0.2f;
        PShape terrainShape;
        private PVector tempNormal = new PVector();

        Terrain(int sizeX, int sizeZ) {
            this.sizeX = sizeX;
            this.sizeZ = sizeZ;
        }

        public void render() {
            deeplyfishy.this.shape(this.terrainShape);
        }

        public float sign(float x) {
            if (x < 0.0f) {
                return -1.0f;
            }
            return 1.0f;
        }

        public float cellPos(float x) {
            return this.sign(x) * deeplyfishy.pow((float)deeplyfishy.abs((float)x), (float)1.2f) * this.cellSize;
        }

        public void init() {
            deeplyfishy.this.fill(180.0f, 120.0f, 80.0f);
            this.terrainShape = deeplyfishy.this.createShape();
            this.terrainShape.beginShape(8);
            int z = -this.sizeZ;
            while (z < this.sizeZ) {
                int x = -this.sizeX;
                while (x < this.sizeX) {
                    float x1 = this.cellPos(x);
                    float x2 = this.cellPos(x + 1);
                    float z1 = this.cellPos(z);
                    float z2 = this.cellPos(z + 1);
                    this.addVertex(x1, z1);
                    this.addVertex(x1, z2);
                    this.addVertex(x2, z1);
                    this.addVertex(x2, z1);
                    this.addVertex(x2, z2);
                    this.addVertex(x1, z2);
                    ++x;
                }
                ++z;
            }
            this.terrainShape.endShape();
        }

        public void addVertex(float x, float z) {
            this.normalAt(x, z, this.tempNormal);
            float y = this.heightAt(x, z);
            this.terrainShape.normal(this.tempNormal.x, this.tempNormal.y, this.tempNormal.z);
            this.terrainShape.vertex(x, y, z);
        }

        public float heightAt(float x, float z) {
            float h = this.roughHeightAt(x, z);
            float a = 3.0f;
            float s = 0.01f;
            float sx = deeplyfishy.this.noise(s * x + 39.123f, s * z + 1311.1f) * a * 0.5f + x;
            float sz = deeplyfishy.this.noise(s * x + 113.13f, s * z + 13.83f) * a * 0.5f + z;
            float scale = 5.0f;
            h += deeplyfishy.this.noise(sx / this.frequency + 32.123f, sz / this.frequency + 7657.234f) * this.amplitude;
            return h += deeplyfishy.this.noise(123.321f + sx / (this.frequency * scale), 7321.321f + sz / (this.frequency * scale)) * this.amplitude * 0.5f;
        }

        public float roughHeightAt(float x, float z) {
            float h = (x * x + z * z) * 0.01f - 2.0f;
            return h;
        }

        public void normalAt(float x, float z, PVector normal) {
            float d = this.cellSize / 2.0f;
            float hL = this.heightAt(x - d, z);
            float hR = this.heightAt(x + d, z);
            float hD = this.heightAt(x, z - d);
            float hU = this.heightAt(x, z + d);
            normal.x = -(hL - hR);
            normal.z = -(hD - hU);
            normal.y = -d;
            normal.normalize();
        }
    }
}

