/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioMetaData;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.Playable;
import ddf.minim.UGen;
import ddf.minim.spi.AudioRecordingStream;
import java.util.Arrays;

public class FilePlayer
extends UGen
implements Playable {
    private AudioRecordingStream mFileStream;
    private boolean isPaused;
    private MultiChannelBuffer buffer;
    private int bufferOutIndex;

    public FilePlayer(AudioRecordingStream iFileStream) {
        this.mFileStream = iFileStream;
        this.buffer = new MultiChannelBuffer(1024, this.mFileStream.getFormat().getChannels());
        this.bufferOutIndex = 0;
    }

    public AudioRecordingStream getStream() {
        return this.mFileStream;
    }

    @Override
    public void play() {
        this.mFileStream.play();
        this.isPaused = false;
    }

    @Override
    public void play(int millis) {
        this.cue(millis);
        this.play();
    }

    @Override
    public void pause() {
        this.mFileStream.pause();
        this.isPaused = true;
    }

    @Override
    public void rewind() {
        this.cue(0);
    }

    @Override
    public void loop() {
        this.loop(-1);
    }

    @Override
    public void loop(int loopCount) {
        if (this.isPaused) {
            int pos = this.mFileStream.getMillisecondPosition();
            this.mFileStream.loop(loopCount);
            this.cue(pos);
        } else {
            this.mFileStream.loop(loopCount);
        }
        this.isPaused = false;
    }

    @Override
    public int loopCount() {
        return this.mFileStream.getLoopCount();
    }

    @Override
    public int length() {
        return this.mFileStream.getMillisecondLength();
    }

    @Override
    public int position() {
        return this.mFileStream.getMillisecondPosition();
    }

    @Override
    public void cue(int millis) {
        if (millis < 0) {
            millis = 0;
        } else if (millis > this.length()) {
            millis = this.length();
        }
        this.mFileStream.setMillisecondPosition(millis);
        this.fillBuffer();
    }

    @Override
    public void skip(int millis) {
        int pos = this.position() + millis;
        if (pos < 0) {
            pos = 0;
        } else if (pos > this.length()) {
            pos = this.length();
        }
        this.cue(pos);
    }

    @Override
    public boolean isLooping() {
        return this.mFileStream.getLoopCount() != 0;
    }

    @Override
    public boolean isPlaying() {
        return this.mFileStream.isPlaying();
    }

    @Override
    public AudioMetaData getMetaData() {
        return this.mFileStream.getMetaData();
    }

    @Override
    public void setLoopPoints(int start, int stop) {
        this.mFileStream.setLoopPoints(start, stop);
    }

    public void close() {
        this.mFileStream.close();
    }

    private void fillBuffer() {
        this.mFileStream.read(this.buffer);
        this.bufferOutIndex = 0;
    }

    @Override
    protected void uGenerate(float[] channels) {
        if (this.mFileStream.isPlaying()) {
            if (this.buffer.getChannelCount() == 1) {
                Arrays.fill(channels, this.buffer.getSample(0, this.bufferOutIndex));
            }
            if (this.buffer.getChannelCount() <= channels.length) {
                for (int i = 0; i < channels.length; ++i) {
                    channels[i] = this.buffer.getSample(i, this.bufferOutIndex);
                }
            } else if (channels.length == 1 && this.buffer.getChannelCount() == 2) {
                channels[0] = (this.buffer.getSample(0, this.bufferOutIndex) + this.buffer.getSample(1, this.bufferOutIndex)) / 2.0f;
            }
            ++this.bufferOutIndex;
            if (this.bufferOutIndex == this.buffer.getBufferSize()) {
                this.fillBuffer();
            }
        } else {
            Arrays.fill(channels, 0.0f);
        }
    }
}

