/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.PShader;

public class PlatonicLove
extends PApplet {
    static boolean release = true;
    Moonlander ml;
    PGraphics frame;
    PGraphics buffer;
    int w = 1280;
    int h = 720;
    float whiteout;
    float chroma_intens;
    float bluramount;
    int neon_intens;
    float display_noise;
    static int particlenum = 64;
    static int rainnum = 32;
    float[] dropx = new float[rainnum];
    PVector[] dropdir = new PVector[rainnum];
    float[] dropcol = new float[rainnum];
    float[] droplen = new float[rainnum];
    PShader post;
    PShader neon;
    PShader glitch;
    PShape[] platonics = new PShape[5];
    PVector[] particles = new PVector[particlenum];
    PVector[] particle_v = new PVector[particlenum];
    PFont f;

    public void settings() {
        if (release) {
            this.fullScreen("processing.opengl.PGraphics2D");
        } else {
            this.size(this.w, this.h, "processing.opengl.PGraphics2D");
        }
    }

    public void setup() {
        float x;
        this.noCursor();
        this.frameRate(60.0f);
        this.randomSeed(1337387L);
        this.noiseSeed(1337387L);
        int i = 0;
        while (i < particlenum) {
            x = this.random(-640.0f, 640.0f);
            float y = this.random(-640.0f, 640.0f);
            float dx = this.random(-5.0f, 5.0f);
            float dy = this.random(-5.0f, 5.0f);
            this.particles[i] = new PVector(x, y);
            this.particle_v[i] = new PVector(dx, dy);
            ++i;
        }
        i = 0;
        while (i < rainnum) {
            x = this.random(-720.0f, 720.0f);
            float dx = this.random(-10.0f, 10.0f);
            float dy = this.random(30.0f, 100.0f);
            float hue = this.random(0.0f, 360.0f);
            float len = this.random(50.0f, 100.0f);
            this.dropx[i] = x;
            this.dropdir[i] = new PVector(dx, dy);
            this.dropcol[i] = hue;
            this.droplen[i] = len;
            ++i;
        }
        this.ml = Moonlander.initWithSoundtrack((PApplet)this, (String)"The_Polish_Ambassador_-_09_-_Fax_Travel.mp3", (int)120, (int)4);
        this.ml.start();
        this.post = this.loadShader("Post.glsl");
        this.neon = this.loadShader("Neon.glsl");
        this.glitch = this.loadShader("Glitch.glsl");
        this.frame = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.buffer = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.f = this.loadFont("YanoneKaffeesatz-Regular-48.vlw");
        i = 1;
        while (i <= 5) {
            PShape model;
            String name = "plato" + i + ".obj";
            this.platonics[i - 1] = model = this.loadShape(name);
            ++i;
        }
    }

    public void draw() {
        this.ml.update();
        this.frame.colorMode(3, 360.0f, 100.0f, 100.0f);
        int scene = (int)this.ml.getValue("scene");
        this.whiteout = (float)this.ml.getValue("whiteout");
        this.chroma_intens = (float)this.ml.getValue("chroma");
        this.bluramount = (float)this.ml.getValue("blurring");
        this.neon_intens = (int)this.ml.getValue("neon");
        this.display_noise = (float)this.ml.getValue("disp_noise");
        this.frame.beginDraw();
        this.frame.translate((float)this.width / 2.0f, (float)this.height / 2.0f);
        this.frame.scale((float)this.height / 720.0f);
        switch (scene) {
            case 1: {
                this.pulssi();
                break;
            }
            case 2: {
                this.platon();
                break;
            }
            case 3: {
                this.particles();
                break;
            }
            case 4: {
                this.platon();
                break;
            }
            case 5: {
                this.neon_rain();
                break;
            }
            case 6: {
                this.particles();
                break;
            }
            case 7: {
                this.platon();
                break;
            }
            case 8: {
                this.growing_terrain();
                break;
            }
            case 9: {
                this.platon();
                break;
            }
            case 10: {
                this.neon_rain();
                break;
            }
            case 11: {
                this.platon();
                break;
            }
            case 12: {
                this.exit();
            }
        }
        this.frame.endDraw();
        this.set_shader_params();
        this.buffer.beginDraw();
        this.buffer.image((PImage)this.frame, 0.0f, 0.0f);
        this.buffer.endDraw();
        this.buffer.beginDraw();
        if (this.chroma_intens > 0.0f || this.whiteout > 0.0f || this.bluramount > 0.0f) {
            this.buffer.shader(this.post);
            this.buffer.image((PImage)this.buffer, 0.0f, 0.0f);
        }
        this.buffer.endDraw();
        this.buffer.beginDraw();
        if ((float)this.neon_intens > 0.0f) {
            this.buffer.shader(this.neon);
            this.buffer.image((PImage)this.buffer, 0.0f, 0.0f);
        }
        this.buffer.endDraw();
        this.buffer.beginDraw();
        if (this.display_noise > 0.0f) {
            this.buffer.shader(this.glitch);
            this.buffer.image((PImage)this.buffer, 0.0f, 0.0f);
        }
        this.buffer.endDraw();
        this.image(this.buffer.get(), 0.0f, 0.0f);
    }

    public void set_shader_params() {
        this.post.set("whiteout", this.whiteout);
        this.post.set("chroma", this.chroma_intens);
        this.post.set("blur", this.bluramount);
        if (this.display_noise > 0.0f) {
            float start = PlatonicLove.map((float)this.noise(this.display_noise), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.99f);
            float str = PlatonicLove.map((float)this.noise(this.display_noise + 200.0f), (float)0.0f, (float)1.0f, (float)-0.1f, (float)0.1f);
            float len = PlatonicLove.map((float)this.noise(this.display_noise + 400.0f), (float)0.0f, (float)1.0f, (float)0.01f, (float)0.1f);
            len = PlatonicLove.constrain((float)len, (float)0.0f, (float)(1.0f - start));
            this.glitch.set("glitch_row", start);
            this.glitch.set("glitch_str", str);
            this.glitch.set("glitch_len", len);
        } else {
            this.post.set("glitch_row", -1.0f);
            this.post.set("glitch_str", 0.0f);
            this.post.set("glitch_len", 0.0f);
        }
        this.neon.set("strength", this.neon_intens);
    }

    public void pulssi() {
        float pulse = (float)this.ml.getValue("pulse") * 240.0f;
        float pulse_rev = (float)this.ml.getValue("pulse_rev");
        this.frame.background(255);
        this.frame.noFill();
        this.frame.stroke(0.0f, 0.0f, 1.0f);
        float weight = PlatonicLove.map((float)((float)this.ml.getValue("opening")), (float)0.0f, (float)1.0f, (float)48.0f, (float)720.0f);
        this.frame.strokeWeight(weight);
        this.frame.bezier(-680.0f, 0.0f, -120.0f, -pulse * pulse_rev, 120.0f, pulse * pulse_rev, 680.0f, 0.0f);
    }

    public void platon() {
        this.frame.background(0);
        float floor = (float)this.ml.getValue("floor");
        float scale = (float)this.ml.getValue("platon_scale");
        int platonic = (int)this.ml.getValue("platonic_idx");
        float rotx = (float)this.ml.getValue("platon_rotx");
        float roty = (float)this.ml.getValue("platon_roty");
        float rotz = (float)this.ml.getValue("platon_rotz");
        float scene_rot = (float)this.ml.getValue("scene_rot");
        float title_alpha = (float)this.ml.getValue("title_alpha");
        int credits = (int)this.ml.getValue("credits_idx");
        this.frame.textFont(this.f);
        this.frame.textSize(48.0f);
        this.frame.fill(0.0f, 0.0f, 100.0f, title_alpha);
        this.frame.text("Platonic Love", -96.0f, -100.0f, 360.0f);
        this.frame.textSize(8.0f);
        this.frame.fill(0.0f, 0.0f, 100.0f, 255.0f);
        switch (credits) {
            case 3: {
                this.frame.text("Music:", -80.0f, 20.0f, 540.0f);
                this.frame.text("Fax Travel by The Polish Ambassador", -80.0f, 30.0f, 540.0f);
            }
            case 2: {
                this.frame.text("Greets go to everyone at Graffathon 2018", -80.0f, 0.0f, 540.0f);
            }
            case 1: {
                this.frame.text("A production by ruuben", -80.0f, -20.0f, 540.0f);
            }
        }
        float zoom = (float)this.ml.getValue("platon_zoom");
        this.frame.translate(360.0f * zoom, 0.0f);
        this.frame.scale(zoom + 1.0f);
        this.frame.stroke(10.0f, 60.0f, 80.0f, floor);
        this.frame.strokeWeight(5.0f);
        this.frame.translate(0.0f, 0.0f, 450.0f);
        this.frame.rotateY(scene_rot);
        this.frame.translate(0.0f, 0.0f, -450.0f);
        this.frame.translate(0.0f, 40.0f, 400.0f);
        int i = 0;
        while (i <= 10) {
            this.frame.line((float)(-50 + 10 * i), 0.0f, 0.0f, (float)(-50 + 10 * i), 0.0f, 100.0f);
            this.frame.line(-50.0f, 0.0f, 0.0f + (float)(10 * i), 50.0f, 0.0f, (float)(0 + 10 * i));
            ++i;
        }
        if (platonic >= 1 && platonic <= 5) {
            this.frame.pushMatrix();
            this.frame.translate(0.0f, -50.0f, 50.0f);
            this.frame.resetShader();
            this.frame.lights();
            this.frame.pointLight(0.0f, 0.0f, 100.0f, -50.0f, -50.0f, 50.0f);
            this.frame.scale(scale);
            this.frame.rotateY(roty);
            this.frame.rotateZ(rotz);
            this.frame.rotateX(rotx);
            this.frame.shape(this.platonics[platonic - 1]);
            this.frame.noLights();
            this.frame.popMatrix();
        }
    }

    public void particles() {
        this.frame.background(255.0f);
        this.frame.strokeWeight(3.0f);
        this.frame.stroke(0.0f, 0.0f, 25.0f, 255.0f);
        this.frame.fill(0.0f, 0.0f, 10.0f, 255.0f);
        float t = (float)this.ml.getValue("particle_t");
        float noise = (float)this.ml.getValue("particle_noise");
        PVector[] displacement = new PVector[particlenum];
        int i = 0;
        while (i < particlenum) {
            if (noise > 0.0f) {
                float x = this.noise(i, 0.0f, t) * noise;
                float y = this.noise(i, 10.0f, t) * noise;
                displacement[i] = new PVector(x, y);
            } else {
                displacement[i] = new PVector(0.0f, 0.0f);
            }
            ++i;
        }
        i = 0;
        while (i < particlenum) {
            this.frame.ellipse(this.particles[i].x + t * this.particle_v[i].x + displacement[i].x, this.particles[i].y + t * this.particle_v[i].y + displacement[i].y, 10.0f, 10.0f);
            ++i;
        }
        this.frame.strokeWeight(2.0f);
        i = 0;
        while (i < particlenum) {
            int j = i;
            while (j < particlenum) {
                PVector pos1 = new PVector(this.particles[i].x + t * this.particle_v[i].x + displacement[i].x, this.particles[i].y + t * this.particle_v[i].y + displacement[i].y);
                PVector pos2 = new PVector(this.particles[j].x + t * this.particle_v[j].x + displacement[j].x, this.particles[j].y + t * this.particle_v[j].y + displacement[j].y);
                float distx = pos1.x - pos2.x;
                float disty = pos1.y - pos2.y;
                float dist = PlatonicLove.sqrt((float)(distx * distx + disty * disty));
                float a = PlatonicLove.map((float)(255.0f / dist), (float)1.0f, (float)3.0f, (float)0.0f, (float)255.0f);
                this.frame.stroke(0.0f, 0.0f, 25.0f, a);
                this.frame.line(pos1.x, pos1.y, pos2.x, pos2.y);
                ++j;
            }
            ++i;
        }
    }

    public void neon_rain() {
        this.frame.background(0.0f);
        this.frame.strokeWeight(1.5f);
        float t = (float)this.ml.getValue("drop_t");
        int i = 0;
        while (i < rainnum) {
            this.frame.stroke(this.dropcol[i], 60.0f, 100.0f, 255.0f);
            float x1 = this.dropx[i] + t * this.dropdir[i].x;
            float y1 = -360.0f + t * this.dropdir[i].y - (float)i * this.dropdir[i].y;
            float x2 = x1 - this.droplen[i] * this.dropdir[i].x;
            float y2 = y1 - this.droplen[i] * this.dropdir[i].y;
            this.frame.line(x1, y1, x2, y2);
            ++i;
        }
    }

    public void growing_terrain() {
        float t = (float)this.ml.getValue("terrain_t");
        float ampl = (float)this.ml.getValue("terrain_ampl");
        this.frame.background(0.0f);
        this.frame.stroke(10.0f, 60.0f, 80.0f, 16.0f);
        this.frame.strokeWeight(5.0f);
        this.frame.noFill();
        this.frame.pushMatrix();
        this.frame.translate(0.0f, 100.0f, 0.0f);
        this.frame.rotateY(0.3926991f);
        this.frame.rotateX(-0.3926991f);
        this.frame.translate(0.0f, 0.0f, 0.0f);
        int i = 0;
        while (i < 20) {
            this.frame.beginShape(18);
            int j = 0;
            while (j <= 20) {
                float h = -1.0f * this.noise(i, j, t) * ampl;
                this.frame.vertex(-400.0f + (float)(40 * i), h, -400.0f + (float)(40 * j));
                h = -1.0f * this.noise((float)i + 1.0f, j, t) * ampl;
                this.frame.vertex(-400.0f + (float)(40 * i) + 40.0f, h, -400.0f + (float)(40 * j));
                ++j;
            }
            this.frame.endShape();
            ++i;
        }
        this.frame.popMatrix();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"PlatonicLove"};
        if (passedArgs != null) {
            PApplet.main((String[])PlatonicLove.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

