int colors[] = {#FFEA81, #E8BD10, #D4C26A, #F5A3AD};

class Dibujo {
  int type = 0;  
  float angle;
  float size;
  color c1, c2;


  int cnt ;
  int cnt2;
  float fase ;
  float aspeed;
  Dibujo() {
    //psk++;
    type = int(random(3));

    float rdm1 = random(100, 200);
    c1 = color(rdm1, random(200, 255), rdm1);    
    c2 = color(200, 200, 100);

    cnt = 5;
    cnt2 = int(random(2, 4));
    fase = random(TWO_PI);
    aspeed = 0.05;
  }

  void display(float _size) {
    angle+=aspeed;
    pushMatrix();
    translate(0, 0, 0);
    strokeWeight(3);
    noStroke();
    fill(colors[1]);
    dibujar(_size);
    popMatrix();
  }

  void dibujar(float _size) {

    box(_size);
  }

  //FORMAS BASICAS : 
  void torre(float _size, int cnt) {
    pushMatrix();
    for (int i=0; i<cnt; i++) {
      box(_size/2); 
      translate(0, 0, _size/2);
    }
    popMatrix();
  }
}  


//EL CHOBI??
class Translator extends Dibujo {

  float freq;
  color  [] cols;
  Translator() {
    super();
    cnt = int(random(5, 12));
    cnt2 = int(random(4, 8));
    cols = new color[cnt2];

    for (int k=0; k<cnt2; k++) {
      float amar = random(100, 255);
      cols[k] = color(amar, amar, random(20, 80));
    }

    aspeed = random(0.1);
    //freq =random(TWO_PI,TWO_PI*2);
    freq =PI;
  }

  void dibujar(float _size) {
    //super.dibujar(_size);
    float BS =  _size / 5;
    pushMatrix();
    translate(0, 0, _size/4);
    for (int k = 0; k<cnt2; k++) {
      pushMatrix(); 
      translate(0, 0, map(k, 0, cnt2-1, 0, sin(angle)*_size/2 +_size/2));
      translate(0, 0, 0);
      fill(cols[k]);
      for (int i=0; i < cnt; i++) {
        pushMatrix();
        float PX = sin(map(i, 0, cnt-1, 0, TWO_PI))*_size/2*map(k, 0, cnt2-1, 1, 0);
        float PY = cos(map(i, 0, cnt-1, 0, TWO_PI))*_size/2*map(k, 0, cnt2-1, 1, 0 );
        translate(PX, PY, 0);
        box(BS);
        popMatrix();
      }
      popMatrix();
    }
    popMatrix();
  }
}
class Fuente extends Dibujo {

  ArrayList<Particle> particles;
  Fuente() {
    super();

    float amar = random(100, 255);
    c1 = color(amar, amar, random(20, 80));
    particles = new ArrayList<Particle>();
    c2 = color(amar*random(1),amar,0);
  }

  void dibujar(float _size) {
    pushMatrix();

    fill(c1);
    translate(0, 0, _size/4);
    box(_size/2);
    translate(0, 0, _size/4);
    fill(200, 200, 0);
    box(_size/8);
    popMatrix();
    if (random(1) < 0.6) {
      particles.add(new Particle(_size));
    }
    for (int i=0; i<particles.size(); i++) {
      Particle p = particles.get(i);
      p.run();
      if (p.life < 0) {
        particles.remove(p);
      }
    }
    fill(c2);
    
    float amp = 0.4;
    float fixed= 1;
    pushMatrix(); 
    translate((_size/2-_size/4)*(sin(angle+TWO_PI * 1/4)*amp+fixed),0,_size/4);
    box(_size/4);
    popMatrix();
    
    pushMatrix();
    translate((-_size/2+_size/4)*(sin(angle+TWO_PI * 2/4)*amp+fixed),0,_size/4);
    box(_size/4);
    popMatrix();
    
    pushMatrix();
    translate(0,(_size/2-_size/4)*(sin(angle+TWO_PI * 3/4)*amp+fixed),_size/4);
    box(_size/4);
    popMatrix();
    
    pushMatrix();
    translate(0,(-_size/2+_size/4)*(sin(angle+TWO_PI * 4/4)*amp+fixed),_size/4);
    box(_size/4);
    popMatrix();
  
  }
}
class Generator extends Dibujo {

  //Color de la energia;
  color c3 = #FFFF11;
  float rdm ;
  Generator() {
    super();
    cnt = int(random(5, 10));
    c1 = color(#38A733);
    c2 = color(#FFD4AA);
    rdm = 2;
  }

  void dibujar(float _size) {
    torre(_size, cnt);
  }

  void torre(float _size, int cnt) {
    pushMatrix();
    translate(0, 0, _size/2);
    for (int i=0; i<cnt; i++) {
      color fin = lerpColor(c1, c2, norm(i, 0, cnt));

      fin = lerpColor(fin, c3, sin(-angle+map(i, 0, cnt, 0, TWO_PI)*0.5+0.5+fase));
      fill(fin);
      box(_size/2*map(i, 0, cnt, 1, 0)); 
      translate(0, 0, _size/4);
    }
    fill(c3);

    pushMatrix();
    translate(random(-rdm, rdm), random(-rdm, rdm), random(-rdm, rdm));
    sphere(_size/10);
    popMatrix();
    popMatrix();
  }
}

class Bosque extends Dibujo {

  int cnt ;
  PVector [] pos ;

  color  [] cols; 
  color  [] cols2; 
  int [] cnt2 ;
  Bosque() {

    super();
    cnt = int(random(5, 30));
    pos = new PVector[cnt];
    cols = new color[cnt];
    cols2 = new color[cnt];
    cnt2 = new int[cnt];
    for (int i=0; i<pos.length; i++) {
      pos[i] = new PVector(random(-1, 1), random(-1, 1));

      float rdm8 = random(100, 200);
      cols[i] =  color(rdm8, rdm8, rdm8-rdm8/2);
      cols2[i] = color(rdm8/2, rdm8+random(100, 255), rdm8/3);
      cnt2[i] = int(random(1, 4));
    }
  }

  void dibujar(float _size) {
    fill(colors[3]);
    pushMatrix();
    translate(0, 0, _size/4);
    for (int i =0; i<pos.length; i++) { 
      pushMatrix();
      translate(pos[i].x*_size/2, pos[i].y*_size/2, 0);
      fill(cols[i]);
      torre(cols[i], cols2[i], _size, cnt2[i]);
      popMatrix();
    }
    popMatrix();
  }

  //FORMAS BASICAS : 
  void torre(color c1, color c2, float _size, int cnt) {
    pushMatrix();
    for (int i=0; i<cnt; i++) {
      fill(lerpColor(c1, c2, map(i, 0, cnt, 0, 1)));
      box(_size/6); 
      translate(0, 0, _size/6);
    }
    popMatrix();
  }
}