#version 450
#define GRID

layout (local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

layout(std430, binding = 1) buffer points {
	vec4 position[];
};

uniform int nbPoints;

void main() {
#if defined(CIRCLE)
	float u = float(gl_WorkGroupID.x) / nbPoints;
	vec3 p = vec3(sin(2.0 * 3.141592 * u), 0.0, cos(2.0 * 3.141592 * u));
	position[gl_WorkGroupID.x].xyz = p;
#elif defined(GRID)
	float u = float(gl_WorkGroupID.x) / nbPoints;
	float lines = sqrt(nbPoints);
	vec3 p = vec3(fract(u * lines) * 2.0 - 1.0, floor(u * lines) / lines * 2.0 - 1.0, 0.0) * 5.0;
	position[gl_WorkGroupID.x].xyz = p;
#endif
}
