#version 450 core
#include "include/random.inc.glsl"

layout (points) in;
layout (triangle_strip, max_vertices = 3) out;

#include "include/AppInfo-ubo.inc.glsl"
#include "include/GameState-ssbo.inc.glsl"

uniform mat4 model;

in vec3 vColor[];
out vec3 fColor;
out vec3 fNormal_cs;
out vec3 fPosition_cs;
out vec3 toLight_cs;

void main() {
	vec4 p0 = gl_in[0].gl_Position;
	vec4 p1 = p0;
	vec4 p2 = p0;

	vec3 triy = noised(p0.xyz).xyz;
	vec3 triz = vec3(0.0, 0.0, 1.0);
	vec3 trix = normalize(cross(triy, triz));
	triz = normalize(cross(trix, triy));

	p0.xyz += -0.1 * trix - 0.1 * triz;
	p1.xyz += 0.1 * trix - 0.1 * triz;
	p2.xyz += 0.1 * triz;

	fNormal_cs = mat3(game.viewMatrix * model) * triz;
	toLight_cs = mat3(game.viewMatrix * model) * vec3(0.0, 1.0, 0.0);
	fPosition_cs = (game.viewMatrix * model * p0).xyz;
    gl_Position = game.projMatrix * game.viewMatrix * model * p0;
    gl_PointSize = 2;
    fColor = vColor[0];
    //fColor = vec3(0.f, 0.2f, 0.8f);
    EmitVertex();

    fPosition_cs = (game.viewMatrix * model * p1).xyz;
    gl_Position = game.projMatrix * game.viewMatrix * model * p1;
    gl_PointSize = 2;
    fColor = vColor[0];
    fColor = vec3(0.f, 0.2f, 0.8f);
    EmitVertex();

    fPosition_cs = (game.viewMatrix * model * p2).xyz;
    gl_Position = game.projMatrix * game.viewMatrix * model * p2;
    gl_PointSize = 2;
    fColor = vColor[0];
    fColor = vec3(0.f, 0.2f, 0.8f);
    EmitVertex();

    EndPrimitive();
}
