#version 450
#include "include/random.inc.glsl"

layout (local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

layout(std430, binding = 1) buffer points {
	vec4 position[];
};

#include "include/AppInfo-ubo.inc.glsl"
#include "include/GameState-ubo.inc.glsl"

float rand(in vec2 p) {
    return fract(sin(dot(p.xy,vec2(12.9898,78.233)))*43758.5453123);
}

vec2 rand2(in vec2 p) {
	float x = rand(p);
    float y = fract(sin(dot(p.xy,vec2(314.1592,21.7)))*53123.43758);
    return vec2(x, y);
}

// replace this by something better. really. do
vec3 rand33( vec3 p ) {
	p = vec3( dot(p,vec3(127.1,311.7, 74.7)),
			  dot(p,vec3(269.5,183.3,246.1)),
			  dot(p,vec3(113.5,271.9,124.6)));
	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise(in vec2 p) {
    vec2 i = floor(p);
    vec2 f = fract(p);
    float a = rand(i + vec2(0., 0.));
    float b = rand(i + vec2(1., 0.));
    float c = rand(i + vec2(0., 1.));
    float d = rand(i + vec2(1., 1.));
    vec2 u = f * f * (3.0 - 2.0 * f);
    return mix(mix(a, b, u.x), mix(c, d, u.x), u.y);
}

 	

#define OCTAVES 2
float fbm(in vec2 p) {
    // Initial values
    float value = 0.0;
    float amplitude = .5;
    float frequency = 0.;
    //
    // Loop of octaves
    for (int i = 0; i < OCTAVES; i++) {
        value += amplitude * noise(p);
        p *= 2.;
        amplitude *= .5;
    }
    return value;
}

void main() {
	vec3 pos = position[gl_WorkGroupID.x].xyz;

	float dt = 1.f/60.f;
	vec4 n = noised(pos);
    n.w *= exp(-100 * iTime);
	vec3 v = n.xyz * n.w;
	v += cross(vec3(0.0, 0.0, 1.0),  pos) * 0.5;
	//v -= pos * 0.01;

	vec3 dp = v * dt;
	pos += dp;

	position[gl_WorkGroupID.x].xyz = pos;
}
