#version 450 core
#include "sys:defines"

layout (location = 0) out vec4 color;

#include "include/AppInfo-ubo.inc.glsl"
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform float alpha2 = 1.0;

#include "include/utils.inc.glsl"
#include "include/tiles.inc.glsl"

void main() {
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
	vec4 layer0 = texture(iChannel0, uv);
	vec4 layer1 = texture(iChannel1, uv);
	vec4 layer2 = texture(iChannel2, uv);
	color = mix(layer0, vec4(1.0), layer1.r);
	color += layer2 * 1.25 * alpha2;
	//color = texture(iChannel0, uv) * 1.0 + texture(iChannel1, uv) * (-1.0) + texture(iChannel2, uv) * 0.2;
	//color = texture(iChannel0, uv) * 1.0 + texture(iChannel1, uv) * (-1.0) + texture(iChannel2, uv) * 1.25;
	//color = max(vec4(0.0), color);
	
	//float unsurdeux = mod(length(uv - vec2(0.5)) * 10.0, 2.0);
	//float unsurdeux = mod(length((uv - vec2(0.25,  0.5)) * vec2(1.0,  1.7)) * 10.0, 2.0);
	//color = mix(sienne, grey, unsurdeux) * 0.5;
	//color.rgb *= mix(redsienne, sienne, unsurdeux);
}
