#version 450 core

layout (location = 0) out vec4 color;

#include "include/AppInfo-ubo.inc.glsl"
#include "include/GameState-ubo.inc.glsl"
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

out vec3 outColor;

void main() {
    vec2 uv = gl_FragCoord.xy / iResolution.xy * 2.0;
    vec2 step = vec2(1.0) / iResolution.xy;
    outColor = (
    	texture(iChannel0, uv + step * vec2(0.0, 0.0)).rgb +
    	texture(iChannel0, uv + step * vec2(1.0, 0.0)).rgb +
    	texture(iChannel0, uv + step * vec2(0.0, 1.0)).rgb +
    	texture(iChannel0, uv + step * vec2(1.0, 1.0)).rgb
	) * 0.25;
}
