#include "common.glsl"


// ------------------------------------------------------------------------------------------------
//                              Wrap de cosas GLSL <-> GLSL ES
// ------------------------------------------------------------------------------------------------

#ifndef GL_ES

  #define at_VertexCoords           gl_Vertex
  #define at_Normal                 gl_Normal
  #define at_MultiTexCoord0         gl_MultiTexCoord0
  #define at_MultiTexCoord1         gl_MultiTexCoord1

#else

  attribute highp vec4 at_VertexCoords ;
  attribute highp vec3 at_Normal ;
  attribute highp vec4 at_MultiTexCoord0 ;
  attribute highp vec4 at_MultiTexCoord1 ;

#endif


  
// ------------------------------------------------------------------------------------------------
//                                       Atributos
// ------------------------------------------------------------------------------------------------

attribute highp vec4 joint_weights ;
attribute highp vec4 joint_indices ;




// ------------------------------------------------------------------------------------------------
//                                       Funciones
// ------------------------------------------------------------------------------------------------



// ------------------------------------------------------------------------------------------------
//
//
void ProcesarIluminacion(vec4 vertice, vec3 normal)
{

  highp vec3 emi = g_DatosMaterial.emission ;




  highp float invEmi = min( (1.0-(length(emi)*0.25)), 1.0) ;

  if ( invEmi > 0.0 ) {

    highp vec3 diffuse_acumulado = vec3(0.0, 0.0, 0.0) ;
    highp vec3 specular_acumulado = vec3(0.0, 0.0, 0.0) ;

    highp vec3 light_normal = normalize(normal) ;

    highp vec3 spe = g_DatosMaterial.specular ;
    highp float speVal = length(spe) ;

    highp vec3 posicion_camara = posicion_camara_world ;
    highp vec3 normalized_vertex_to_camera = vec3(0.0, 0.0, 0.0) ;

    if(speVal > 0.0) {

      normalized_vertex_to_camera = normalize(posicion_camara - vertice.xyz) ;
    }

    for(int var_luz = 0; var_luz < MAX_LIGHTS; var_luz++) {

      lowp int lightType = g_Lights[var_luz].type ;

      if(lightType == LIGHT_TYPE_NONE) {
      }
      else {

        // intensidad inicial
        highp float light_intensity ;
        highp vec3 normalized_vertex_to_light ;
        highp float normal_dot_light_vector ;

        if(lightType == LIGHT_TYPE_SPOT) {

          // direccion de la luz en el vertice
          highp vec3 vertex_to_light = g_Lights[var_luz].position - vertice.xyz ;
          normalized_vertex_to_light = normalize(vertex_to_light) ;
          normal_dot_light_vector = dot(light_normal, normalized_vertex_to_light) ;

          if(normal_dot_light_vector <= 0.0) continue ;

          // calculo de intensidad segun las atenuaciones
          const highp float baseConeAngle = 180.0 ;
          highp float angle = baseConeAngle - (dot(g_Lights[var_luz].direction, normalized_vertex_to_light) * baseConeAngle) ;
          light_intensity = smoothstep(g_Lights[var_luz].falloff, g_Lights[var_luz].hotspot_beam, angle) ;
        }
        else if(lightType == LIGHT_TYPE_POINT) {

          // direccion de la luz en el vertice
          highp vec3 vertex_to_light = g_Lights[var_luz].position - vertice.xyz ;
          normalized_vertex_to_light = normalize(vertex_to_light) ;
          normal_dot_light_vector = dot(light_normal, normalized_vertex_to_light) ;

          if(normal_dot_light_vector <= 0.0) continue ;

          // calculo de intensidad segun las atenuaciones
          highp float lightDist = length(vertex_to_light);
          light_intensity = smoothstep(g_Lights[var_luz].attenuation_end, g_Lights[var_luz].attenuation_start, lightDist);
        } 
        else /*if(lightType == LIGHT_TYPE_DIRECTIONAL)*/ {

          // direccion de la luz en el vertice
          normalized_vertex_to_light = g_Lights[var_luz].direction ;
          normal_dot_light_vector = dot(light_normal, normalized_vertex_to_light) ;

          if(normal_dot_light_vector <= 0.0) continue ;

          // intensidad fija
          light_intensity = 1.0 ;
        }

        // si tenemos intensidad...
        if(light_intensity <= 0.0) continue ;
        {

          // color e intensidad de la luz
          highp vec3 lightColor = g_Lights[var_luz].diffuse.rgb * light_intensity ;

#ifdef ACTIVAR_DIFFUSE
          {
            // --------------------------------------------------------------------
            // Diffuse

            // no usamos el 'diffuse' del material se usara la textura en el fragment
            diffuse_acumulado += lightColor * normal_dot_light_vector ;

            // --------------------------------------------------------------------
          }
#endif

#ifdef ACTIVAR_SPECULAR

          {
            // --------------------------------------------------------------------
            // Specular

            // To compute the specular component we must first normalize the halfvector we received from the vertex shader, 
            // and also compute the dot product between the normalized halfvector and the normal.

            if(speVal > 0.0) {

              highp vec3 halfAngle = normalize(normalized_vertex_to_camera + normalized_vertex_to_light) ;
              highp float normal_dot_halfvector = dot(light_normal, halfAngle) ;

              // por debajo de un valor, con el exponente queda casi 0.0
              if(normal_dot_halfvector >= 0.25) {

                normal_dot_halfvector = pow(normal_dot_halfvector,64.0);
                specular_acumulado += lightColor * spe * normal_dot_halfvector ;
              }
            }

            // --------------------------------------------------------------------
          }
#endif
        }
      }
    }

    // intensidad final de la luz en el vertice
    light_final_intensity = (((diffuse_acumulado + g_LightModel.ambient + specular_acumulado) * invEmi) + emi) * 1.0 ;
    light_final_specular = specular_acumulado * (invEmi*0.5) ;
  }
  else {

    // intensidad de luz con solo emision
    light_final_intensity = emi ;
    light_final_specular = vec3(0.0, 0.0, 0.0) ;
  }
}




// ------------------------------------------------------------------------------------------------
//
//
void ProcesarTexturas()
{
  // --------------------------------------------------------------------------
  // Texturas
  // --------------------------------------------------------------------------

  text_coord[0] = vec2(at_MultiTexCoord0) + g_DatosMaterial.offset_animacion0 ;
  text_coord[1] = vec2(at_MultiTexCoord1) + g_DatosMaterial.offset_animacion1 ;       // Slo si NUMERO_MAXIMO_TEXTURAS_POR_MATERIAL > 1 ... Cmo podramos meterlo en un bucle?
}





// http://www.lighthouse3d.com/tutorials/glsl-tutorial/directional-lights-ii/
//
//  // --------------------------------------------------------------------------
//  // Iluminacin
//  // --------------------------------------------------------------------------
//
//  if(Light0.type != LIGHT_TYPE_NONE) {
//  
//    vec3 vert = vec3(WorldMatrix * at_VertexCoords) ;
//    normal = NormalMatrix * at_Normal;
//    lightVec = vec3(Light0.position/*lightPos*/ - vert) ;
//    viewVec = -vec3(1, 0, 0/*vert*/) ;         // Hay que calcular el vector de direccin de la luz en el programa y pasarlo!
//  }



/*
uniform highp float algo1 ;

// ------------------------------------------------------------------------------------------------
//
//
void Debug_HangVertexShader()
{
  int algo = 5 ;

  for(int var1 = 6; var1 > int(algo1); var1++) {

    gl_Position = ModelViewProjectionMatrix * vec4(at_VertexCoords.xyz, 1.0) ;
  }
}
*/

