/*
 * Decompiled with CFR 0.152.
 */
package z80emu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import z80emu.Z80InterruptSource;
import z80emu.Z80SIOChannelListener;

public class Z80SIO
implements Z80InterruptSource {
    private static final int RECEIVER_INTERRUPT = 1;
    private static final int SENDER_INTERRUPT = 2;
    private static final int EXTERNAL_INTERRUPT = 4;
    private static final int RECV_BUFFER_FILLED = 256;
    private static final int RECV_FIFO_OVERRUN = 512;
    private static final int RR0_CHAR_RECEIVED = 1;
    private static final int RR0_INTERRUPT_PENDING = 2;
    private static final int RR0_SENDER_BUFFER_EMPTY = 4;
    private static final int RR0_DCD = 8;
    private static final int RR0_SYNC = 16;
    private static final int RR0_CTS = 32;
    private static final int RR0_TX_UNDERRUN_EOM = 64;
    private static final int RR0_BREAK_ABORT = 128;
    private static final int RR1_SENDER_EMPTY = 1;
    private static final int RR1_PARITY_ERROR = 16;
    private static final int RR1_RX_OVERRUN_ERROR = 32;
    private static final int RR1_FRAMING_ERROR = 64;
    private static final int RR1_END_OF_FRAME = 128;
    private static final int WR_SET = 256;
    private static final int WR1_EXTERNAL_INTERRUPT_ENABLED = 1;
    private static final int WR1_SENDER_INTERRUPT_ENABLED = 2;
    private static final int WR1_STATUS_AFFECTS_VECTOR = 4;
    private static final int WR3_RX_ENABLED = 1;
    private static final int WR4_PARITY_ENABLED = 1;
    private static final int WR5_TX_ENABLED = 8;
    private static final String TEXT_NOT_INITIALIZED = "nicht initialisiert";
    private static final String TEXT_SENDER_INTERRUPT = "Sender-Interrupt";
    private static final String TEXT_EXTERNAL_INTERRUPT = "Externer Status-Interrupt";
    private String title;
    private Channel a;
    private Channel b;
    private Channel[] channels;

    public Z80SIO(String string) {
        this.title = string;
        this.a = new Channel(0);
        this.b = new Channel(1);
        this.channels = new Channel[]{this.a, this.b};
    }

    public void addChannelListener(Z80SIOChannelListener z80SIOChannelListener, int n) {
        if (n >= 0 && n < this.channels.length) {
            Channel channel = this.channels[n];
            if (channel.listeners == null) {
                channel.listeners = new ArrayList();
            }
            channel.listeners.add(z80SIOChannelListener);
        }
    }

    public int availableA() {
        return this.a.available();
    }

    public int availableB() {
        return this.b.available();
    }

    public boolean isReadyReceiverA() {
        return this.a.isReadyReceiver();
    }

    public boolean isReadyReceiverB() {
        return this.b.isReadyReceiver();
    }

    public void clockPulseReceiverA() {
        this.a.clockPulseReceiver();
    }

    public void clockPulseReceiverB() {
        this.b.clockPulseReceiver();
    }

    public void clockPulseSenderA() {
        this.a.clockPulseSender();
    }

    public void clockPulseSenderB() {
        this.b.clockPulseSender();
    }

    public void putToReceiverA(int n) {
        this.a.putToReceiver(n);
    }

    public void putToReceiverB(int n) {
        this.b.putToReceiver(n);
    }

    public void removeChannelListener(Z80SIOChannelListener z80SIOChannelListener, int n) {
        Channel channel;
        if (n >= 0 && n < this.channels.length && (channel = this.channels[n]).listeners != null) {
            channel.listeners.remove(z80SIOChannelListener);
        }
    }

    public int readControlA() {
        return this.a.readControl();
    }

    public int readControlB() {
        return this.b.readControl();
    }

    public int readDataA() {
        return this.a.readData();
    }

    public int readDataB() {
        return this.b.readData();
    }

    public void setClearToSendA(boolean bl) {
        this.a.setCTS(bl);
    }

    public void setClearToSendB(boolean bl) {
        this.b.setCTS(bl);
    }

    public void setDataCarrierDetectA(boolean bl) {
        this.a.setDCD(bl);
    }

    public void setDataCarrierDetectB(boolean bl) {
        this.b.setDCD(bl);
    }

    public void writeControlA(int n) {
        this.a.writeControl(n);
    }

    public void writeControlB(int n) {
        this.b.writeControl(n);
    }

    public void writeDataA(int n) {
        this.a.writeData(n);
    }

    public void writeDataB(int n) {
        this.b.writeData(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        Object object;
        int n;
        stringBuilder.append("<table border=\"1\">\n<tr><th></th><th>Kanal&nbsp;A</th><th>Kanal&nbsp;B</th></tr>\n<tr><td>Vorteiler:</td>");
        for (n = 0; n < this.channels.length; ++n) {
            stringBuilder.append("<td>");
            object = TEXT_NOT_INITIALIZED;
            int n2 = this.channels[n].wr[4];
            if (n2 >= 0) {
                switch (n2 & 0xC0) {
                    case 64: {
                        object = "16";
                        break;
                    }
                    case 128: {
                        object = "32";
                        break;
                    }
                    case 192: {
                        object = "64";
                    }
                }
            }
            stringBuilder.append((String)object);
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr>\n<td valign=\"top\">Empf&auml;nger:</td>\n");
        for (n = 0; n < this.channels.length; ++n) {
            stringBuilder.append("<td valign=\"top\">\n");
            object = this.channels[n];
            if (((Channel)object).wr[3] >= 0 && ((Channel)object).wr[4] >= 0) {
                stringBuilder.append(((Channel)object).getRxDataBitCount());
                stringBuilder.append(" Bits pro Zeichen<br/>\nEmpfang");
                if ((((Channel)object).wr[3] & 1) != 0) {
                    stringBuilder.append(" freigegeben");
                } else {
                    stringBuilder.append(" gesperrt");
                }
                stringBuilder.append("<br/>\n");
                if (((Channel)object).recvClocksRemain > 0) {
                    stringBuilder.append("Zeichen wird gerade empfangen...<br/>\n");
                }
                stringBuilder.append("Empfangspuffer");
                Object object2 = object;
                synchronized (object2) {
                    int n3 = ((Channel)object).recvFifoLen;
                    if (n3 > 0) {
                        stringBuilder.append(':');
                        for (int i = 0; i < n3; ++i) {
                            if (i > 0) {
                                stringBuilder.append(',');
                            }
                            int n4 = ((Channel)object).recvFifo[n];
                            stringBuilder.append(String.format(" %02Xh", n4 & 0xFF));
                            if ((n4 & 0x200) == 0) continue;
                            stringBuilder.append(" overrun");
                        }
                    } else {
                        stringBuilder.append(" leer");
                    }
                }
                stringBuilder.append("<br/>\nInterrupt");
                switch (((Channel)object).wr[1] & 0x18) {
                    case 8: {
                        if (((Channel)object).recvNextInterruptEnabled) {
                            stringBuilder.append(" freigegeben f&uuml;r ersten/n&auml;chstes Zeichen");
                            break;
                        }
                        stringBuilder.append(" freigegeben f&uuml;r ersten Zeichen (schon vorbei)");
                        break;
                    }
                    case 16: 
                    case 24: {
                        stringBuilder.append(" freigegeben f&uuml;r jedes Zeichen");
                        break;
                    }
                    default: {
                        stringBuilder.append(" gesperrt");
                    }
                }
                if ((((Channel)object).interruptAccepted & 1) != 0) {
                    stringBuilder.append("<br/>\nInterrupt angenommen");
                }
                if ((((Channel)object).interruptRequest & 1) != 0) {
                    stringBuilder.append("<br/>\nInterrupt angemeldet");
                }
            } else {
                stringBuilder.append(TEXT_NOT_INITIALIZED);
            }
            stringBuilder.append("\n</td>\n");
        }
        stringBuilder.append("</tr>\n<tr>\n<td valign=\"top\">Sender:</td>\n");
        for (n = 0; n < this.channels.length; ++n) {
            stringBuilder.append("<td valign=\"top\">\n");
            object = this.channels[n];
            if (((Channel)object).wr[4] >= 0 && ((Channel)object).wr[5] >= 0) {
                stringBuilder.append(((Channel)object).getTxDataBitCount());
                stringBuilder.append(" Bits pro Zeichen<br/>\nSenden");
                if ((((Channel)object).wr[5] & 8) != 0) {
                    stringBuilder.append(" freigegeben");
                } else {
                    stringBuilder.append(" gesperrt");
                }
                stringBuilder.append("<br/>\n");
                if ((((Channel)object).rr[0] & 4) != 0) {
                    stringBuilder.append("Puffer leer");
                } else {
                    stringBuilder.append(String.format("Byte %02Xh im Puffer", ((Channel)object).sendBuf));
                    if (((Channel)object).sendClocksRemain > 0) {
                        stringBuilder.append(", wird gerade gesendet...");
                    }
                }
                stringBuilder.append("<br/>\nSender-Interrupt");
                stringBuilder.append((((Channel)object).wr[1] & 2) != 0 ? " freigegeben" : " gesperrt");
                if ((((Channel)object).interruptAccepted & 2) != 0) {
                    stringBuilder.append("<br/>\nSender-Interrupt angenommen");
                }
                if ((((Channel)object).interruptRequest & 2) != 0) {
                    stringBuilder.append("<br/>\nSender-Interrupt angemeldet");
                }
                stringBuilder.append("<br/>\nExterner Status-Interrupt");
                stringBuilder.append((((Channel)object).wr[1] & 1) != 0 ? " freigegeben" : " gesperrt");
                if ((((Channel)object).interruptAccepted & 4) != 0) {
                    stringBuilder.append("<br/>\nExterner Status-Interrupt angenommen");
                }
                if ((((Channel)object).interruptRequest & 4) != 0) {
                    stringBuilder.append("<br/>\nExterner Status-Interrupt angemeldet");
                }
            } else {
                stringBuilder.append(TEXT_NOT_INITIALIZED);
            }
            stringBuilder.append("\n</td>\n");
        }
        stringBuilder.append("</tr>\n<tr><td>Interrupt-Vektor:</td><td colspan=\"2\">");
        if (this.b.wr[2] >= 0) {
            stringBuilder.append(String.format("%02Xh", this.getInterruptVector()));
            if ((this.b.wr[1] & 4) != 0) {
                stringBuilder.append(" (ver&auml;ndert)");
            }
        } else {
            stringBuilder.append("nicht gesetzt");
        }
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public synchronized int interruptAccept() {
        int n = this.getInterruptVector();
        if ((this.a.interruptAccepted & 1) == 0 && (this.a.interruptRequest & 1) != 0) {
            this.a.interruptAccepted |= 1;
            this.a.interruptRequest &= -2;
        } else if ((this.a.interruptAccepted & 2) == 0 && (this.a.interruptRequest & 2) != 0) {
            this.a.interruptAccepted |= 2;
            this.a.interruptRequest &= -3;
        } else if ((this.a.interruptAccepted & 4) == 0 && (this.a.interruptRequest & 4) != 0) {
            this.a.interruptAccepted |= 4;
            this.a.interruptRequest &= -5;
        } else if ((this.b.interruptAccepted & 1) == 0 && (this.b.interruptRequest & 1) != 0) {
            this.b.interruptAccepted |= 1;
            this.b.interruptRequest &= -2;
        } else if ((this.b.interruptAccepted & 2) == 0 && (this.b.interruptRequest & 2) != 0) {
            this.b.interruptAccepted |= 2;
            this.b.interruptRequest &= -3;
        } else if ((this.b.interruptAccepted & 4) == 0 && (this.b.interruptRequest & 4) != 0) {
            this.b.interruptAccepted |= 4;
            this.b.interruptRequest &= -5;
        }
        return n;
    }

    @Override
    public synchronized void interruptFinish() {
        if ((this.a.interruptAccepted & 1) != 0) {
            this.a.interruptAccepted &= -2;
        } else if ((this.a.interruptAccepted & 2) != 0) {
            this.a.interruptAccepted &= -3;
        } else if ((this.a.interruptAccepted & 4) != 0) {
            this.a.interruptAccepted &= -5;
        } else if ((this.b.interruptAccepted & 1) != 0) {
            this.b.interruptAccepted &= -2;
        } else if ((this.b.interruptAccepted & 2) != 0) {
            this.b.interruptAccepted &= -3;
        } else if ((this.b.interruptAccepted & 4) != 0) {
            this.b.interruptAccepted &= -5;
        }
    }

    @Override
    public boolean isInterruptAccepted() {
        return (this.a.interruptAccepted & 7) != 0 || (this.b.interruptAccepted & 7) != 0;
    }

    @Override
    public boolean isInterruptRequested() {
        return (this.a.interruptRequest & 7) != 0 || (this.b.interruptRequest & 7) != 0;
    }

    @Override
    public void reset(boolean bl) {
        this.a.reset(bl);
        this.b.reset(bl);
    }

    public String toString() {
        return this.title;
    }

    private synchronized void fireByteAvailable(Channel channel, int n) {
        if (channel.listeners != null) {
            for (Z80SIOChannelListener z80SIOChannelListener : channel.listeners) {
                z80SIOChannelListener.z80SIOByteSent(this, channel.channelNum, n);
            }
        }
    }

    private int getInterruptVector() {
        int n = this.b.wr[2] & 0xFF;
        if (this.b.wr[1] >= 0 && (this.b.wr[1] & 4) != 0) {
            int n2 = 6;
            if ((this.a.interruptRequest & 1) != 0) {
                n2 = this.a.isSpecialReceiveCondition() ? 14 : 12;
            } else if ((this.a.interruptRequest & 2) != 0) {
                n2 = 8;
            } else if ((this.a.interruptRequest & 4) != 0) {
                n2 = 10;
            } else if ((this.b.interruptRequest & 1) != 0) {
                n2 = this.b.isSpecialReceiveCondition() ? 6 : 4;
            } else if ((this.b.interruptRequest & 2) != 0) {
                n2 = 0;
            } else if ((this.b.interruptRequest & 4) != 0) {
                n2 = 2;
            }
            n &= 0xF1;
            n |= n2;
        }
        return n;
    }

    private void setInterruptPending() {
        int[] nArray = this.a.rr;
        nArray[0] = nArray[0] | 2;
    }

    private class Channel {
        private int channelNum;
        private int interruptAccepted;
        private int interruptRequest;
        private boolean recvNextInterruptEnabled;
        private int recvBuf;
        private int recvClockDiv;
        private int recvClocksRemain;
        private int[] recvFifo;
        private int recvFifoLen;
        private int sendBuf;
        private int sendClockDiv;
        private int sendClocksRemain;
        private int[] rr;
        private int[] wr;
        private Boolean cts;
        private Boolean dcd;
        private Collection<Z80SIOChannelListener> listeners;

        private Channel(int n) {
            this.channelNum = n;
            this.recvFifo = new int[3];
            this.rr = new int[2];
            this.wr = new int[8];
            this.cts = null;
            this.dcd = null;
            this.listeners = null;
            this.reset(true);
        }

        private int available() {
            return this.recvFifoLen;
        }

        private void checkRequestExternalInterrupt(Boolean bl, boolean bl2) {
            if (bl != null && (this.wr[1] & 1) != 0 && bl2 != bl) {
                this.interruptRequest |= 4;
                Z80SIO.this.setInterruptPending();
            }
        }

        private synchronized void clockPulseReceiver() {
            if (this.wr[3] > 0 && this.wr[4] > 0) {
                if (this.recvClockDiv == 0) {
                    this.recvClockDiv = this.getClockDiv() - 1;
                }
                if (this.recvClockDiv > 0) {
                    --this.recvClockDiv;
                }
                if (this.recvClockDiv == 0) {
                    if (this.recvClocksRemain == 0 && (this.wr[3] & 1) != 0 && (this.recvBuf & 0x100) != 0) {
                        this.recvClocksRemain = this.getRxDataBitCount() + this.getParityAndStopBitCount();
                    }
                    if (this.recvClocksRemain > 0) {
                        --this.recvClocksRemain;
                        if (this.recvClocksRemain == 0) {
                            int n = this.recvBuf & 0xFF;
                            this.recvBuf = 0;
                            switch (this.wr[3] & 0xC0) {
                                case 0: {
                                    n &= 0x1F;
                                    break;
                                }
                                case 128: {
                                    n &= 0x3F;
                                    break;
                                }
                                case 64: {
                                    n &= 0x7F;
                                }
                            }
                            if (this.recvFifoLen < this.recvFifo.length) {
                                this.recvFifo[this.recvFifoLen++] = n;
                            } else {
                                this.recvFifo[this.recvFifo.length - 1] = n | 0x200;
                            }
                            int n2 = this.wr[1] & 0x18;
                            if (n2 == 8 && this.recvNextInterruptEnabled || n2 == 16 || n2 == 24) {
                                this.interruptRequest |= 1;
                                Z80SIO.this.setInterruptPending();
                            }
                            this.recvNextInterruptEnabled = false;
                        }
                    }
                }
            }
        }

        private synchronized void clockPulseSender() {
            if (this.wr[4] > 0 && this.wr[5] > 0) {
                if (this.sendClockDiv == 0) {
                    this.sendClockDiv = this.getClockDiv() - 1;
                }
                if (this.sendClockDiv > 0) {
                    --this.sendClockDiv;
                }
                if (this.sendClockDiv == 0) {
                    if (this.sendClocksRemain == 0 && (this.rr[0] & 4) == 0 && (this.wr[5] & 8) != 0) {
                        this.sendClocksRemain = this.getTxDataBitCount() + this.getParityAndStopBitCount();
                    }
                    if (this.sendClocksRemain > 0) {
                        --this.sendClocksRemain;
                        if (this.sendClocksRemain == 0) {
                            int n = this.sendBuf & 0xFF;
                            switch (this.wr[5] & 0x60) {
                                case 0: {
                                    n &= 0x1F;
                                    break;
                                }
                                case 64: {
                                    n &= 0x3F;
                                    break;
                                }
                                case 32: {
                                    n &= 0x7F;
                                }
                            }
                            this.rr[0] = this.rr[0] | 4;
                            this.rr[1] = this.rr[1] | 1;
                            if ((this.wr[1] & 2) != 0) {
                                this.interruptRequest |= 2;
                                Z80SIO.this.setInterruptPending();
                            }
                            Z80SIO.this.fireByteAvailable(this, n);
                        }
                    }
                }
            }
        }

        private int getClockDiv() {
            int n = 1;
            switch (this.wr[4] & 0xC0) {
                case 64: {
                    n = 16;
                    break;
                }
                case 128: {
                    n = 32;
                    break;
                }
                case 192: {
                    n = 64;
                }
            }
            return n;
        }

        private int getParityAndStopBitCount() {
            int n = 0;
            switch (this.wr[4] & 0x18) {
                case 8: {
                    n = 1;
                    break;
                }
                case 16: 
                case 24: {
                    n = 2;
                }
            }
            if ((this.wr[4] & 1) != 0) {
                ++n;
            }
            return n;
        }

        private int getRxDataBitCount() {
            int n = 8;
            switch (this.wr[5] & 0xC0) {
                case 0: {
                    n = 5;
                    break;
                }
                case 64: {
                    n = 7;
                    break;
                }
                case 128: {
                    n = 6;
                }
            }
            return n;
        }

        private int getTxDataBitCount() {
            int n = 8;
            switch (this.wr[5] & 0x60) {
                case 0: {
                    n = 5;
                    break;
                }
                case 32: {
                    n = 7;
                    break;
                }
                case 64: {
                    n = 6;
                }
            }
            return n;
        }

        private synchronized boolean isReadyReceiver() {
            boolean bl = false;
            if (this.wr[3] > 0 && this.wr[4] > 0 && this.recvClocksRemain == 0 && (this.wr[3] & 1) != 0) {
                bl = true;
            }
            return bl;
        }

        private boolean isSpecialReceiveCondition() {
            boolean bl;
            boolean bl2 = bl = (this.rr[0] & 0xE0) != 0;
            if ((this.rr[0] & 0x10) != 0 && (this.wr[1] & 0x18) == 16) {
                bl = true;
            }
            return bl;
        }

        private void putToReceiver(int n) {
            if (this.recvClocksRemain == 0) {
                this.recvBuf = n | 0x100;
            }
        }

        private synchronized int readControl() {
            int n = 0;
            int n2 = this.wr[0] & 7;
            if (n2 >= 0 && n2 < 2) {
                n = this.rr[n2];
                if (n2 == 0) {
                    if (this.recvFifoLen > 0) {
                        n |= 1;
                    }
                    if (this.cts != null && this.cts.booleanValue()) {
                        n |= 0x20;
                    }
                    if (this.dcd != null && this.dcd.booleanValue()) {
                        n |= 8;
                    }
                }
            } else if (n2 == 2 && this.channelNum == 1) {
                n = Z80SIO.this.getInterruptVector();
            }
            return n;
        }

        private synchronized int readData() {
            int n = 0;
            if (this.recvFifoLen > 0) {
                n = this.recvFifo[0] & 0xFF;
                for (int i = 1; i < this.recvFifo.length; ++i) {
                    this.recvFifo[i - 1] = this.recvFifo[i];
                }
                this.recvFifo[this.recvFifo.length - 1] = 0;
                --this.recvFifoLen;
                this.rr[1] = this.rr[1] & 0xFFFFFFDF;
                if (this.recvFifoLen > 0 && (this.recvFifo[0] & 0x200) != 0) {
                    this.rr[1] = this.rr[1] | 0x20;
                }
            }
            return n;
        }

        private void reset(boolean bl) {
            this.interruptAccepted = 0;
            this.interruptRequest = 0;
            this.recvNextInterruptEnabled = true;
            this.recvBuf = 0;
            this.recvClockDiv = 0;
            this.recvClocksRemain = 0;
            this.recvFifoLen = 0;
            Arrays.fill(this.recvFifo, 0);
            this.sendBuf = 0;
            this.sendClockDiv = 0;
            this.sendClocksRemain = 0;
            this.rr[0] = 68;
            this.rr[1] = 1;
            for (int i = 0; i < this.wr.length; ++i) {
                this.wr[i] = i >= 2 && i <= 5 ? -1 : 0;
            }
            if (bl) {
                this.cts = false;
                this.dcd = false;
            }
        }

        private void resetSenderInterrupt() {
            this.interruptRequest &= 0xFFFFFFFD;
        }

        private synchronized void setCTS(boolean bl) {
            Boolean bl2 = this.cts;
            this.cts = bl;
            this.checkRequestExternalInterrupt(bl2, bl);
        }

        private synchronized void setDCD(boolean bl) {
            Boolean bl2 = this.dcd;
            this.dcd = bl;
            this.checkRequestExternalInterrupt(bl2, bl);
        }

        /*
         * Enabled aggressive block sorting
         */
        private synchronized void writeControl(int n) {
            int n2 = this.wr[0] & 7;
            this.wr[n2] = n & 0xFF;
            if (n2 == 1 && (n & 0x18) != 0) {
                this.recvNextInterruptEnabled = true;
            }
            switch (n2) {
                case 0: {
                    switch (n & 0x38) {
                        case 16: {
                            this.interruptRequest &= 0xFFFFFFFB;
                            break;
                        }
                        case 24: {
                            this.reset(false);
                            break;
                        }
                        case 32: {
                            this.recvNextInterruptEnabled = true;
                            break;
                        }
                        case 36: {
                            this.resetSenderInterrupt();
                            break;
                        }
                        case 48: {
                            this.rr[1] = this.rr[1] & 0xFFFFFFEF;
                            this.rr[1] = this.rr[1] & 0xFFFFFFDF;
                            break;
                        }
                        case 56: {
                            if (this.channelNum != 0) break;
                            Z80SIO.this.interruptFinish();
                        }
                    }
                    break;
                }
            }
            if (n2 != 0) {
                this.wr[0] = this.wr[0] & 0xF8;
            }
            if ((n & 0xC0) == 192) {
                this.rr[0] = this.rr[0] & 0xFFFFFFBF;
            }
        }

        private synchronized void writeData(int n) {
            this.sendBuf = n;
            this.resetSenderInterrupt();
            this.rr[0] = this.rr[0] & 0xFFFFFFFB;
            this.rr[1] = this.rr[1] & 0xFFFFFFFE;
        }
    }
}

