/*
 * Decompiled with CFR 0.152.
 */
package z80emu;

import z80emu.Z80MemView;
import z80emu.Z80ReassInstr;

public class Z80Reassembler {
    public static String createWordText(Integer n) {
        return n != null ? Z80Reassembler.createWordText((int)n) : null;
    }

    public static String createAddrText(Integer n, boolean bl) {
        String string = Z80Reassembler.createWordText(n);
        if (string != null && bl) {
            string = String.format("(%s)", string);
        }
        return string;
    }

    public static Z80ReassInstr reassInstruction(Z80MemView z80MemView, int n) {
        Z80ReassInstr z80ReassInstr = null;
        int n2 = z80MemView.getMemByte(n, true);
        boolean bl = n2 == 203 || n2 == 237 || n2 == 221 || n2 == 253;
        int n3 = z80MemView.getMemByte(n + 1, bl);
        int n4 = z80MemView.getMemByte(n + 2, true);
        int n5 = z80MemView.getMemByte(n + 3, true);
        if (n2 >= 0 && n2 <= 63) {
            z80ReassInstr = Z80Reassembler.reass00to3F(n, n2, n3, n4);
        } else if (n2 == 118) {
            z80ReassInstr = new Z80ReassInstr(1, "HALT");
        } else if (n2 >= 64 && n2 <= 127 && n2 != 118) {
            z80ReassInstr = new Z80ReassInstr(1, "LD", Z80Reassembler.getRegName(n2 >> 3), Z80Reassembler.getRegName(n2));
        } else if (n2 >= 128 && n2 <= 191) {
            String string = "";
            int n6 = n2 >> 3 & 7;
            switch (n6) {
                case 0: {
                    string = "ADD";
                    break;
                }
                case 1: {
                    string = "ADC";
                    break;
                }
                case 2: {
                    string = "SUB";
                    break;
                }
                case 3: {
                    string = "SBC";
                    break;
                }
                case 4: {
                    string = "AND";
                    break;
                }
                case 5: {
                    string = "XOR";
                    break;
                }
                case 6: {
                    string = "OR";
                    break;
                }
                case 7: {
                    string = "CP";
                }
            }
            z80ReassInstr = n6 == 0 || n6 == 1 || n6 == 3 ? new Z80ReassInstr(1, string, "A", Z80Reassembler.getRegName(n2)) : new Z80ReassInstr(1, string, Z80Reassembler.getRegName(n2));
        } else {
            z80ReassInstr = Z80Reassembler.reassC0toFF(n, n2, n3, n4, n5);
        }
        if (z80ReassInstr != null) {
            z80ReassInstr.setBytes(n2, n3, n4, n5);
        }
        return z80ReassInstr;
    }

    private static Z80ReassInstr reass00to3F(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 0: {
                return new Z80ReassInstr(1, "NOP");
            }
            case 1: {
                return new Z80ReassInstr(3, "LD", "BC", Z80Reassembler.createWordText(n3, n4));
            }
            case 2: {
                return new Z80ReassInstr(1, "LD", "(BC)", "A");
            }
            case 3: {
                return new Z80ReassInstr(1, "INC", "BC");
            }
            case 4: {
                return new Z80ReassInstr(1, "INC", "B");
            }
            case 5: {
                return new Z80ReassInstr(1, "DEC", "B");
            }
            case 6: {
                return new Z80ReassInstr(2, "LD", "B", Z80Reassembler.getByteText(n3));
            }
            case 7: {
                return new Z80ReassInstr(1, "RLCA");
            }
            case 8: {
                return new Z80ReassInstr(1, "EX", "AF", "AF'");
            }
            case 9: {
                return new Z80ReassInstr(1, "ADD", "HL", "BC");
            }
            case 10: {
                return new Z80ReassInstr(1, "LD", "A", "(BC)");
            }
            case 11: {
                return new Z80ReassInstr(1, "DEC", "BC");
            }
            case 12: {
                return new Z80ReassInstr(1, "INC", "C");
            }
            case 13: {
                return new Z80ReassInstr(1, "DEC", "C");
            }
            case 14: {
                return new Z80ReassInstr(2, "LD", "C", Z80Reassembler.getByteText(n3));
            }
            case 15: {
                return new Z80ReassInstr(1, "RRCA");
            }
            case 16: {
                return new Z80ReassInstr(2, "DJNZ", Z80Reassembler.getRelAddr(n + 2, n3));
            }
            case 17: {
                return new Z80ReassInstr(3, "LD", "DE", Z80Reassembler.createWordText(n3, n4));
            }
            case 18: {
                return new Z80ReassInstr(1, "LD", "(DE)", "A");
            }
            case 19: {
                return new Z80ReassInstr(1, "INC", "DE");
            }
            case 20: {
                return new Z80ReassInstr(1, "INC", "D");
            }
            case 21: {
                return new Z80ReassInstr(1, "DEC", "D");
            }
            case 22: {
                return new Z80ReassInstr(2, "LD", "D", Z80Reassembler.getByteText(n3));
            }
            case 23: {
                return new Z80ReassInstr(1, "RLA");
            }
            case 24: {
                return new Z80ReassInstr(2, "JR", Z80Reassembler.getRelAddr(n + 2, n3));
            }
            case 25: {
                return new Z80ReassInstr(1, "ADD", "HL", "DE");
            }
            case 26: {
                return new Z80ReassInstr(1, "LD", "A", "(DE)");
            }
            case 27: {
                return new Z80ReassInstr(1, "DEC", "DE");
            }
            case 28: {
                return new Z80ReassInstr(1, "INC", "E");
            }
            case 29: {
                return new Z80ReassInstr(1, "DEC", "E");
            }
            case 30: {
                return new Z80ReassInstr(2, "LD", "E", Z80Reassembler.getByteText(n3));
            }
            case 31: {
                return new Z80ReassInstr(1, "RRA");
            }
            case 32: {
                return new Z80ReassInstr(2, "JR", "NZ", Z80Reassembler.getRelAddr(n + 2, n3));
            }
            case 33: {
                return new Z80ReassInstr(3, "LD", "HL", Z80Reassembler.createWordText(n3, n4));
            }
            case 34: {
                return new Z80ReassInstr(3, "LD", Z80Reassembler.getWord(n3, n4), true, "HL");
            }
            case 35: {
                return new Z80ReassInstr(1, "INC", "HL");
            }
            case 36: {
                return new Z80ReassInstr(1, "INC", "H");
            }
            case 37: {
                return new Z80ReassInstr(1, "DEC", "H");
            }
            case 38: {
                return new Z80ReassInstr(2, "LD", "H", Z80Reassembler.getByteText(n3));
            }
            case 39: {
                return new Z80ReassInstr(1, "DAA");
            }
            case 40: {
                return new Z80ReassInstr(2, "JR", "Z", Z80Reassembler.getRelAddr(n + 2, n3));
            }
            case 41: {
                return new Z80ReassInstr(1, "ADD", "HL", "HL");
            }
            case 42: {
                return new Z80ReassInstr(3, "LD", "HL", Z80Reassembler.getWord(n3, n4), true);
            }
            case 43: {
                return new Z80ReassInstr(1, "DEC", "HL");
            }
            case 44: {
                return new Z80ReassInstr(1, "INC", "L");
            }
            case 45: {
                return new Z80ReassInstr(1, "DEC", "L");
            }
            case 46: {
                return new Z80ReassInstr(2, "LD", "L", Z80Reassembler.getByteText(n3));
            }
            case 47: {
                return new Z80ReassInstr(1, "CPL");
            }
            case 48: {
                return new Z80ReassInstr(2, "JR", "NC", Z80Reassembler.getRelAddr(n + 2, n3));
            }
            case 49: {
                return new Z80ReassInstr(3, "LD", "SP", Z80Reassembler.getWord(n3, n4));
            }
            case 50: {
                return new Z80ReassInstr(3, "LD", Z80Reassembler.getWord(n3, n4), true, "A");
            }
            case 51: {
                return new Z80ReassInstr(1, "INC", "SP");
            }
            case 52: {
                return new Z80ReassInstr(1, "INC", "(HL)");
            }
            case 53: {
                return new Z80ReassInstr(1, "DEC", "(HL)");
            }
            case 54: {
                return new Z80ReassInstr(2, "LD", "(HL)", Z80Reassembler.getByteText(n3));
            }
            case 55: {
                return new Z80ReassInstr(1, "SCF");
            }
            case 56: {
                return new Z80ReassInstr(2, "JR", "C", Z80Reassembler.getRelAddr(n + 2, n3));
            }
            case 57: {
                return new Z80ReassInstr(1, "ADD", "HL", "SP");
            }
            case 58: {
                return new Z80ReassInstr(3, "LD", "A", Z80Reassembler.getWord(n3, n4), true);
            }
            case 59: {
                return new Z80ReassInstr(1, "DEC", "SP");
            }
            case 60: {
                return new Z80ReassInstr(1, "INC", "A");
            }
            case 61: {
                return new Z80ReassInstr(1, "DEC", "A");
            }
            case 62: {
                return new Z80ReassInstr(2, "LD", "A", Z80Reassembler.getByteText(n3));
            }
            case 63: {
                return new Z80ReassInstr(1, "CCF");
            }
        }
        return null;
    }

    private static Z80ReassInstr reassC0toFF(int n, int n2, int n3, int n4, int n5) {
        switch (n2) {
            case 192: {
                return new Z80ReassInstr(1, "RET", "NZ");
            }
            case 193: {
                return new Z80ReassInstr(1, "POP", "BC");
            }
            case 194: {
                return new Z80ReassInstr(3, "JP", "NZ", Z80Reassembler.getWord(n3, n4));
            }
            case 195: {
                return new Z80ReassInstr(3, "JP", Z80Reassembler.getWord(n3, n4));
            }
            case 196: {
                return new Z80ReassInstr(3, "CALL", "NZ", Z80Reassembler.getWord(n3, n4));
            }
            case 197: {
                return new Z80ReassInstr(1, "PUSH", "BC");
            }
            case 198: {
                return new Z80ReassInstr(2, "ADD", "A", Z80Reassembler.getByteText(n3));
            }
            case 199: {
                return new Z80ReassInstr(1, "RST", "00H");
            }
            case 200: {
                return new Z80ReassInstr(1, "RET", "Z");
            }
            case 201: {
                return new Z80ReassInstr(1, "RET");
            }
            case 202: {
                return new Z80ReassInstr(3, "JP", "Z", Z80Reassembler.getWord(n3, n4));
            }
            case 203: {
                return Z80Reassembler.reassCB(n3);
            }
            case 204: {
                return new Z80ReassInstr(3, "CALL", "Z", Z80Reassembler.getWord(n3, n4));
            }
            case 205: {
                return new Z80ReassInstr(3, "CALL", Z80Reassembler.getWord(n3, n4));
            }
            case 206: {
                return new Z80ReassInstr(2, "ADC", "A", Z80Reassembler.getByteText(n3));
            }
            case 207: {
                return new Z80ReassInstr(1, "RST", "08H");
            }
            case 208: {
                return new Z80ReassInstr(1, "RET", "NC");
            }
            case 209: {
                return new Z80ReassInstr(1, "POP", "DE");
            }
            case 210: {
                return new Z80ReassInstr(3, "JP", "NC", Z80Reassembler.getWord(n3, n4));
            }
            case 211: {
                return new Z80ReassInstr(2, "OUT", Z80Reassembler.getIndirectByteText(n3), "A");
            }
            case 212: {
                return new Z80ReassInstr(3, "CALL", "NC", Z80Reassembler.getWord(n3, n4));
            }
            case 213: {
                return new Z80ReassInstr(1, "PUSH", "DE");
            }
            case 214: {
                return new Z80ReassInstr(2, "SUB", Z80Reassembler.getByteText(n3));
            }
            case 215: {
                return new Z80ReassInstr(1, "RST", "10H");
            }
            case 216: {
                return new Z80ReassInstr(1, "RET", "C");
            }
            case 217: {
                return new Z80ReassInstr(1, "EXX");
            }
            case 218: {
                return new Z80ReassInstr(3, "JP", "C", Z80Reassembler.getWord(n3, n4));
            }
            case 219: {
                return new Z80ReassInstr(2, "IN", "A", Z80Reassembler.getIndirectByteText(n3));
            }
            case 220: {
                return new Z80ReassInstr(3, "CALL", "C", Z80Reassembler.getWord(n3, n4));
            }
            case 221: {
                return n3 == 221 || n3 == 237 || n3 == 253 ? new Z80ReassInstr(1, "*NOP") : Z80Reassembler.reassIXY("IX", n, n3, n4, n5);
            }
            case 222: {
                return new Z80ReassInstr(2, "SBC", Z80Reassembler.getByteText(n3));
            }
            case 223: {
                return new Z80ReassInstr(1, "RST", "18H");
            }
            case 224: {
                return new Z80ReassInstr(1, "RET", "PO");
            }
            case 225: {
                return new Z80ReassInstr(1, "POP", "HL");
            }
            case 226: {
                return new Z80ReassInstr(3, "JP", "PO", Z80Reassembler.getWord(n3, n4));
            }
            case 227: {
                return new Z80ReassInstr(1, "EX", "(SP)", "HL");
            }
            case 228: {
                return new Z80ReassInstr(3, "CALL", "PO", Z80Reassembler.getWord(n3, n4));
            }
            case 229: {
                return new Z80ReassInstr(1, "PUSH", "HL");
            }
            case 230: {
                return new Z80ReassInstr(2, "AND", Z80Reassembler.getByteText(n3));
            }
            case 231: {
                return new Z80ReassInstr(1, "RST", "20H");
            }
            case 232: {
                return new Z80ReassInstr(1, "RET", "PE");
            }
            case 233: {
                return new Z80ReassInstr(1, "JP", "(HL)");
            }
            case 234: {
                return new Z80ReassInstr(3, "JP", "PE", Z80Reassembler.getWord(n3, n4));
            }
            case 235: {
                return new Z80ReassInstr(1, "EX", "DE", "HL");
            }
            case 236: {
                return new Z80ReassInstr(3, "CALL", "PE", Z80Reassembler.getWord(n3, n4));
            }
            case 237: {
                return Z80Reassembler.reassED(n3, n4, n5);
            }
            case 238: {
                return new Z80ReassInstr(2, "XOR", Z80Reassembler.getByteText(n3));
            }
            case 239: {
                return new Z80ReassInstr(1, "RST", "28H");
            }
            case 240: {
                return new Z80ReassInstr(1, "RET", "P");
            }
            case 241: {
                return new Z80ReassInstr(1, "POP", "AF");
            }
            case 242: {
                return new Z80ReassInstr(3, "JP", "P", Z80Reassembler.getWord(n3, n4));
            }
            case 243: {
                return new Z80ReassInstr(1, "DI");
            }
            case 244: {
                return new Z80ReassInstr(3, "CALL", "P", Z80Reassembler.getWord(n3, n4));
            }
            case 245: {
                return new Z80ReassInstr(1, "PUSH", "AF");
            }
            case 246: {
                return new Z80ReassInstr(2, "OR", Z80Reassembler.getByteText(n3));
            }
            case 247: {
                return new Z80ReassInstr(1, "RST", "30H");
            }
            case 248: {
                return new Z80ReassInstr(1, "RET", "M");
            }
            case 249: {
                return new Z80ReassInstr(1, "LD", "SP", "HL");
            }
            case 250: {
                return new Z80ReassInstr(3, "JP", "M", Z80Reassembler.getWord(n3, n4));
            }
            case 251: {
                return new Z80ReassInstr(1, "EI");
            }
            case 252: {
                return new Z80ReassInstr(3, "CALL", "M", Z80Reassembler.getWord(n3, n4));
            }
            case 253: {
                return n3 == 221 || n3 == 237 || n3 == 253 ? new Z80ReassInstr(1, "*NOP") : Z80Reassembler.reassIXY("IY", n, n3, n4, n5);
            }
            case 254: {
                return new Z80ReassInstr(2, "CP", Z80Reassembler.getByteText(n3));
            }
            case 255: {
                return new Z80ReassInstr(1, "RST", "38H");
            }
        }
        return null;
    }

    private static Z80ReassInstr reassCB(int n) {
        if (n >= 0 && n <= 63) {
            return new Z80ReassInstr(2, Z80Reassembler.getShiftName(n), Z80Reassembler.getRegName(n));
        }
        String string = "";
        switch (n >> 6 & 3) {
            case 1: {
                string = "BIT";
                break;
            }
            case 2: {
                string = "RES";
                break;
            }
            case 3: {
                string = "SET";
            }
        }
        return new Z80ReassInstr(2, string, String.valueOf(n >> 3 & 7), Z80Reassembler.getRegName(n));
    }

    private static Z80ReassInstr reassED(int n, int n2, int n3) {
        switch (n) {
            case 64: {
                return new Z80ReassInstr(2, "IN", "B", "(C)");
            }
            case 65: {
                return new Z80ReassInstr(2, "OUT", "(C)", "B");
            }
            case 66: {
                return new Z80ReassInstr(2, "SBC", "HL", "BC");
            }
            case 67: {
                return new Z80ReassInstr(4, "LD", Z80Reassembler.getWord(n2, n3), true, "BC");
            }
            case 68: {
                return new Z80ReassInstr(2, "NEG");
            }
            case 69: {
                return new Z80ReassInstr(2, "RETN");
            }
            case 70: {
                return new Z80ReassInstr(2, "IM", "0");
            }
            case 71: {
                return new Z80ReassInstr(2, "LD", "I", "A");
            }
            case 72: {
                return new Z80ReassInstr(2, "IN", "C", "(C)");
            }
            case 73: {
                return new Z80ReassInstr(2, "OUT", "(C)", "C");
            }
            case 74: {
                return new Z80ReassInstr(2, "ADC", "HL", "BC");
            }
            case 75: {
                return new Z80ReassInstr(4, "LD", "BC", Z80Reassembler.getWord(n2, n3), true);
            }
            case 76: {
                return new Z80ReassInstr(2, "*NEG");
            }
            case 77: {
                return new Z80ReassInstr(2, "RETI");
            }
            case 78: {
                return new Z80ReassInstr(2, "*IM", "0");
            }
            case 79: {
                return new Z80ReassInstr(2, "LD", "R", "A");
            }
            case 80: {
                return new Z80ReassInstr(2, "IN", "D", "(C)");
            }
            case 81: {
                return new Z80ReassInstr(2, "OUT", "(C)", "D");
            }
            case 82: {
                return new Z80ReassInstr(2, "SBC", "HL", "DE");
            }
            case 83: {
                return new Z80ReassInstr(4, "LD", Z80Reassembler.getWord(n2, n3), true, "DE");
            }
            case 84: {
                return new Z80ReassInstr(2, "*NEG");
            }
            case 85: {
                return new Z80ReassInstr(2, "*RETN");
            }
            case 86: {
                return new Z80ReassInstr(2, "IM", "1");
            }
            case 87: {
                return new Z80ReassInstr(2, "LD", "A", "I");
            }
            case 88: {
                return new Z80ReassInstr(2, "IN", "E", "(C)");
            }
            case 89: {
                return new Z80ReassInstr(2, "OUT", "(C)", "E");
            }
            case 90: {
                return new Z80ReassInstr(2, "ADC", "HL", "DE");
            }
            case 91: {
                return new Z80ReassInstr(4, "LD", "DE", Z80Reassembler.getWord(n2, n3), true);
            }
            case 92: {
                return new Z80ReassInstr(2, "*NEG");
            }
            case 93: {
                return new Z80ReassInstr(2, "*RETN");
            }
            case 94: {
                return new Z80ReassInstr(2, "IM", "2");
            }
            case 95: {
                return new Z80ReassInstr(2, "LD", "A", "R");
            }
            case 96: {
                return new Z80ReassInstr(2, "IN", "H", "(C)");
            }
            case 97: {
                return new Z80ReassInstr(2, "OUT", "(C)", "H");
            }
            case 98: {
                return new Z80ReassInstr(2, "SBC", "HL", "HL");
            }
            case 99: {
                return new Z80ReassInstr(4, "*LD", Z80Reassembler.getWord(n2, n3), true, "HL");
            }
            case 100: {
                return new Z80ReassInstr(2, "*NEG");
            }
            case 101: {
                return new Z80ReassInstr(2, "*RETN");
            }
            case 102: {
                return new Z80ReassInstr(2, "*IM", "0");
            }
            case 103: {
                return new Z80ReassInstr(2, "RRD");
            }
            case 104: {
                return new Z80ReassInstr(2, "IN", "L", "(C)");
            }
            case 105: {
                return new Z80ReassInstr(2, "OUT", "(C)", "L");
            }
            case 106: {
                return new Z80ReassInstr(2, "ADC", "HL", "HL");
            }
            case 107: {
                return new Z80ReassInstr(4, "*LD", "HL", Z80Reassembler.getWord(n2, n3));
            }
            case 108: {
                return new Z80ReassInstr(2, "*NEG");
            }
            case 109: {
                return new Z80ReassInstr(2, "*RETN");
            }
            case 110: {
                return new Z80ReassInstr(2, "*IM", "0");
            }
            case 111: {
                return new Z80ReassInstr(2, "RLD");
            }
            case 112: {
                return new Z80ReassInstr(2, "*IN", "F", "(C)");
            }
            case 113: {
                return new Z80ReassInstr(2, "*OUT", "(C)", "0");
            }
            case 114: {
                return new Z80ReassInstr(2, "SBC", "HL", "SP");
            }
            case 115: {
                return new Z80ReassInstr(4, "LD", Z80Reassembler.getWord(n2, n3), true, "SP");
            }
            case 116: {
                return new Z80ReassInstr(2, "*NEG");
            }
            case 117: {
                return new Z80ReassInstr(2, "*RETN");
            }
            case 118: {
                return new Z80ReassInstr(2, "*IM", "1");
            }
            case 120: {
                return new Z80ReassInstr(2, "IN", "A", "(C)");
            }
            case 121: {
                return new Z80ReassInstr(2, "OUT", "(C)", "A");
            }
            case 122: {
                return new Z80ReassInstr(2, "ADC", "HL", "SP");
            }
            case 123: {
                return new Z80ReassInstr(4, "LD", "SP", Z80Reassembler.getWord(n2, n3), true);
            }
            case 124: {
                return new Z80ReassInstr(2, "*NEG");
            }
            case 125: {
                return new Z80ReassInstr(2, "*RETN");
            }
            case 126: {
                return new Z80ReassInstr(2, "*IM", "2");
            }
            case 160: {
                return new Z80ReassInstr(2, "LDI");
            }
            case 161: {
                return new Z80ReassInstr(2, "CPI");
            }
            case 162: {
                return new Z80ReassInstr(2, "INI");
            }
            case 163: {
                return new Z80ReassInstr(2, "OUTI");
            }
            case 168: {
                return new Z80ReassInstr(2, "LDD");
            }
            case 169: {
                return new Z80ReassInstr(2, "CPD");
            }
            case 170: {
                return new Z80ReassInstr(2, "IND");
            }
            case 171: {
                return new Z80ReassInstr(2, "OUTD");
            }
            case 176: {
                return new Z80ReassInstr(2, "LDIR");
            }
            case 177: {
                return new Z80ReassInstr(2, "CPIR");
            }
            case 178: {
                return new Z80ReassInstr(2, "INIR");
            }
            case 179: {
                return new Z80ReassInstr(2, "OTIR");
            }
            case 184: {
                return new Z80ReassInstr(2, "LDDR");
            }
            case 185: {
                return new Z80ReassInstr(2, "CPDR");
            }
            case 186: {
                return new Z80ReassInstr(2, "INDR");
            }
            case 187: {
                return new Z80ReassInstr(2, "OTDR");
            }
        }
        return new Z80ReassInstr(2, "*NOP");
    }

    private static Z80ReassInstr reassIXY(String string, int n, int n2, int n3, int n4) {
        Z80ReassInstr z80ReassInstr = null;
        if (n2 >= 0 && n2 <= 63) {
            z80ReassInstr = Z80Reassembler.reassIXY_00to3F(string, n, n2, n3, n4);
        } else if (n2 >= 64 && n2 <= 111 || n2 >= 120 && n2 <= 127) {
            z80ReassInstr = (n2 & 0xF) == 6 || (n2 & 0xF) == 14 ? new Z80ReassInstr(3, "LD", Z80Reassembler.getRegName(n2 >> 3), Z80Reassembler.getIXYMem(string, n3)) : new Z80ReassInstr(2, "*LD", Z80Reassembler.getIXYRegName(string, n2 >> 3, n3), Z80Reassembler.getIXYRegName(string, n2, n3));
        } else if (n2 >= 112 && n2 <= 119) {
            z80ReassInstr = n2 == 118 ? new Z80ReassInstr(2, "*HALT") : new Z80ReassInstr(3, "LD", Z80Reassembler.getIXYMem(string, n3), Z80Reassembler.getRegName(n2));
        } else if (n2 >= 128 && n2 <= 191) {
            String string2 = "";
            int n5 = n2 >> 3 & 7;
            switch (n5) {
                case 0: {
                    string2 = "ADD";
                    break;
                }
                case 1: {
                    string2 = "ADC";
                    break;
                }
                case 2: {
                    string2 = "SUB";
                    break;
                }
                case 3: {
                    string2 = "SBC";
                    break;
                }
                case 4: {
                    string2 = "AND";
                    break;
                }
                case 5: {
                    string2 = "XOR";
                    break;
                }
                case 6: {
                    string2 = "OR";
                    break;
                }
                case 7: {
                    string2 = "CP";
                }
            }
            z80ReassInstr = (n2 & 0xF) == 6 || (n2 & 0xF) == 14 ? (n5 == 0 || n5 == 1 ? new Z80ReassInstr(3, string2, "A", Z80Reassembler.getIXYMem(string, n3)) : new Z80ReassInstr(3, string2, Z80Reassembler.getIXYMem(string, n3))) : (n5 == 0 || n5 == 1 ? new Z80ReassInstr(2, "*" + string2, "A", Z80Reassembler.getIXYRegName(string, n2, n3)) : new Z80ReassInstr(2, "*" + string2, Z80Reassembler.getIXYRegName(string, n2, n3)));
        } else {
            z80ReassInstr = Z80Reassembler.reassIXY_C0toFF(string, n, n2, n3, n4);
        }
        return z80ReassInstr;
    }

    private static Z80ReassInstr reassIXY_00to3F(String string, int n, int n2, int n3, int n4) {
        switch (n2) {
            case 0: {
                return new Z80ReassInstr(2, "*NOP");
            }
            case 1: {
                return new Z80ReassInstr(4, "*LD", "BC", Z80Reassembler.createWordText(n3, n4));
            }
            case 2: {
                return new Z80ReassInstr(2, "*LD", "(BC)", "A");
            }
            case 3: {
                return new Z80ReassInstr(2, "*INC", "BC");
            }
            case 4: {
                return new Z80ReassInstr(2, "*INC", "B");
            }
            case 5: {
                return new Z80ReassInstr(2, "*DEC", "B");
            }
            case 6: {
                return new Z80ReassInstr(3, "*LD", "B", Z80Reassembler.getByteText(n2));
            }
            case 7: {
                return new Z80ReassInstr(2, "*RLCA");
            }
            case 8: {
                return new Z80ReassInstr(2, "*EX", "AF", "AF'");
            }
            case 9: {
                return new Z80ReassInstr(2, "ADD", string, "BC");
            }
            case 10: {
                return new Z80ReassInstr(2, "*LD", "A", "(BC)");
            }
            case 11: {
                return new Z80ReassInstr(2, "*DEC", "BC");
            }
            case 12: {
                return new Z80ReassInstr(2, "*INC", "C");
            }
            case 13: {
                return new Z80ReassInstr(2, "*DEC", "C");
            }
            case 14: {
                return new Z80ReassInstr(3, "*LD", "C", Z80Reassembler.getByteText(n3));
            }
            case 15: {
                return new Z80ReassInstr(2, "*RRCA");
            }
            case 16: {
                return new Z80ReassInstr(3, "*DJNZ", Z80Reassembler.getRelAddr(n + 3, n3));
            }
            case 17: {
                return new Z80ReassInstr(4, "*LD", "DE", Z80Reassembler.createWordText(n3, n4));
            }
            case 18: {
                return new Z80ReassInstr(2, "*LD", "(DE)", "A");
            }
            case 19: {
                return new Z80ReassInstr(2, "*INC", "DE");
            }
            case 20: {
                return new Z80ReassInstr(2, "*INC", "D");
            }
            case 21: {
                return new Z80ReassInstr(2, "*DEC", "D");
            }
            case 22: {
                return new Z80ReassInstr(3, "*LD", "D", Z80Reassembler.getByteText(n3));
            }
            case 23: {
                return new Z80ReassInstr(2, "*RLA");
            }
            case 24: {
                return new Z80ReassInstr(3, "*JR", Z80Reassembler.getRelAddr(n + 3, n3));
            }
            case 25: {
                return new Z80ReassInstr(2, "ADD", string, "DE");
            }
            case 26: {
                return new Z80ReassInstr(2, "*LD", "A", "(DE)");
            }
            case 27: {
                return new Z80ReassInstr(2, "*DEC", "DE");
            }
            case 28: {
                return new Z80ReassInstr(2, "*INC", "E");
            }
            case 29: {
                return new Z80ReassInstr(2, "*DEC", "E");
            }
            case 30: {
                return new Z80ReassInstr(3, "*LD", "E", Z80Reassembler.getByteText(n3));
            }
            case 31: {
                return new Z80ReassInstr(2, "*RRA");
            }
            case 32: {
                return new Z80ReassInstr(3, "*JR", "NZ", Z80Reassembler.getRelAddr(n + 3, n3));
            }
            case 33: {
                return new Z80ReassInstr(4, "LD", string, Z80Reassembler.createWordText(n3, n4));
            }
            case 34: {
                return new Z80ReassInstr(4, "LD", Z80Reassembler.getWord(n3, n4), true, string);
            }
            case 35: {
                return new Z80ReassInstr(2, "INC", string);
            }
            case 36: {
                return new Z80ReassInstr(2, "*INC", string + "H");
            }
            case 37: {
                return new Z80ReassInstr(2, "*DEC", string + "H");
            }
            case 38: {
                return new Z80ReassInstr(3, "*LD", string + "H", Z80Reassembler.getByteText(n3));
            }
            case 39: {
                return new Z80ReassInstr(2, "*DAA");
            }
            case 40: {
                return new Z80ReassInstr(3, "*JR", "Z", Z80Reassembler.getRelAddr(n + 3, n3));
            }
            case 41: {
                return new Z80ReassInstr(2, "ADD", string, string);
            }
            case 42: {
                return new Z80ReassInstr(4, "LD", string, Z80Reassembler.getWord(n3, n4), true);
            }
            case 43: {
                return new Z80ReassInstr(2, "DEC", string);
            }
            case 44: {
                return new Z80ReassInstr(2, "*INC", string + "L");
            }
            case 45: {
                return new Z80ReassInstr(2, "*DEC", string + "L");
            }
            case 46: {
                return new Z80ReassInstr(3, "*LD", string + "L", Z80Reassembler.getByteText(n3));
            }
            case 47: {
                return new Z80ReassInstr(2, "*CPL");
            }
            case 48: {
                return new Z80ReassInstr(3, "*JR", "NC", Z80Reassembler.getRelAddr(n + 3, n3));
            }
            case 49: {
                return new Z80ReassInstr(4, "*LD", "SP", Z80Reassembler.getWord(n3, n4));
            }
            case 50: {
                return new Z80ReassInstr(4, "*LD", Z80Reassembler.getWord(n3, n4), true, "A");
            }
            case 51: {
                return new Z80ReassInstr(2, "*INC", "SP");
            }
            case 52: {
                return new Z80ReassInstr(3, "INC", Z80Reassembler.getIXYMem(string, n3));
            }
            case 53: {
                return new Z80ReassInstr(3, "DEC", Z80Reassembler.getIXYMem(string, n3));
            }
            case 54: {
                return new Z80ReassInstr(4, "LD", Z80Reassembler.getIXYMem(string, n3), Z80Reassembler.getByteText(n4));
            }
            case 55: {
                return new Z80ReassInstr(2, "*SCF");
            }
            case 56: {
                return new Z80ReassInstr(3, "*JR", "C", Z80Reassembler.getRelAddr(n + 3, n3));
            }
            case 57: {
                return new Z80ReassInstr(2, "ADD", string, "SP");
            }
            case 58: {
                return new Z80ReassInstr(4, "*LD", "A", Z80Reassembler.getWord(n3, n4), true);
            }
            case 59: {
                return new Z80ReassInstr(2, "*DEC", "SP");
            }
            case 60: {
                return new Z80ReassInstr(2, "*INC", "A");
            }
            case 61: {
                return new Z80ReassInstr(2, "*DEC", "A");
            }
            case 62: {
                return new Z80ReassInstr(3, "*LD", "A", Z80Reassembler.getByteText(n3));
            }
            case 63: {
                return new Z80ReassInstr(2, "*CCF");
            }
        }
        return null;
    }

    private static Z80ReassInstr reassIXY_C0toFF(String string, int n, int n2, int n3, int n4) {
        switch (n2) {
            case 192: {
                return new Z80ReassInstr(2, "*RET", "NZ");
            }
            case 193: {
                return new Z80ReassInstr(2, "*POP", "BC");
            }
            case 194: {
                return new Z80ReassInstr(4, "*JP", "NZ", Z80Reassembler.getWord(n3, n4));
            }
            case 195: {
                return new Z80ReassInstr(4, "*JP", Z80Reassembler.getWord(n3, n4));
            }
            case 196: {
                return new Z80ReassInstr(4, "*CALL", "NZ", Z80Reassembler.getWord(n3, n4));
            }
            case 197: {
                return new Z80ReassInstr(2, "*PUSH", "BC");
            }
            case 198: {
                return new Z80ReassInstr(3, "*ADD", "A", Z80Reassembler.getByteText(n3));
            }
            case 199: {
                return new Z80ReassInstr(2, "*RST", "00H");
            }
            case 200: {
                return new Z80ReassInstr(2, "*RET", "Z");
            }
            case 201: {
                return new Z80ReassInstr(2, "*RET");
            }
            case 202: {
                return new Z80ReassInstr(4, "*JP", "Z", Z80Reassembler.getWord(n3, n4));
            }
            case 203: {
                return Z80Reassembler.reassIXY_CB(string, n3, n4);
            }
            case 204: {
                return new Z80ReassInstr(4, "*CALL", "Z", Z80Reassembler.getWord(n3, n4));
            }
            case 205: {
                return new Z80ReassInstr(4, "*CALL", Z80Reassembler.getWord(n3, n4));
            }
            case 206: {
                return new Z80ReassInstr(3, "*ADC", "A", Z80Reassembler.getByteText(n3));
            }
            case 207: {
                return new Z80ReassInstr(2, "*RST", "08H");
            }
            case 208: {
                return new Z80ReassInstr(2, "*RET", "NC");
            }
            case 209: {
                return new Z80ReassInstr(2, "*POP", "DE");
            }
            case 210: {
                return new Z80ReassInstr(4, "*JP", "NC", Z80Reassembler.getWord(n3, n4));
            }
            case 211: {
                return new Z80ReassInstr(3, "*OUT", "(" + Z80Reassembler.getByteText(n3) + ")", "A");
            }
            case 212: {
                return new Z80ReassInstr(4, "*CALL", "NC", Z80Reassembler.getWord(n3, n4));
            }
            case 213: {
                return new Z80ReassInstr(2, "*PUSH", "DE");
            }
            case 214: {
                return new Z80ReassInstr(3, "*SUB", Z80Reassembler.getByteText(n3));
            }
            case 215: {
                return new Z80ReassInstr(2, "*RST", "10H");
            }
            case 216: {
                return new Z80ReassInstr(2, "*RET", "C");
            }
            case 217: {
                return new Z80ReassInstr(2, "*EXX");
            }
            case 218: {
                return new Z80ReassInstr(4, "*JP", "C", Z80Reassembler.getWord(n3, n4));
            }
            case 219: {
                return new Z80ReassInstr(3, "*IN", "A", "(" + Z80Reassembler.getByteText(n3) + ")");
            }
            case 220: {
                return new Z80ReassInstr(4, "*CALL", "C", Z80Reassembler.getWord(n3, n4));
            }
            case 221: {
                return new Z80ReassInstr(2, "*?");
            }
            case 222: {
                return new Z80ReassInstr(3, "*SBC", Z80Reassembler.getByteText(n3));
            }
            case 223: {
                return new Z80ReassInstr(2, "*RST", "18H");
            }
            case 224: {
                return new Z80ReassInstr(2, "*RET", "PO");
            }
            case 225: {
                return new Z80ReassInstr(2, "POP", string);
            }
            case 226: {
                return new Z80ReassInstr(4, "*JP", "PO", Z80Reassembler.getWord(n3, n4));
            }
            case 227: {
                return new Z80ReassInstr(2, "EX", "(SP)", string);
            }
            case 228: {
                return new Z80ReassInstr(4, "*CALL", "PO", Z80Reassembler.getWord(n3, n4));
            }
            case 229: {
                return new Z80ReassInstr(2, "PUSH", string);
            }
            case 230: {
                return new Z80ReassInstr(3, "*AND", Z80Reassembler.getByteText(n3));
            }
            case 231: {
                return new Z80ReassInstr(2, "*RST", "20H");
            }
            case 232: {
                return new Z80ReassInstr(2, "*RET", "PE");
            }
            case 233: {
                return new Z80ReassInstr(2, "JP", "(" + string + ")");
            }
            case 234: {
                return new Z80ReassInstr(4, "*JP", "PE", Z80Reassembler.getWord(n3, n4));
            }
            case 235: {
                return new Z80ReassInstr(2, "*EX", "DE", "HL");
            }
            case 236: {
                return new Z80ReassInstr(4, "*CALL", "PE", Z80Reassembler.getWord(n3, n4));
            }
            case 237: {
                return new Z80ReassInstr(2, "*?");
            }
            case 238: {
                return new Z80ReassInstr(3, "*XOR", Z80Reassembler.getByteText(n3));
            }
            case 239: {
                return new Z80ReassInstr(2, "*RST", "28H");
            }
            case 240: {
                return new Z80ReassInstr(2, "*RET", "P");
            }
            case 241: {
                return new Z80ReassInstr(2, "*POP", "AF");
            }
            case 242: {
                return new Z80ReassInstr(4, "*JP", "P", Z80Reassembler.getWord(n3, n4));
            }
            case 243: {
                return new Z80ReassInstr(2, "*DI");
            }
            case 244: {
                return new Z80ReassInstr(4, "*CALL", "P", Z80Reassembler.getWord(n3, n4));
            }
            case 245: {
                return new Z80ReassInstr(2, "*PUSH", "AF");
            }
            case 246: {
                return new Z80ReassInstr(3, "*OR", Z80Reassembler.getByteText(n3));
            }
            case 247: {
                return new Z80ReassInstr(2, "*RST", "30H");
            }
            case 248: {
                return new Z80ReassInstr(2, "*RET", "M");
            }
            case 249: {
                return new Z80ReassInstr(2, "LD", "SP", string);
            }
            case 250: {
                return new Z80ReassInstr(4, "*JP", "M", Z80Reassembler.getWord(n3, n4));
            }
            case 251: {
                return new Z80ReassInstr(2, "*EI");
            }
            case 252: {
                return new Z80ReassInstr(4, "*CALL", "M", Z80Reassembler.getWord(n3, n4));
            }
            case 253: {
                return new Z80ReassInstr(2, "*?");
            }
            case 254: {
                return new Z80ReassInstr(3, "*CP", Z80Reassembler.getByteText(n3));
            }
            case 255: {
                return new Z80ReassInstr(2, "RST", "38H");
            }
        }
        return null;
    }

    private static Z80ReassInstr reassIXY_CB(String string, int n, int n2) {
        if (n2 >= 0 && n2 <= 63) {
            if ((n2 & 0xF) == 6 || (n2 & 0xF) == 14) {
                return new Z80ReassInstr(4, Z80Reassembler.getShiftName(n2), Z80Reassembler.getIXYMem(string, n));
            }
            String string2 = Z80Reassembler.getShiftName(n2);
            if (!string2.startsWith("*")) {
                string2 = "*" + string2;
            }
            return new Z80ReassInstr(4, string2, String.format("%s,%s", Z80Reassembler.getIXYMem(string, n), Z80Reassembler.getRegName(n2)));
        }
        String string3 = "BIT";
        if (n2 >= 64 && n2 <= 127) {
            if ((n2 & 0xF) != 6 && (n2 & 0xF) != 14) {
                string3 = "*BIT";
            }
            return new Z80ReassInstr(4, string3, String.valueOf(n2 >> 3 & 7), Z80Reassembler.getIXYMem(string, n));
        }
        String string4 = string3 = n2 < 192 ? "RES" : "SET";
        if ((n2 & 0xF) == 6 || (n2 & 0xF) == 14) {
            return new Z80ReassInstr(4, string3, String.valueOf(n2 >> 3 & 7), Z80Reassembler.getIXYMem(string, n));
        }
        if (!string3.startsWith("*")) {
            string3 = "*" + string3;
        }
        return new Z80ReassInstr(4, string3, String.format("%d,%s,%s", n2 >> 3 & 7, Z80Reassembler.getIXYMem(string, n), Z80Reassembler.getRegName(n2)));
    }

    private static String createWordText(int n) {
        return String.format("%s%04XH", (n &= 0xFFFF) >= 40960 ? "0" : "", n);
    }

    private static String createWordText(int n, int n2) {
        return String.format("%s%02X%02XH", n2 >= 160 ? "0" : "", n2, n);
    }

    private static String getRegName(int n) {
        switch (n & 7) {
            case 0: {
                return "B";
            }
            case 1: {
                return "C";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "E";
            }
            case 4: {
                return "H";
            }
            case 5: {
                return "L";
            }
            case 6: {
                return "(HL)";
            }
            case 7: {
                return "A";
            }
        }
        return "?";
    }

    private static String getIXYRegName(String string, int n, int n2) {
        switch (n & 7) {
            case 0: {
                return "B";
            }
            case 1: {
                return "C";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "E";
            }
            case 4: {
                return string + "H";
            }
            case 5: {
                return string + "L";
            }
            case 6: {
                return Z80Reassembler.getIXYMem(string, n2);
            }
            case 7: {
                return "A";
            }
        }
        return "?";
    }

    private static String getShiftName(int n) {
        switch (n & 0x38) {
            case 0: {
                return "RLC";
            }
            case 8: {
                return "RRC";
            }
            case 16: {
                return "RL";
            }
            case 24: {
                return "RR";
            }
            case 32: {
                return "SLA";
            }
            case 40: {
                return "SRA";
            }
            case 48: {
                return "*SLL";
            }
            case 56: {
                return "SRL";
            }
        }
        return "?";
    }

    private static String getByteText(int n) {
        return String.format("%s%02XH", (n &= 0xFF) >= 160 ? "0" : "", n);
    }

    private static String getIndirectByteText(int n) {
        return String.format("(%s%02XH)", (n &= 0xFF) >= 160 ? "0" : "", n);
    }

    private static String getIXYMem(String string, int n) {
        return "(" + string + "+" + Z80Reassembler.getByteText(n) + ")";
    }

    private static int getRelAddr(int n, int n2) {
        return n + (byte)n2;
    }

    private static int getWord(int n, int n2) {
        return n2 << 8 & 0xFF00 | n & 0xFF;
    }
}

