/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.hexedit;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jkcemu.base.BaseDlg;
import jkcemu.etc.CksCalculator;

public class ReplyCksAlgorithmDlg
extends BaseDlg {
    private String approvedAlgorithm = null;
    private JComboBox<String> comboAlgorithm;
    private JButton btnOK;
    private JButton btnCancel;

    public static String askCksAlgorithm(Window window, String string) {
        ReplyCksAlgorithmDlg replyCksAlgorithmDlg = new ReplyCksAlgorithmDlg(window, string);
        replyCksAlgorithmDlg.setVisible(true);
        return replyCksAlgorithmDlg.approvedAlgorithm;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnOK) {
                bl = true;
                this.doApprove();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getComponent() == this.comboAlgorithm && keyEvent.getKeyCode() == 10) {
            this.doApprove();
            keyEvent.consume();
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.comboAlgorithm.requestFocus();
    }

    private ReplyCksAlgorithmDlg(Window window, String string) {
        super(window, "Pr\u00fcfsummen-/Hash-Algorithmus");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Algorithmus:"), gridBagConstraints);
        this.comboAlgorithm = new JComboBox<String>(CksCalculator.getAvailableAlgorithms());
        this.comboAlgorithm.setEditable(false);
        if (string != null) {
            this.comboAlgorithm.setSelectedItem(string);
        }
        this.comboAlgorithm.addKeyListener(this);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        this.add(this.comboAlgorithm, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    private void doApprove() {
        Object object = this.comboAlgorithm.getSelectedItem();
        if (object != null) {
            this.approvedAlgorithm = object.toString();
            this.doClose();
        }
    }
}

