/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.hexedit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import javax.naming.SizeLimitExceededException;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.ReplyBytesDlg;
import jkcemu.print.PrintOptionsDlg;
import jkcemu.print.PrintUtil;
import jkcemu.tools.hexedit.AbstractHexCharFrm;

public class HexEditFrm
extends AbstractHexCharFrm
implements DropTargetListener {
    private static final String HELP_PAGE = "/help/tools/hexeditor.htm";
    private static final int BUF_EXTEND = 8192;
    private static HexEditFrm instance = null;
    private File file = null;
    private byte[] fileBytes = new byte[256];
    private int fileLen = 0;
    private int savedPos = -1;
    private boolean dataChanged = false;
    private JMenuItem mnuNew;
    private JMenuItem mnuOpen;
    private JMenuItem mnuSave;
    private JMenuItem mnuSaveAs;
    private JMenuItem mnuPrintOptions;
    private JMenuItem mnuPrint;
    private JMenuItem mnuClose;
    private JMenuItem mnuBytesCopyHex;
    private JMenuItem mnuBytesCopyAscii;
    private JMenuItem mnuBytesCopyDump;
    private JMenuItem mnuBytesInvert;
    private JMenuItem mnuBytesReverse;
    private JMenuItem mnuBytesSave;
    private JMenuItem mnuBytesAppend;
    private JMenuItem mnuBytesInsert;
    private JMenuItem mnuBytesOverwrite;
    private JMenuItem mnuBytesRemove;
    private JMenuItem mnuFileInsert;
    private JMenuItem mnuFileAppend;
    private JMenuItem mnuSavePos;
    private JMenuItem mnuGotoSavedPos;
    private JMenuItem mnuSelectToSavedPos;
    private JMenuItem mnuSelectAll;
    private JMenuItem mnuChecksum;
    private JMenuItem mnuFind;
    private JMenuItem mnuFindNext;
    private JMenuItem mnuHelpContent;
    private JButton btnNew;
    private JButton btnOpen;
    private JButton btnSave;
    private JButton btnFind;

    public static void open() {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new HexEditFrm();
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public static void open(byte[] byArray) {
        HexEditFrm.open();
        if (byArray != null && instance.confirmDataSaved()) {
            instance.newFileInternal(byArray);
        }
    }

    public static void open(File file) {
        HexEditFrm.open();
        if (file != null) {
            instance.openFile(file);
        }
    }

    public void openFile(File file) {
        if (instance.confirmDataSaved()) {
            instance.openFileInternal(file);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file = EmuUtil.fileDrop(this, dropTargetDropEvent);
        if (file != null) {
            this.openFile(file);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnNew || object == this.mnuNew) {
                bl = true;
                if (this.confirmDataSaved()) {
                    this.newFileInternal(null);
                }
            } else if (object == this.btnOpen || object == this.mnuOpen) {
                bl = true;
                this.doOpen();
            } else if (object == this.btnSave || object == this.mnuSave) {
                bl = true;
                this.doSave(false);
            } else if (object == this.mnuSaveAs) {
                bl = true;
                this.doSave(true);
            } else if (object == this.mnuPrintOptions) {
                bl = true;
                PrintOptionsDlg.showPrintOptionsDlg(this, true, true);
            } else if (object == this.mnuPrint) {
                bl = true;
                PrintUtil.doPrint(this, this, "JKCEMU Hex-Editor");
            } else if (object == this.mnuClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuBytesAppend) {
                bl = true;
                this.doBytesAppend();
            } else if (object == this.mnuBytesCopyHex) {
                bl = true;
                this.hexCharFld.copySelectedBytesAsHex();
            } else if (object == this.mnuBytesCopyAscii) {
                bl = true;
                this.hexCharFld.copySelectedBytesAsAscii();
            } else if (object == this.mnuBytesCopyDump) {
                bl = true;
                this.hexCharFld.copySelectedBytesAsDump();
            } else if (object == this.mnuBytesInvert) {
                bl = true;
                this.doBytesInvert();
            } else if (object == this.mnuBytesReverse) {
                bl = true;
                this.doBytesReverse();
            } else if (object == this.mnuBytesSave) {
                bl = true;
                this.doBytesSave();
            } else if (object == this.mnuBytesInsert) {
                bl = true;
                this.doBytesInsert();
            } else if (object == this.mnuBytesOverwrite) {
                bl = true;
                this.doBytesOverwrite();
            } else if (object == this.mnuBytesRemove) {
                bl = true;
                this.doBytesRemove();
            } else if (object == this.mnuFileAppend) {
                bl = true;
                this.doFileAppend();
            } else if (object == this.mnuFileInsert) {
                bl = true;
                this.doFileInsert();
            } else if (object == this.mnuSavePos) {
                bl = true;
                this.doSavePos();
            } else if (object == this.mnuGotoSavedPos) {
                bl = true;
                this.doGotoSavedPos(false);
            } else if (object == this.mnuSelectToSavedPos) {
                bl = true;
                this.doGotoSavedPos(true);
            } else if (object == this.mnuSelectAll) {
                bl = true;
                this.doSelectAll();
            } else if (object == this.mnuChecksum) {
                bl = true;
                this.doChecksum();
            } else if (object == this.btnFind || object == this.mnuFind) {
                bl = true;
                this.doFind();
            } else if (object == this.mnuFindNext) {
                bl = true;
                this.doFindNext();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            } else {
                bl = super.doAction(eventObject);
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = this.confirmDataSaved();
        if (bl) {
            bl = super.doClose();
        }
        if (bl && !Main.checkQuit(this)) {
            this.newFileInternal(null);
        }
        return bl;
    }

    @Override
    public int getDataByte(int n) {
        int n2 = 0;
        if (this.fileBytes != null && n >= 0 && n < this.fileBytes.length) {
            n2 = this.fileBytes[n] & 0xFF;
        }
        return n2;
    }

    @Override
    public int getDataLength() {
        return this.fileLen;
    }

    @Override
    protected void setContentActionsEnabled(boolean bl) {
        this.mnuSaveAs.setEnabled(bl);
        this.mnuPrint.setEnabled(bl);
        this.mnuSelectAll.setEnabled(bl);
        this.mnuFind.setEnabled(bl);
        this.btnFind.setEnabled(bl);
    }

    @Override
    protected void setFindNextActionsEnabled(boolean bl) {
        this.mnuFindNext.setEnabled(bl);
    }

    @Override
    protected void setSelectedByteActionsEnabled(boolean bl) {
        this.mnuBytesCopyHex.setEnabled(bl);
        this.mnuBytesCopyAscii.setEnabled(bl);
        this.mnuBytesCopyDump.setEnabled(bl);
        this.mnuBytesInvert.setEnabled(bl);
        this.mnuBytesReverse.setEnabled(bl);
        this.mnuBytesSave.setEnabled(bl);
        this.mnuBytesInsert.setEnabled(bl);
        this.mnuBytesOverwrite.setEnabled(bl);
        this.mnuBytesRemove.setEnabled(bl);
        this.mnuFileInsert.setEnabled(bl);
        this.mnuChecksum.setEnabled(bl);
        this.mnuSavePos.setEnabled(bl);
        this.mnuSelectToSavedPos.setEnabled(bl && this.savedPos >= 0);
    }

    private void doBytesAppend() {
        ReplyBytesDlg replyBytesDlg = new ReplyBytesDlg(this, "Bytes anh\u00e4ngen", this.lastInputFmt, this.lastBigEndian, null);
        replyBytesDlg.setVisible(true);
        byte[] byArray = replyBytesDlg.getApprovedBytes();
        if (byArray != null && byArray.length > 0) {
            int n = this.fileLen;
            this.lastInputFmt = replyBytesDlg.getApprovedInputFormat();
            this.lastBigEndian = replyBytesDlg.getApprovedBigEndian();
            try {
                this.insertBytes(this.fileLen, byArray, 0);
            }
            catch (SizeLimitExceededException sizeLimitExceededException) {
                BaseDlg.showErrorDlg((Component)this, sizeLimitExceededException.getMessage());
            }
            this.setDataChanged(true);
            this.updView();
            this.setSelection(n, this.fileLen - 1);
        }
    }

    private void doBytesInsert() {
        int n = this.hexCharFld.getCaretPosition();
        if (n >= 0 && n < this.fileLen) {
            ReplyBytesDlg replyBytesDlg = new ReplyBytesDlg(this, "Bytes einf\u00fcgen", this.lastInputFmt, this.lastBigEndian, null);
            replyBytesDlg.setVisible(true);
            byte[] byArray = replyBytesDlg.getApprovedBytes();
            if (byArray != null && byArray.length > 0) {
                this.lastInputFmt = replyBytesDlg.getApprovedInputFormat();
                this.lastBigEndian = replyBytesDlg.getApprovedBigEndian();
                try {
                    this.insertBytes(n, byArray, 0);
                }
                catch (SizeLimitExceededException sizeLimitExceededException) {
                    BaseDlg.showErrorDlg((Component)this, sizeLimitExceededException.getMessage());
                }
                this.setDataChanged(true);
                this.updView();
                this.setSelection(n, n + byArray.length - 1);
            }
        }
    }

    private void doBytesInvert() {
        int n = this.getDataLength();
        int n2 = this.hexCharFld.getCaretPosition();
        int n3 = this.hexCharFld.getMarkPosition();
        int n4 = -1;
        int n5 = -1;
        if (n2 >= 0 && n3 >= 0) {
            n4 = Math.min(n2, n3);
            n5 = Math.max(n2, n3);
        } else {
            n4 = n2;
            n5 = n2;
        }
        if (n5 >= n) {
            n5 = n - 1;
        }
        if (n4 >= 0) {
            String string = null;
            if (n5 > n4) {
                string = String.format("M\u00f6chten Sie die %d ausgew\u00e4hlten Bytes invertieren?", n5 - n4 + 1);
            } else if (n5 == n4) {
                string = String.format("M\u00f6chten Sie das ausgew\u00e4hlte Byte mit dem Wert %02Xh invertieren?\ninvertierte Wert: %02Xh", this.fileBytes[n4] & 0xFF, ~this.fileBytes[n4] & 0xFF);
            }
            if (string != null && BaseDlg.showYesNoDlg(this, string)) {
                for (int i = n4; i <= n5; ++i) {
                    this.fileBytes[i] = ~this.fileBytes[i];
                }
                this.setDataChanged(true);
                this.updView();
                this.setSelection(n4, n5);
            }
        }
    }

    private void doBytesOverwrite() {
        int n = this.hexCharFld.getCaretPosition();
        if (n >= 0 && n < this.fileLen) {
            ReplyBytesDlg replyBytesDlg = new ReplyBytesDlg(this, "Bytes \u00fcberschreiben", this.lastInputFmt, this.lastBigEndian, null);
            replyBytesDlg.setVisible(true);
            byte[] byArray = replyBytesDlg.getApprovedBytes();
            if (byArray != null && byArray.length > 0) {
                this.lastInputFmt = replyBytesDlg.getApprovedInputFormat();
                this.lastBigEndian = replyBytesDlg.getApprovedBigEndian();
                try {
                    int n2 = 0;
                    int n3 = n;
                    while (n2 < byArray.length && n3 < this.fileLen) {
                        this.fileBytes[n3++] = byArray[n2++];
                    }
                    if (n2 < byArray.length) {
                        this.insertBytes(n3, byArray, n2);
                    }
                }
                catch (SizeLimitExceededException sizeLimitExceededException) {
                    BaseDlg.showErrorDlg((Component)this, sizeLimitExceededException.getMessage());
                }
                this.setDataChanged(true);
                this.updView();
                this.setSelection(n, n + byArray.length - 1);
            }
        }
    }

    private void doBytesRemove() {
        int n = this.hexCharFld.getCaretPosition();
        int n2 = this.hexCharFld.getMarkPosition();
        int n3 = -1;
        int n4 = -1;
        if (n >= 0 && n2 >= 0) {
            n3 = Math.min(n, n2);
            n4 = Math.max(n, n2);
        } else {
            n3 = n;
            n4 = n;
        }
        if (n4 >= this.fileLen) {
            n4 = this.fileLen - 1;
        }
        if (n3 >= 0) {
            String string = null;
            if (n4 > n3) {
                string = String.format("M\u00f6chten Sie die %d ausgew\u00e4hlten Bytes entfernen?", n4 - n3 + 1);
            } else if (n4 == n3) {
                string = String.format("M\u00f6chten das ausgew\u00e4hlte Byte mit dem Wert %02Xh entfernen?", this.fileBytes[n3]);
            }
            if (string != null && BaseDlg.showYesNoDlg(this, string)) {
                if (n4 + 1 < this.fileLen) {
                    ++n4;
                    while (n4 < this.fileLen) {
                        this.fileBytes[n3++] = this.fileBytes[n4++];
                    }
                }
                this.fileLen = n3;
                this.setDataChanged(true);
                this.updView();
                this.setCaretPosition(n3, false);
            }
        }
    }

    private void doBytesReverse() {
        int n = this.getDataLength();
        int n2 = this.hexCharFld.getCaretPosition();
        int n3 = this.hexCharFld.getMarkPosition();
        int n4 = -1;
        int n5 = -1;
        if (n2 >= 0 && n3 >= 0) {
            n4 = Math.min(n2, n3);
            n5 = Math.max(n2, n3);
        } else {
            n4 = n2;
            n5 = n2;
        }
        if (n5 >= n) {
            n5 = n - 1;
        }
        if (n4 >= 0) {
            String string = null;
            if (n5 > n4) {
                string = String.format("M\u00f6chten Sie die %d ausgew\u00e4hlten Bytes spiegeln?\nBits tauschen: 0-7, 1-6, 2-5, 3-4", n5 - n4 + 1);
            } else if (n5 == n4) {
                string = String.format("M\u00f6chten Sie das ausgew\u00e4hlte Byte mit dem Wert %02Xh spiegeln?\ngespiegelter Wert: %02Xh", this.fileBytes[n4] & 0xFF, HexEditFrm.toReverseByte(this.fileBytes[n4]));
            }
            if (string != null && BaseDlg.showYesNoDlg(this, string)) {
                for (int i = n4; i <= n5; ++i) {
                    this.fileBytes[i] = (byte)HexEditFrm.toReverseByte(this.fileBytes[i]);
                }
                this.setDataChanged(true);
                this.updView();
                this.setSelection(n4, n5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBytesSave() {
        block7: {
            File file;
            int n;
            int n2 = this.getDataLength();
            int n3 = this.hexCharFld.getCaretPosition();
            int n4 = this.hexCharFld.getMarkPosition();
            int n5 = -1;
            int n6 = -1;
            if (n3 >= 0 && n4 >= 0) {
                n5 = Math.min(n3, n4);
                n6 = Math.max(n3, n4);
            } else {
                n5 = n3;
                n6 = n3;
            }
            if (n6 >= n2) {
                n6 = n2 - 1;
            }
            if (n5 < 0 || (n = Math.min(n6, this.fileBytes.length) - n5 + 1) <= 0 || (file = EmuUtil.showFileSaveDlg(this, "Datei speichern", Main.getLastDirFile("hexedit"), new FileFilter[0])) == null) break block7;
            try {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    ((OutputStream)fileOutputStream).write(this.fileBytes, n5, n);
                    ((OutputStream)fileOutputStream).close();
                    fileOutputStream = null;
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(fileOutputStream);
                    throw throwable;
                }
                EmuUtil.closeSilent(fileOutputStream);
                Main.setLastFile(file, "hexedit");
            }
            catch (Exception exception) {
                BaseDlg.showErrorDlg((Component)this, exception);
            }
        }
    }

    private void doFileAppend() {
        block6: {
            File file = EmuUtil.showFileOpenDlg(this, "Datei anh\u00e4ngen", Main.getLastDirFile("hexedit"), new FileFilter[0]);
            if (file != null) {
                try {
                    byte[] byArray;
                    int n = this.fileLen;
                    long l = file.length();
                    if (l > 0L && l + (long)n > Integer.MAX_VALUE) {
                        HexEditFrm.throwFileTooBig();
                    }
                    if ((byArray = EmuUtil.readFile(file, false, Integer.MAX_VALUE)) == null || byArray.length <= 0) break block6;
                    try {
                        this.insertBytes(this.fileLen, byArray, 0);
                    }
                    catch (SizeLimitExceededException sizeLimitExceededException) {
                        BaseDlg.showErrorDlg((Component)this, sizeLimitExceededException.getMessage());
                    }
                    this.setDataChanged(true);
                    this.updView();
                    this.setSelection(n, this.fileLen - 1);
                    Main.setLastFile(file, "hexedit");
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this, iOException);
                }
            }
        }
    }

    private void doFileInsert() {
        block6: {
            File file;
            int n = this.hexCharFld.getCaretPosition();
            if (n >= 0 && n < this.fileLen && (file = EmuUtil.showFileOpenDlg(this, "Datei einf\u00fcgen", Main.getLastDirFile("hexedit"), new FileFilter[0])) != null) {
                try {
                    byte[] byArray;
                    long l = file.length();
                    if (l > 0L && l + (long)this.fileLen > Integer.MAX_VALUE) {
                        HexEditFrm.throwFileTooBig();
                    }
                    if ((byArray = EmuUtil.readFile(file, false, Integer.MAX_VALUE)) == null || byArray.length <= 0) break block6;
                    try {
                        this.insertBytes(n, byArray, 0);
                    }
                    catch (SizeLimitExceededException sizeLimitExceededException) {
                        BaseDlg.showErrorDlg((Component)this, sizeLimitExceededException.getMessage());
                    }
                    this.setDataChanged(true);
                    this.updView();
                    this.setSelection(n, n + byArray.length - 1);
                    Main.setLastFile(file, "hexedit");
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this, iOException);
                }
            }
        }
    }

    private void doGotoSavedPos(boolean bl) {
        if (this.savedPos >= 0) {
            this.hexCharFld.setCaretPosition(this.savedPos, bl);
            this.updCaretPosFields();
        }
    }

    private void doOpen() {
        File file;
        if (this.confirmDataSaved() && (file = EmuUtil.showFileOpenDlg(this, "Datei \u00f6ffnen", Main.getLastDirFile("hexedit"), new FileFilter[0])) != null) {
            this.openFileInternal(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSave(boolean bl) {
        boolean bl2 = false;
        File file = this.file;
        if (bl || file == null) {
            file = EmuUtil.showFileSaveDlg(this, "Datei speichern", file != null ? file : Main.getLastDirFile("hexedit"), new FileFilter[0]);
        }
        if (file != null) {
            try {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    if (this.fileLen > 0 && this.fileBytes.length > 0) {
                        ((OutputStream)fileOutputStream).write(this.fileBytes, 0, Math.min(this.fileLen, this.fileBytes.length));
                    }
                    ((OutputStream)fileOutputStream).close();
                    fileOutputStream = null;
                    this.file = file;
                    bl2 = true;
                    if (!this.setDataChanged(false)) {
                        this.updTitle();
                    }
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(fileOutputStream);
                    throw throwable;
                }
                EmuUtil.closeSilent(fileOutputStream);
                Main.setLastFile(file, "hexedit");
            }
            catch (Exception exception) {
                BaseDlg.showErrorDlg((Component)this, exception);
            }
        }
        return bl2;
    }

    private void doSavePos() {
        int n = this.hexCharFld.getCaretPosition();
        if (n >= 0) {
            this.savedPos = n;
            this.mnuGotoSavedPos.setEnabled(true);
            this.mnuSelectToSavedPos.setEnabled(true);
        }
    }

    private HexEditFrm() {
        this.updTitle();
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        this.mnuNew = this.createJMenuItem("Neu");
        jMenu.add(this.mnuNew);
        this.mnuOpen = this.createJMenuItem("\u00d6ffnen...");
        jMenu.add(this.mnuOpen);
        jMenu.addSeparator();
        this.mnuSave = this.createJMenuItem("Speichern", KeyStroke.getKeyStroke(83, 2));
        this.mnuSave.setEnabled(false);
        jMenu.add(this.mnuSave);
        this.mnuSaveAs = this.createJMenuItem("Speichern unter...");
        this.mnuSaveAs.setEnabled(false);
        jMenu.add(this.mnuSaveAs);
        jMenu.addSeparator();
        this.mnuPrintOptions = this.createJMenuItem("Druckoptionen...");
        jMenu.add(this.mnuPrintOptions);
        this.mnuPrint = this.createJMenuItem("Drucken...", KeyStroke.getKeyStroke(80, 2));
        this.mnuPrint.setEnabled(false);
        jMenu.add(this.mnuPrint);
        jMenu.addSeparator();
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        jMenuBar.add(jMenu2);
        this.mnuBytesCopyHex = this.createJMenuItem("Ausgw\u00e4hlte Bytes als Hexadezimalzahlen kopieren");
        this.mnuBytesCopyHex.setEnabled(false);
        jMenu2.add(this.mnuBytesCopyHex);
        this.mnuBytesCopyAscii = this.createJMenuItem("Ausgw\u00e4hlte Bytes als ASCII-Text kopieren");
        this.mnuBytesCopyAscii.setEnabled(false);
        jMenu2.add(this.mnuBytesCopyAscii);
        this.mnuBytesCopyDump = this.createJMenuItem("Ausgw\u00e4hlte Bytes als Hex-ASCII-Dump kopieren");
        this.mnuBytesCopyDump.setEnabled(false);
        jMenu2.add(this.mnuBytesCopyDump);
        jMenu2.addSeparator();
        this.mnuBytesInsert = this.createJMenuItem("Bytes einf\u00fcgen...", KeyStroke.getKeyStroke(73, 2));
        this.mnuBytesInsert.setEnabled(false);
        jMenu2.add(this.mnuBytesInsert);
        this.mnuBytesOverwrite = this.createJMenuItem("Bytes \u00fcberschreiben...", KeyStroke.getKeyStroke(79, 2));
        this.mnuBytesOverwrite.setEnabled(false);
        jMenu2.add(this.mnuBytesOverwrite);
        this.mnuBytesAppend = this.createJMenuItem("Bytes am Ende anh\u00e4ngen...", KeyStroke.getKeyStroke(69, 2));
        jMenu2.add(this.mnuBytesAppend);
        jMenu2.addSeparator();
        this.mnuBytesSave = this.createJMenuItem("Ausgew\u00e4hlte Bytes speichern...");
        this.mnuBytesSave.setEnabled(false);
        jMenu2.add(this.mnuBytesSave);
        this.mnuBytesInvert = this.createJMenuItem("Ausgew\u00e4hlte Bytes invertieren");
        this.mnuBytesInvert.setEnabled(false);
        jMenu2.add(this.mnuBytesInvert);
        this.mnuBytesReverse = this.createJMenuItem("Ausgew\u00e4hlte Bytes spiegeln");
        this.mnuBytesReverse.setEnabled(false);
        jMenu2.add(this.mnuBytesReverse);
        this.mnuBytesRemove = this.createJMenuItem("Ausgew\u00e4hlte Bytes entfernen", KeyStroke.getKeyStroke(127, 0));
        this.mnuBytesRemove.setEnabled(false);
        jMenu2.add(this.mnuBytesRemove);
        jMenu2.addSeparator();
        this.mnuFileInsert = this.createJMenuItem("Datei einf\u00fcgen...");
        this.mnuFileInsert.setEnabled(false);
        jMenu2.add(this.mnuFileInsert);
        this.mnuFileAppend = this.createJMenuItem("Datei am Ende anh\u00e4ngen...");
        jMenu2.add(this.mnuFileAppend);
        jMenu2.addSeparator();
        this.mnuSavePos = this.createJMenuItem("Position merken");
        this.mnuSavePos.setEnabled(false);
        jMenu2.add(this.mnuSavePos);
        this.mnuGotoSavedPos = this.createJMenuItem("Zur gemerkten Position springen");
        this.mnuGotoSavedPos.setEnabled(false);
        jMenu2.add(this.mnuGotoSavedPos);
        this.mnuSelectToSavedPos = this.createJMenuItem("Bis zur gemerkten Position ausw\u00e4hlen");
        this.mnuSelectToSavedPos.setEnabled(false);
        jMenu2.add(this.mnuSelectToSavedPos);
        this.mnuSelectAll = this.createJMenuItem("Alles ausw\u00e4hlen");
        this.mnuSelectAll.setEnabled(false);
        jMenu2.add(this.mnuSelectAll);
        jMenu2.addSeparator();
        this.mnuChecksum = this.createJMenuItem("Pr\u00fcfsumme/Hash-Wert...");
        this.mnuChecksum.setEnabled(false);
        jMenu2.add(this.mnuChecksum);
        jMenu2.addSeparator();
        this.mnuFind = this.createJMenuItem("Suchen...", KeyStroke.getKeyStroke(70, 2));
        this.mnuFind.setEnabled(false);
        jMenu2.add(this.mnuFind);
        this.mnuFindNext = this.createJMenuItem("Weitersuchen", KeyStroke.getKeyStroke(114, 0));
        this.mnuFindNext.setEnabled(false);
        jMenu2.add(this.mnuFindNext);
        JMenu jMenu3 = new JMenu("?");
        jMenuBar.add(jMenu3);
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu3.add(this.mnuHelpContent);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        this.add((Component)jToolBar, gridBagConstraints);
        this.btnNew = this.createImageButton("/images/file/new.png", "Neu");
        jToolBar.add(this.btnNew);
        this.btnOpen = this.createImageButton("/images/file/open.png", "\u00d6ffnen");
        jToolBar.add(this.btnOpen);
        this.btnSave = this.createImageButton("/images/file/save.png", "Speichern");
        this.btnSave.setEnabled(false);
        jToolBar.add(this.btnSave);
        jToolBar.addSeparator();
        this.btnFind = this.createImageButton("/images/edit/find.png", "Suchen");
        this.btnFind.setEnabled(false);
        jToolBar.add(this.btnFind);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        this.add(this.createHexCharFld(), gridBagConstraints);
        this.hexCharFld.setPreferredSize(new Dimension(this.hexCharFld.getDefaultPreferredWidth(), 300));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.add(this.createCaretPosFld("Cursor-Position"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.createValueFld(), gridBagConstraints);
        new DropTarget(this.hexCharFld, this).setActive(true);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setScreenCentered();
        }
        this.setResizable(true);
        this.hexCharFld.setPreferredSize(null);
    }

    private boolean confirmDataSaved() {
        boolean bl = true;
        if (this.dataChanged) {
            this.setState(0);
            this.toFront();
            Object[] objectArray = new String[]{"Speichern", "Verwerfen", "Abbrechen"};
            int n = JOptionPane.showOptionDialog(this, "Die Datei wurde ge\u00e4ndert und nicht gespeichert.\nM\u00f6chten Sie jetzt speichern?", "Daten ge\u00e4ndert", 1, 2, null, objectArray, "Speichern");
            if (n == 0) {
                bl = this.doSave(false);
            } else if (n != 1) {
                bl = false;
            }
        }
        return bl;
    }

    private void insertBytes(int n, byte[] byArray, int n2) throws SizeLimitExceededException {
        if (n2 >= 0 && n2 < byArray.length && byArray.length > 0) {
            int n3 = byArray.length - n2;
            int n4 = this.fileLen + n3;
            if (n4 >= this.fileBytes.length) {
                int n5 = Math.min(n4 + 8192, Integer.MAX_VALUE);
                if (n5 < n4) {
                    throw new SizeLimitExceededException("Die max. zul\u00e4ssige Dateigr\u00f6\u00dfe wurde erreicht.");
                }
                byte[] byArray2 = new byte[n5];
                if (n > 0) {
                    System.arraycopy(this.fileBytes, 0, byArray2, 0, n);
                }
                System.arraycopy(byArray, n2, byArray2, n, n3);
                if (n < this.fileLen) {
                    System.arraycopy(this.fileBytes, n, byArray2, n + n3, this.fileLen - n);
                }
                this.fileBytes = byArray2;
            } else {
                for (int i = this.fileLen - 1; i >= n; --i) {
                    this.fileBytes[i + n3] = this.fileBytes[i];
                }
                System.arraycopy(byArray, n2, this.fileBytes, n, n3);
            }
            this.fileLen += n3;
        }
    }

    private void newFileInternal(byte[] byArray) {
        if (byArray != null) {
            this.fileBytes = new byte[byArray.length + 256];
            if (byArray.length > 0) {
                System.arraycopy(byArray, 0, this.fileBytes, 0, byArray.length);
            }
            this.fileLen = byArray.length;
        } else {
            this.fileBytes = new byte[256];
            this.fileLen = 0;
        }
        this.file = null;
        this.setDataChanged(false);
        this.updTitle();
        this.updView();
        this.setCaretPosition(-1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFileInternal(File file) {
        try {
            FileInputStream fileInputStream = null;
            try {
                int n;
                int n2;
                long l = file.length();
                if (l > Integer.MAX_VALUE) {
                    HexEditFrm.throwFileTooBig();
                }
                if (l > 0L) {
                    l = l * 10L / 9L;
                }
                if (l < 8192L) {
                    l = 8192L;
                } else if (l > Integer.MAX_VALUE) {
                    l = Integer.MAX_VALUE;
                }
                byte[] byArray = new byte[(int)l];
                fileInputStream = new FileInputStream(file);
                for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) > 0; n += n2) {
                }
                if (n >= byArray.length) {
                    n2 = ((InputStream)fileInputStream).read();
                    while (n2 != -1) {
                        if (n >= byArray.length) {
                            int n3 = Math.min(n + 8192, Integer.MAX_VALUE);
                            if (n >= n3) {
                                HexEditFrm.throwFileTooBig();
                            }
                            byte[] byArray2 = new byte[n3];
                            System.arraycopy(byArray, 0, byArray2, 0, n);
                            byArray = byArray2;
                        }
                        byArray[n++] = (byte)n2;
                        n2 = ((InputStream)fileInputStream).read();
                    }
                }
                ((InputStream)fileInputStream).close();
                this.file = file;
                this.fileBytes = byArray;
                this.fileLen = n;
                this.savedPos = -1;
                this.mnuGotoSavedPos.setEnabled(false);
                this.mnuSelectToSavedPos.setEnabled(false);
                if (!this.setDataChanged(false)) {
                    this.updTitle();
                }
                this.updView();
                this.setCaretPosition(-1, false);
                Main.setLastFile(file, "hexedit");
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(fileInputStream);
                throw throwable;
            }
            EmuUtil.closeSilent(fileInputStream);
        }
        catch (IOException iOException) {
            BaseDlg.showErrorDlg((Component)this, iOException);
        }
    }

    private boolean setDataChanged(boolean bl) {
        boolean bl2 = false;
        if (bl != this.dataChanged) {
            this.dataChanged = bl;
            this.updTitle();
            this.mnuSave.setEnabled(this.dataChanged);
            this.btnSave.setEnabled(this.dataChanged);
            bl2 = true;
        }
        return bl2;
    }

    private static void throwFileTooBig() throws IOException {
        throw new IOException("Datei ist zu gro\u00df!");
    }

    private static int toReverseByte(int n) {
        return n >> 7 & 1 | n >> 5 & 2 | n >> 3 & 4 | n >> 1 & 8 | n << 1 & 0x10 | n << 3 & 0x20 | n << 5 & 0x40 | n << 7 & 0x80;
    }

    private void updTitle() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("JKCEMU Hex-Editor: ");
        if (this.file != null) {
            stringBuilder.append(this.file.getPath());
        } else {
            stringBuilder.append("Neue Datei");
        }
        this.setTitle(stringBuilder.toString());
    }
}

